/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemakergeospatial.model.EoCloudCoverInput;
import software.amazon.awssdk.services.sagemakergeospatial.model.LandsatCloudCoverLandInput;
import software.amazon.awssdk.services.sagemakergeospatial.model.PlatformInput;
import software.amazon.awssdk.services.sagemakergeospatial.model.ViewOffNadirInput;
import software.amazon.awssdk.services.sagemakergeospatial.model.ViewSunAzimuthInput;
import software.amazon.awssdk.services.sagemakergeospatial.model.ViewSunElevationInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Property
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Property> {
    private static final SdkField<EoCloudCoverInput> EO_CLOUD_COVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EoCloudCover").getter(Property.getter(Property::eoCloudCover)).setter(Property.setter(Builder::eoCloudCover)).constructor(EoCloudCoverInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EoCloudCover").build()}).build();
    private static final SdkField<LandsatCloudCoverLandInput> LANDSAT_CLOUD_COVER_LAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LandsatCloudCoverLand").getter(Property.getter(Property::landsatCloudCoverLand)).setter(Property.setter(Builder::landsatCloudCoverLand)).constructor(LandsatCloudCoverLandInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LandsatCloudCoverLand").build()}).build();
    private static final SdkField<PlatformInput> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Platform").getter(Property.getter(Property::platform)).setter(Property.setter(Builder::platform)).constructor(PlatformInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()}).build();
    private static final SdkField<ViewOffNadirInput> VIEW_OFF_NADIR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ViewOffNadir").getter(Property.getter(Property::viewOffNadir)).setter(Property.setter(Builder::viewOffNadir)).constructor(ViewOffNadirInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewOffNadir").build()}).build();
    private static final SdkField<ViewSunAzimuthInput> VIEW_SUN_AZIMUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ViewSunAzimuth").getter(Property.getter(Property::viewSunAzimuth)).setter(Property.setter(Builder::viewSunAzimuth)).constructor(ViewSunAzimuthInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewSunAzimuth").build()}).build();
    private static final SdkField<ViewSunElevationInput> VIEW_SUN_ELEVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ViewSunElevation").getter(Property.getter(Property::viewSunElevation)).setter(Property.setter(Builder::viewSunElevation)).constructor(ViewSunElevationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewSunElevation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EO_CLOUD_COVER_FIELD, LANDSAT_CLOUD_COVER_LAND_FIELD, PLATFORM_FIELD, VIEW_OFF_NADIR_FIELD, VIEW_SUN_AZIMUTH_FIELD, VIEW_SUN_ELEVATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Property.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EoCloudCoverInput eoCloudCover;
    private final LandsatCloudCoverLandInput landsatCloudCoverLand;
    private final PlatformInput platform;
    private final ViewOffNadirInput viewOffNadir;
    private final ViewSunAzimuthInput viewSunAzimuth;
    private final ViewSunElevationInput viewSunElevation;
    private final Type type;

    private Property(BuilderImpl builder) {
        this.eoCloudCover = builder.eoCloudCover;
        this.landsatCloudCoverLand = builder.landsatCloudCoverLand;
        this.platform = builder.platform;
        this.viewOffNadir = builder.viewOffNadir;
        this.viewSunAzimuth = builder.viewSunAzimuth;
        this.viewSunElevation = builder.viewSunElevation;
        this.type = builder.type;
    }

    public final EoCloudCoverInput eoCloudCover() {
        return this.eoCloudCover;
    }

    public final LandsatCloudCoverLandInput landsatCloudCoverLand() {
        return this.landsatCloudCoverLand;
    }

    public final PlatformInput platform() {
        return this.platform;
    }

    public final ViewOffNadirInput viewOffNadir() {
        return this.viewOffNadir;
    }

    public final ViewSunAzimuthInput viewSunAzimuth() {
        return this.viewSunAzimuth;
    }

    public final ViewSunElevationInput viewSunElevation() {
        return this.viewSunElevation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eoCloudCover());
        hashCode = 31 * hashCode + Objects.hashCode(this.landsatCloudCoverLand());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewOffNadir());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewSunAzimuth());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewSunElevation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Property)) {
            return false;
        }
        Property other = (Property)obj;
        return Objects.equals(this.eoCloudCover(), other.eoCloudCover()) && Objects.equals(this.landsatCloudCoverLand(), other.landsatCloudCoverLand()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.viewOffNadir(), other.viewOffNadir()) && Objects.equals(this.viewSunAzimuth(), other.viewSunAzimuth()) && Objects.equals(this.viewSunElevation(), other.viewSunElevation());
    }

    public final String toString() {
        return ToString.builder((String)"Property").add("EoCloudCover", (Object)this.eoCloudCover()).add("LandsatCloudCoverLand", (Object)this.landsatCloudCoverLand()).add("Platform", (Object)this.platform()).add("ViewOffNadir", (Object)this.viewOffNadir()).add("ViewSunAzimuth", (Object)this.viewSunAzimuth()).add("ViewSunElevation", (Object)this.viewSunElevation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EoCloudCover": {
                return Optional.ofNullable(clazz.cast(this.eoCloudCover()));
            }
            case "LandsatCloudCoverLand": {
                return Optional.ofNullable(clazz.cast(this.landsatCloudCoverLand()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "ViewOffNadir": {
                return Optional.ofNullable(clazz.cast(this.viewOffNadir()));
            }
            case "ViewSunAzimuth": {
                return Optional.ofNullable(clazz.cast(this.viewSunAzimuth()));
            }
            case "ViewSunElevation": {
                return Optional.ofNullable(clazz.cast(this.viewSunElevation()));
            }
        }
        return Optional.empty();
    }

    public static Property fromEoCloudCover(EoCloudCoverInput eoCloudCover) {
        return (Property)Property.builder().eoCloudCover(eoCloudCover).build();
    }

    public static Property fromEoCloudCover(Consumer<EoCloudCoverInput.Builder> eoCloudCover) {
        EoCloudCoverInput.Builder builder = EoCloudCoverInput.builder();
        eoCloudCover.accept(builder);
        return Property.fromEoCloudCover((EoCloudCoverInput)builder.build());
    }

    public static Property fromLandsatCloudCoverLand(LandsatCloudCoverLandInput landsatCloudCoverLand) {
        return (Property)Property.builder().landsatCloudCoverLand(landsatCloudCoverLand).build();
    }

    public static Property fromLandsatCloudCoverLand(Consumer<LandsatCloudCoverLandInput.Builder> landsatCloudCoverLand) {
        LandsatCloudCoverLandInput.Builder builder = LandsatCloudCoverLandInput.builder();
        landsatCloudCoverLand.accept(builder);
        return Property.fromLandsatCloudCoverLand((LandsatCloudCoverLandInput)builder.build());
    }

    public static Property fromPlatform(PlatformInput platform) {
        return (Property)Property.builder().platform(platform).build();
    }

    public static Property fromPlatform(Consumer<PlatformInput.Builder> platform) {
        PlatformInput.Builder builder = PlatformInput.builder();
        platform.accept(builder);
        return Property.fromPlatform((PlatformInput)builder.build());
    }

    public static Property fromViewOffNadir(ViewOffNadirInput viewOffNadir) {
        return (Property)Property.builder().viewOffNadir(viewOffNadir).build();
    }

    public static Property fromViewOffNadir(Consumer<ViewOffNadirInput.Builder> viewOffNadir) {
        ViewOffNadirInput.Builder builder = ViewOffNadirInput.builder();
        viewOffNadir.accept(builder);
        return Property.fromViewOffNadir((ViewOffNadirInput)builder.build());
    }

    public static Property fromViewSunAzimuth(ViewSunAzimuthInput viewSunAzimuth) {
        return (Property)Property.builder().viewSunAzimuth(viewSunAzimuth).build();
    }

    public static Property fromViewSunAzimuth(Consumer<ViewSunAzimuthInput.Builder> viewSunAzimuth) {
        ViewSunAzimuthInput.Builder builder = ViewSunAzimuthInput.builder();
        viewSunAzimuth.accept(builder);
        return Property.fromViewSunAzimuth((ViewSunAzimuthInput)builder.build());
    }

    public static Property fromViewSunElevation(ViewSunElevationInput viewSunElevation) {
        return (Property)Property.builder().viewSunElevation(viewSunElevation).build();
    }

    public static Property fromViewSunElevation(Consumer<ViewSunElevationInput.Builder> viewSunElevation) {
        ViewSunElevationInput.Builder builder = ViewSunElevationInput.builder();
        viewSunElevation.accept(builder);
        return Property.fromViewSunElevation((ViewSunElevationInput)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EoCloudCover", EO_CLOUD_COVER_FIELD);
        map.put("LandsatCloudCoverLand", LANDSAT_CLOUD_COVER_LAND_FIELD);
        map.put("Platform", PLATFORM_FIELD);
        map.put("ViewOffNadir", VIEW_OFF_NADIR_FIELD);
        map.put("ViewSunAzimuth", VIEW_SUN_AZIMUTH_FIELD);
        map.put("ViewSunElevation", VIEW_SUN_ELEVATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Property, T> g) {
        return obj -> g.apply((Property)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        EO_CLOUD_COVER,
        LANDSAT_CLOUD_COVER_LAND,
        PLATFORM,
        VIEW_OFF_NADIR,
        VIEW_SUN_AZIMUTH,
        VIEW_SUN_ELEVATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private EoCloudCoverInput eoCloudCover;
        private LandsatCloudCoverLandInput landsatCloudCoverLand;
        private PlatformInput platform;
        private ViewOffNadirInput viewOffNadir;
        private ViewSunAzimuthInput viewSunAzimuth;
        private ViewSunElevationInput viewSunElevation;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Property model) {
            this.eoCloudCover(model.eoCloudCover);
            this.landsatCloudCoverLand(model.landsatCloudCoverLand);
            this.platform(model.platform);
            this.viewOffNadir(model.viewOffNadir);
            this.viewSunAzimuth(model.viewSunAzimuth);
            this.viewSunElevation(model.viewSunElevation);
        }

        public final EoCloudCoverInput.Builder getEoCloudCover() {
            return this.eoCloudCover != null ? this.eoCloudCover.toBuilder() : null;
        }

        public final void setEoCloudCover(EoCloudCoverInput.BuilderImpl eoCloudCover) {
            EoCloudCoverInput oldValue = this.eoCloudCover;
            this.eoCloudCover = eoCloudCover != null ? eoCloudCover.build() : null;
            this.handleUnionValueChange(Type.EO_CLOUD_COVER, oldValue, this.eoCloudCover);
        }

        @Override
        public final Builder eoCloudCover(EoCloudCoverInput eoCloudCover) {
            EoCloudCoverInput oldValue = this.eoCloudCover;
            this.eoCloudCover = eoCloudCover;
            this.handleUnionValueChange(Type.EO_CLOUD_COVER, oldValue, this.eoCloudCover);
            return this;
        }

        public final LandsatCloudCoverLandInput.Builder getLandsatCloudCoverLand() {
            return this.landsatCloudCoverLand != null ? this.landsatCloudCoverLand.toBuilder() : null;
        }

        public final void setLandsatCloudCoverLand(LandsatCloudCoverLandInput.BuilderImpl landsatCloudCoverLand) {
            LandsatCloudCoverLandInput oldValue = this.landsatCloudCoverLand;
            this.landsatCloudCoverLand = landsatCloudCoverLand != null ? landsatCloudCoverLand.build() : null;
            this.handleUnionValueChange(Type.LANDSAT_CLOUD_COVER_LAND, oldValue, this.landsatCloudCoverLand);
        }

        @Override
        public final Builder landsatCloudCoverLand(LandsatCloudCoverLandInput landsatCloudCoverLand) {
            LandsatCloudCoverLandInput oldValue = this.landsatCloudCoverLand;
            this.landsatCloudCoverLand = landsatCloudCoverLand;
            this.handleUnionValueChange(Type.LANDSAT_CLOUD_COVER_LAND, oldValue, this.landsatCloudCoverLand);
            return this;
        }

        public final PlatformInput.Builder getPlatform() {
            return this.platform != null ? this.platform.toBuilder() : null;
        }

        public final void setPlatform(PlatformInput.BuilderImpl platform) {
            PlatformInput oldValue = this.platform;
            this.platform = platform != null ? platform.build() : null;
            this.handleUnionValueChange(Type.PLATFORM, oldValue, this.platform);
        }

        @Override
        public final Builder platform(PlatformInput platform) {
            PlatformInput oldValue = this.platform;
            this.platform = platform;
            this.handleUnionValueChange(Type.PLATFORM, oldValue, this.platform);
            return this;
        }

        public final ViewOffNadirInput.Builder getViewOffNadir() {
            return this.viewOffNadir != null ? this.viewOffNadir.toBuilder() : null;
        }

        public final void setViewOffNadir(ViewOffNadirInput.BuilderImpl viewOffNadir) {
            ViewOffNadirInput oldValue = this.viewOffNadir;
            this.viewOffNadir = viewOffNadir != null ? viewOffNadir.build() : null;
            this.handleUnionValueChange(Type.VIEW_OFF_NADIR, oldValue, this.viewOffNadir);
        }

        @Override
        public final Builder viewOffNadir(ViewOffNadirInput viewOffNadir) {
            ViewOffNadirInput oldValue = this.viewOffNadir;
            this.viewOffNadir = viewOffNadir;
            this.handleUnionValueChange(Type.VIEW_OFF_NADIR, oldValue, this.viewOffNadir);
            return this;
        }

        public final ViewSunAzimuthInput.Builder getViewSunAzimuth() {
            return this.viewSunAzimuth != null ? this.viewSunAzimuth.toBuilder() : null;
        }

        public final void setViewSunAzimuth(ViewSunAzimuthInput.BuilderImpl viewSunAzimuth) {
            ViewSunAzimuthInput oldValue = this.viewSunAzimuth;
            this.viewSunAzimuth = viewSunAzimuth != null ? viewSunAzimuth.build() : null;
            this.handleUnionValueChange(Type.VIEW_SUN_AZIMUTH, oldValue, this.viewSunAzimuth);
        }

        @Override
        public final Builder viewSunAzimuth(ViewSunAzimuthInput viewSunAzimuth) {
            ViewSunAzimuthInput oldValue = this.viewSunAzimuth;
            this.viewSunAzimuth = viewSunAzimuth;
            this.handleUnionValueChange(Type.VIEW_SUN_AZIMUTH, oldValue, this.viewSunAzimuth);
            return this;
        }

        public final ViewSunElevationInput.Builder getViewSunElevation() {
            return this.viewSunElevation != null ? this.viewSunElevation.toBuilder() : null;
        }

        public final void setViewSunElevation(ViewSunElevationInput.BuilderImpl viewSunElevation) {
            ViewSunElevationInput oldValue = this.viewSunElevation;
            this.viewSunElevation = viewSunElevation != null ? viewSunElevation.build() : null;
            this.handleUnionValueChange(Type.VIEW_SUN_ELEVATION, oldValue, this.viewSunElevation);
        }

        @Override
        public final Builder viewSunElevation(ViewSunElevationInput viewSunElevation) {
            ViewSunElevationInput oldValue = this.viewSunElevation;
            this.viewSunElevation = viewSunElevation;
            this.handleUnionValueChange(Type.VIEW_SUN_ELEVATION, oldValue, this.viewSunElevation);
            return this;
        }

        public Property build() {
            return new Property(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Property> {
        public Builder eoCloudCover(EoCloudCoverInput var1);

        default public Builder eoCloudCover(Consumer<EoCloudCoverInput.Builder> eoCloudCover) {
            return this.eoCloudCover((EoCloudCoverInput)((EoCloudCoverInput.Builder)EoCloudCoverInput.builder().applyMutation(eoCloudCover)).build());
        }

        public Builder landsatCloudCoverLand(LandsatCloudCoverLandInput var1);

        default public Builder landsatCloudCoverLand(Consumer<LandsatCloudCoverLandInput.Builder> landsatCloudCoverLand) {
            return this.landsatCloudCoverLand((LandsatCloudCoverLandInput)((LandsatCloudCoverLandInput.Builder)LandsatCloudCoverLandInput.builder().applyMutation(landsatCloudCoverLand)).build());
        }

        public Builder platform(PlatformInput var1);

        default public Builder platform(Consumer<PlatformInput.Builder> platform) {
            return this.platform((PlatformInput)((PlatformInput.Builder)PlatformInput.builder().applyMutation(platform)).build());
        }

        public Builder viewOffNadir(ViewOffNadirInput var1);

        default public Builder viewOffNadir(Consumer<ViewOffNadirInput.Builder> viewOffNadir) {
            return this.viewOffNadir((ViewOffNadirInput)((ViewOffNadirInput.Builder)ViewOffNadirInput.builder().applyMutation(viewOffNadir)).build());
        }

        public Builder viewSunAzimuth(ViewSunAzimuthInput var1);

        default public Builder viewSunAzimuth(Consumer<ViewSunAzimuthInput.Builder> viewSunAzimuth) {
            return this.viewSunAzimuth((ViewSunAzimuthInput)((ViewSunAzimuthInput.Builder)ViewSunAzimuthInput.builder().applyMutation(viewSunAzimuth)).build());
        }

        public Builder viewSunElevation(ViewSunElevationInput var1);

        default public Builder viewSunElevation(Consumer<ViewSunElevationInput.Builder> viewSunElevation) {
            return this.viewSunElevation((ViewSunElevationInput)((ViewSunElevationInput.Builder)ViewSunElevationInput.builder().applyMutation(viewSunElevation)).build());
        }
    }
}

