/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemakergeospatial.model.BandMathConfigInput;
import software.amazon.awssdk.services.sagemakergeospatial.model.CloudMaskingConfigInput;
import software.amazon.awssdk.services.sagemakergeospatial.model.CloudRemovalConfigInput;
import software.amazon.awssdk.services.sagemakergeospatial.model.GeoMosaicConfigInput;
import software.amazon.awssdk.services.sagemakergeospatial.model.LandCoverSegmentationConfigInput;
import software.amazon.awssdk.services.sagemakergeospatial.model.ResamplingConfigInput;
import software.amazon.awssdk.services.sagemakergeospatial.model.StackConfigInput;
import software.amazon.awssdk.services.sagemakergeospatial.model.TemporalStatisticsConfigInput;
import software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatisticsConfigInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobConfigInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobConfigInput> {
    private static final SdkField<BandMathConfigInput> BAND_MATH_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BandMathConfig").getter(JobConfigInput.getter(JobConfigInput::bandMathConfig)).setter(JobConfigInput.setter(Builder::bandMathConfig)).constructor(BandMathConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BandMathConfig").build()}).build();
    private static final SdkField<CloudMaskingConfigInput> CLOUD_MASKING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudMaskingConfig").getter(JobConfigInput.getter(JobConfigInput::cloudMaskingConfig)).setter(JobConfigInput.setter(Builder::cloudMaskingConfig)).constructor(CloudMaskingConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudMaskingConfig").build()}).build();
    private static final SdkField<CloudRemovalConfigInput> CLOUD_REMOVAL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudRemovalConfig").getter(JobConfigInput.getter(JobConfigInput::cloudRemovalConfig)).setter(JobConfigInput.setter(Builder::cloudRemovalConfig)).constructor(CloudRemovalConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudRemovalConfig").build()}).build();
    private static final SdkField<GeoMosaicConfigInput> GEO_MOSAIC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GeoMosaicConfig").getter(JobConfigInput.getter(JobConfigInput::geoMosaicConfig)).setter(JobConfigInput.setter(Builder::geoMosaicConfig)).constructor(GeoMosaicConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoMosaicConfig").build()}).build();
    private static final SdkField<LandCoverSegmentationConfigInput> LAND_COVER_SEGMENTATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LandCoverSegmentationConfig").getter(JobConfigInput.getter(JobConfigInput::landCoverSegmentationConfig)).setter(JobConfigInput.setter(Builder::landCoverSegmentationConfig)).constructor(LandCoverSegmentationConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LandCoverSegmentationConfig").build()}).build();
    private static final SdkField<ResamplingConfigInput> RESAMPLING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResamplingConfig").getter(JobConfigInput.getter(JobConfigInput::resamplingConfig)).setter(JobConfigInput.setter(Builder::resamplingConfig)).constructor(ResamplingConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResamplingConfig").build()}).build();
    private static final SdkField<StackConfigInput> STACK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StackConfig").getter(JobConfigInput.getter(JobConfigInput::stackConfig)).setter(JobConfigInput.setter(Builder::stackConfig)).constructor(StackConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackConfig").build()}).build();
    private static final SdkField<TemporalStatisticsConfigInput> TEMPORAL_STATISTICS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TemporalStatisticsConfig").getter(JobConfigInput.getter(JobConfigInput::temporalStatisticsConfig)).setter(JobConfigInput.setter(Builder::temporalStatisticsConfig)).constructor(TemporalStatisticsConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemporalStatisticsConfig").build()}).build();
    private static final SdkField<ZonalStatisticsConfigInput> ZONAL_STATISTICS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ZonalStatisticsConfig").getter(JobConfigInput.getter(JobConfigInput::zonalStatisticsConfig)).setter(JobConfigInput.setter(Builder::zonalStatisticsConfig)).constructor(ZonalStatisticsConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZonalStatisticsConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BAND_MATH_CONFIG_FIELD, CLOUD_MASKING_CONFIG_FIELD, CLOUD_REMOVAL_CONFIG_FIELD, GEO_MOSAIC_CONFIG_FIELD, LAND_COVER_SEGMENTATION_CONFIG_FIELD, RESAMPLING_CONFIG_FIELD, STACK_CONFIG_FIELD, TEMPORAL_STATISTICS_CONFIG_FIELD, ZONAL_STATISTICS_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JobConfigInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final BandMathConfigInput bandMathConfig;
    private final CloudMaskingConfigInput cloudMaskingConfig;
    private final CloudRemovalConfigInput cloudRemovalConfig;
    private final GeoMosaicConfigInput geoMosaicConfig;
    private final LandCoverSegmentationConfigInput landCoverSegmentationConfig;
    private final ResamplingConfigInput resamplingConfig;
    private final StackConfigInput stackConfig;
    private final TemporalStatisticsConfigInput temporalStatisticsConfig;
    private final ZonalStatisticsConfigInput zonalStatisticsConfig;
    private final Type type;

    private JobConfigInput(BuilderImpl builder) {
        this.bandMathConfig = builder.bandMathConfig;
        this.cloudMaskingConfig = builder.cloudMaskingConfig;
        this.cloudRemovalConfig = builder.cloudRemovalConfig;
        this.geoMosaicConfig = builder.geoMosaicConfig;
        this.landCoverSegmentationConfig = builder.landCoverSegmentationConfig;
        this.resamplingConfig = builder.resamplingConfig;
        this.stackConfig = builder.stackConfig;
        this.temporalStatisticsConfig = builder.temporalStatisticsConfig;
        this.zonalStatisticsConfig = builder.zonalStatisticsConfig;
        this.type = builder.type;
    }

    public final BandMathConfigInput bandMathConfig() {
        return this.bandMathConfig;
    }

    public final CloudMaskingConfigInput cloudMaskingConfig() {
        return this.cloudMaskingConfig;
    }

    public final CloudRemovalConfigInput cloudRemovalConfig() {
        return this.cloudRemovalConfig;
    }

    public final GeoMosaicConfigInput geoMosaicConfig() {
        return this.geoMosaicConfig;
    }

    public final LandCoverSegmentationConfigInput landCoverSegmentationConfig() {
        return this.landCoverSegmentationConfig;
    }

    public final ResamplingConfigInput resamplingConfig() {
        return this.resamplingConfig;
    }

    public final StackConfigInput stackConfig() {
        return this.stackConfig;
    }

    public final TemporalStatisticsConfigInput temporalStatisticsConfig() {
        return this.temporalStatisticsConfig;
    }

    public final ZonalStatisticsConfigInput zonalStatisticsConfig() {
        return this.zonalStatisticsConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bandMathConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudMaskingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudRemovalConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.geoMosaicConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.landCoverSegmentationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.resamplingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.temporalStatisticsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.zonalStatisticsConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobConfigInput)) {
            return false;
        }
        JobConfigInput other = (JobConfigInput)obj;
        return Objects.equals(this.bandMathConfig(), other.bandMathConfig()) && Objects.equals(this.cloudMaskingConfig(), other.cloudMaskingConfig()) && Objects.equals(this.cloudRemovalConfig(), other.cloudRemovalConfig()) && Objects.equals(this.geoMosaicConfig(), other.geoMosaicConfig()) && Objects.equals(this.landCoverSegmentationConfig(), other.landCoverSegmentationConfig()) && Objects.equals(this.resamplingConfig(), other.resamplingConfig()) && Objects.equals(this.stackConfig(), other.stackConfig()) && Objects.equals(this.temporalStatisticsConfig(), other.temporalStatisticsConfig()) && Objects.equals(this.zonalStatisticsConfig(), other.zonalStatisticsConfig());
    }

    public final String toString() {
        return ToString.builder((String)"JobConfigInput").add("BandMathConfig", (Object)this.bandMathConfig()).add("CloudMaskingConfig", (Object)this.cloudMaskingConfig()).add("CloudRemovalConfig", (Object)this.cloudRemovalConfig()).add("GeoMosaicConfig", (Object)this.geoMosaicConfig()).add("LandCoverSegmentationConfig", (Object)this.landCoverSegmentationConfig()).add("ResamplingConfig", (Object)this.resamplingConfig()).add("StackConfig", (Object)this.stackConfig()).add("TemporalStatisticsConfig", (Object)this.temporalStatisticsConfig()).add("ZonalStatisticsConfig", (Object)this.zonalStatisticsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BandMathConfig": {
                return Optional.ofNullable(clazz.cast(this.bandMathConfig()));
            }
            case "CloudMaskingConfig": {
                return Optional.ofNullable(clazz.cast(this.cloudMaskingConfig()));
            }
            case "CloudRemovalConfig": {
                return Optional.ofNullable(clazz.cast(this.cloudRemovalConfig()));
            }
            case "GeoMosaicConfig": {
                return Optional.ofNullable(clazz.cast(this.geoMosaicConfig()));
            }
            case "LandCoverSegmentationConfig": {
                return Optional.ofNullable(clazz.cast(this.landCoverSegmentationConfig()));
            }
            case "ResamplingConfig": {
                return Optional.ofNullable(clazz.cast(this.resamplingConfig()));
            }
            case "StackConfig": {
                return Optional.ofNullable(clazz.cast(this.stackConfig()));
            }
            case "TemporalStatisticsConfig": {
                return Optional.ofNullable(clazz.cast(this.temporalStatisticsConfig()));
            }
            case "ZonalStatisticsConfig": {
                return Optional.ofNullable(clazz.cast(this.zonalStatisticsConfig()));
            }
        }
        return Optional.empty();
    }

    public static JobConfigInput fromBandMathConfig(BandMathConfigInput bandMathConfig) {
        return (JobConfigInput)JobConfigInput.builder().bandMathConfig(bandMathConfig).build();
    }

    public static JobConfigInput fromBandMathConfig(Consumer<BandMathConfigInput.Builder> bandMathConfig) {
        BandMathConfigInput.Builder builder = BandMathConfigInput.builder();
        bandMathConfig.accept(builder);
        return JobConfigInput.fromBandMathConfig((BandMathConfigInput)builder.build());
    }

    public static JobConfigInput fromCloudMaskingConfig(CloudMaskingConfigInput cloudMaskingConfig) {
        return (JobConfigInput)JobConfigInput.builder().cloudMaskingConfig(cloudMaskingConfig).build();
    }

    public static JobConfigInput fromCloudMaskingConfig(Consumer<CloudMaskingConfigInput.Builder> cloudMaskingConfig) {
        CloudMaskingConfigInput.Builder builder = CloudMaskingConfigInput.builder();
        cloudMaskingConfig.accept(builder);
        return JobConfigInput.fromCloudMaskingConfig((CloudMaskingConfigInput)builder.build());
    }

    public static JobConfigInput fromCloudRemovalConfig(CloudRemovalConfigInput cloudRemovalConfig) {
        return (JobConfigInput)JobConfigInput.builder().cloudRemovalConfig(cloudRemovalConfig).build();
    }

    public static JobConfigInput fromCloudRemovalConfig(Consumer<CloudRemovalConfigInput.Builder> cloudRemovalConfig) {
        CloudRemovalConfigInput.Builder builder = CloudRemovalConfigInput.builder();
        cloudRemovalConfig.accept(builder);
        return JobConfigInput.fromCloudRemovalConfig((CloudRemovalConfigInput)builder.build());
    }

    public static JobConfigInput fromGeoMosaicConfig(GeoMosaicConfigInput geoMosaicConfig) {
        return (JobConfigInput)JobConfigInput.builder().geoMosaicConfig(geoMosaicConfig).build();
    }

    public static JobConfigInput fromGeoMosaicConfig(Consumer<GeoMosaicConfigInput.Builder> geoMosaicConfig) {
        GeoMosaicConfigInput.Builder builder = GeoMosaicConfigInput.builder();
        geoMosaicConfig.accept(builder);
        return JobConfigInput.fromGeoMosaicConfig((GeoMosaicConfigInput)builder.build());
    }

    public static JobConfigInput fromLandCoverSegmentationConfig(LandCoverSegmentationConfigInput landCoverSegmentationConfig) {
        return (JobConfigInput)JobConfigInput.builder().landCoverSegmentationConfig(landCoverSegmentationConfig).build();
    }

    public static JobConfigInput fromLandCoverSegmentationConfig(Consumer<LandCoverSegmentationConfigInput.Builder> landCoverSegmentationConfig) {
        LandCoverSegmentationConfigInput.Builder builder = LandCoverSegmentationConfigInput.builder();
        landCoverSegmentationConfig.accept(builder);
        return JobConfigInput.fromLandCoverSegmentationConfig((LandCoverSegmentationConfigInput)builder.build());
    }

    public static JobConfigInput fromResamplingConfig(ResamplingConfigInput resamplingConfig) {
        return (JobConfigInput)JobConfigInput.builder().resamplingConfig(resamplingConfig).build();
    }

    public static JobConfigInput fromResamplingConfig(Consumer<ResamplingConfigInput.Builder> resamplingConfig) {
        ResamplingConfigInput.Builder builder = ResamplingConfigInput.builder();
        resamplingConfig.accept(builder);
        return JobConfigInput.fromResamplingConfig((ResamplingConfigInput)builder.build());
    }

    public static JobConfigInput fromStackConfig(StackConfigInput stackConfig) {
        return (JobConfigInput)JobConfigInput.builder().stackConfig(stackConfig).build();
    }

    public static JobConfigInput fromStackConfig(Consumer<StackConfigInput.Builder> stackConfig) {
        StackConfigInput.Builder builder = StackConfigInput.builder();
        stackConfig.accept(builder);
        return JobConfigInput.fromStackConfig((StackConfigInput)builder.build());
    }

    public static JobConfigInput fromTemporalStatisticsConfig(TemporalStatisticsConfigInput temporalStatisticsConfig) {
        return (JobConfigInput)JobConfigInput.builder().temporalStatisticsConfig(temporalStatisticsConfig).build();
    }

    public static JobConfigInput fromTemporalStatisticsConfig(Consumer<TemporalStatisticsConfigInput.Builder> temporalStatisticsConfig) {
        TemporalStatisticsConfigInput.Builder builder = TemporalStatisticsConfigInput.builder();
        temporalStatisticsConfig.accept(builder);
        return JobConfigInput.fromTemporalStatisticsConfig((TemporalStatisticsConfigInput)builder.build());
    }

    public static JobConfigInput fromZonalStatisticsConfig(ZonalStatisticsConfigInput zonalStatisticsConfig) {
        return (JobConfigInput)JobConfigInput.builder().zonalStatisticsConfig(zonalStatisticsConfig).build();
    }

    public static JobConfigInput fromZonalStatisticsConfig(Consumer<ZonalStatisticsConfigInput.Builder> zonalStatisticsConfig) {
        ZonalStatisticsConfigInput.Builder builder = ZonalStatisticsConfigInput.builder();
        zonalStatisticsConfig.accept(builder);
        return JobConfigInput.fromZonalStatisticsConfig((ZonalStatisticsConfigInput)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BandMathConfig", BAND_MATH_CONFIG_FIELD);
        map.put("CloudMaskingConfig", CLOUD_MASKING_CONFIG_FIELD);
        map.put("CloudRemovalConfig", CLOUD_REMOVAL_CONFIG_FIELD);
        map.put("GeoMosaicConfig", GEO_MOSAIC_CONFIG_FIELD);
        map.put("LandCoverSegmentationConfig", LAND_COVER_SEGMENTATION_CONFIG_FIELD);
        map.put("ResamplingConfig", RESAMPLING_CONFIG_FIELD);
        map.put("StackConfig", STACK_CONFIG_FIELD);
        map.put("TemporalStatisticsConfig", TEMPORAL_STATISTICS_CONFIG_FIELD);
        map.put("ZonalStatisticsConfig", ZONAL_STATISTICS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobConfigInput, T> g) {
        return obj -> g.apply((JobConfigInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        BAND_MATH_CONFIG,
        CLOUD_MASKING_CONFIG,
        CLOUD_REMOVAL_CONFIG,
        GEO_MOSAIC_CONFIG,
        LAND_COVER_SEGMENTATION_CONFIG,
        RESAMPLING_CONFIG,
        STACK_CONFIG,
        TEMPORAL_STATISTICS_CONFIG,
        ZONAL_STATISTICS_CONFIG,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private BandMathConfigInput bandMathConfig;
        private CloudMaskingConfigInput cloudMaskingConfig;
        private CloudRemovalConfigInput cloudRemovalConfig;
        private GeoMosaicConfigInput geoMosaicConfig;
        private LandCoverSegmentationConfigInput landCoverSegmentationConfig;
        private ResamplingConfigInput resamplingConfig;
        private StackConfigInput stackConfig;
        private TemporalStatisticsConfigInput temporalStatisticsConfig;
        private ZonalStatisticsConfigInput zonalStatisticsConfig;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(JobConfigInput model) {
            this.bandMathConfig(model.bandMathConfig);
            this.cloudMaskingConfig(model.cloudMaskingConfig);
            this.cloudRemovalConfig(model.cloudRemovalConfig);
            this.geoMosaicConfig(model.geoMosaicConfig);
            this.landCoverSegmentationConfig(model.landCoverSegmentationConfig);
            this.resamplingConfig(model.resamplingConfig);
            this.stackConfig(model.stackConfig);
            this.temporalStatisticsConfig(model.temporalStatisticsConfig);
            this.zonalStatisticsConfig(model.zonalStatisticsConfig);
        }

        public final BandMathConfigInput.Builder getBandMathConfig() {
            return this.bandMathConfig != null ? this.bandMathConfig.toBuilder() : null;
        }

        public final void setBandMathConfig(BandMathConfigInput.BuilderImpl bandMathConfig) {
            BandMathConfigInput oldValue = this.bandMathConfig;
            this.bandMathConfig = bandMathConfig != null ? bandMathConfig.build() : null;
            this.handleUnionValueChange(Type.BAND_MATH_CONFIG, oldValue, this.bandMathConfig);
        }

        @Override
        public final Builder bandMathConfig(BandMathConfigInput bandMathConfig) {
            BandMathConfigInput oldValue = this.bandMathConfig;
            this.bandMathConfig = bandMathConfig;
            this.handleUnionValueChange(Type.BAND_MATH_CONFIG, oldValue, this.bandMathConfig);
            return this;
        }

        public final CloudMaskingConfigInput.Builder getCloudMaskingConfig() {
            return this.cloudMaskingConfig != null ? this.cloudMaskingConfig.toBuilder() : null;
        }

        public final void setCloudMaskingConfig(CloudMaskingConfigInput.BuilderImpl cloudMaskingConfig) {
            CloudMaskingConfigInput oldValue = this.cloudMaskingConfig;
            this.cloudMaskingConfig = cloudMaskingConfig != null ? cloudMaskingConfig.build() : null;
            this.handleUnionValueChange(Type.CLOUD_MASKING_CONFIG, oldValue, this.cloudMaskingConfig);
        }

        @Override
        public final Builder cloudMaskingConfig(CloudMaskingConfigInput cloudMaskingConfig) {
            CloudMaskingConfigInput oldValue = this.cloudMaskingConfig;
            this.cloudMaskingConfig = cloudMaskingConfig;
            this.handleUnionValueChange(Type.CLOUD_MASKING_CONFIG, oldValue, this.cloudMaskingConfig);
            return this;
        }

        public final CloudRemovalConfigInput.Builder getCloudRemovalConfig() {
            return this.cloudRemovalConfig != null ? this.cloudRemovalConfig.toBuilder() : null;
        }

        public final void setCloudRemovalConfig(CloudRemovalConfigInput.BuilderImpl cloudRemovalConfig) {
            CloudRemovalConfigInput oldValue = this.cloudRemovalConfig;
            this.cloudRemovalConfig = cloudRemovalConfig != null ? cloudRemovalConfig.build() : null;
            this.handleUnionValueChange(Type.CLOUD_REMOVAL_CONFIG, oldValue, this.cloudRemovalConfig);
        }

        @Override
        public final Builder cloudRemovalConfig(CloudRemovalConfigInput cloudRemovalConfig) {
            CloudRemovalConfigInput oldValue = this.cloudRemovalConfig;
            this.cloudRemovalConfig = cloudRemovalConfig;
            this.handleUnionValueChange(Type.CLOUD_REMOVAL_CONFIG, oldValue, this.cloudRemovalConfig);
            return this;
        }

        public final GeoMosaicConfigInput.Builder getGeoMosaicConfig() {
            return this.geoMosaicConfig != null ? this.geoMosaicConfig.toBuilder() : null;
        }

        public final void setGeoMosaicConfig(GeoMosaicConfigInput.BuilderImpl geoMosaicConfig) {
            GeoMosaicConfigInput oldValue = this.geoMosaicConfig;
            this.geoMosaicConfig = geoMosaicConfig != null ? geoMosaicConfig.build() : null;
            this.handleUnionValueChange(Type.GEO_MOSAIC_CONFIG, oldValue, this.geoMosaicConfig);
        }

        @Override
        public final Builder geoMosaicConfig(GeoMosaicConfigInput geoMosaicConfig) {
            GeoMosaicConfigInput oldValue = this.geoMosaicConfig;
            this.geoMosaicConfig = geoMosaicConfig;
            this.handleUnionValueChange(Type.GEO_MOSAIC_CONFIG, oldValue, this.geoMosaicConfig);
            return this;
        }

        public final LandCoverSegmentationConfigInput.Builder getLandCoverSegmentationConfig() {
            return this.landCoverSegmentationConfig != null ? this.landCoverSegmentationConfig.toBuilder() : null;
        }

        public final void setLandCoverSegmentationConfig(LandCoverSegmentationConfigInput.BuilderImpl landCoverSegmentationConfig) {
            LandCoverSegmentationConfigInput oldValue = this.landCoverSegmentationConfig;
            this.landCoverSegmentationConfig = landCoverSegmentationConfig != null ? landCoverSegmentationConfig.build() : null;
            this.handleUnionValueChange(Type.LAND_COVER_SEGMENTATION_CONFIG, oldValue, this.landCoverSegmentationConfig);
        }

        @Override
        public final Builder landCoverSegmentationConfig(LandCoverSegmentationConfigInput landCoverSegmentationConfig) {
            LandCoverSegmentationConfigInput oldValue = this.landCoverSegmentationConfig;
            this.landCoverSegmentationConfig = landCoverSegmentationConfig;
            this.handleUnionValueChange(Type.LAND_COVER_SEGMENTATION_CONFIG, oldValue, this.landCoverSegmentationConfig);
            return this;
        }

        public final ResamplingConfigInput.Builder getResamplingConfig() {
            return this.resamplingConfig != null ? this.resamplingConfig.toBuilder() : null;
        }

        public final void setResamplingConfig(ResamplingConfigInput.BuilderImpl resamplingConfig) {
            ResamplingConfigInput oldValue = this.resamplingConfig;
            this.resamplingConfig = resamplingConfig != null ? resamplingConfig.build() : null;
            this.handleUnionValueChange(Type.RESAMPLING_CONFIG, oldValue, this.resamplingConfig);
        }

        @Override
        public final Builder resamplingConfig(ResamplingConfigInput resamplingConfig) {
            ResamplingConfigInput oldValue = this.resamplingConfig;
            this.resamplingConfig = resamplingConfig;
            this.handleUnionValueChange(Type.RESAMPLING_CONFIG, oldValue, this.resamplingConfig);
            return this;
        }

        public final StackConfigInput.Builder getStackConfig() {
            return this.stackConfig != null ? this.stackConfig.toBuilder() : null;
        }

        public final void setStackConfig(StackConfigInput.BuilderImpl stackConfig) {
            StackConfigInput oldValue = this.stackConfig;
            this.stackConfig = stackConfig != null ? stackConfig.build() : null;
            this.handleUnionValueChange(Type.STACK_CONFIG, oldValue, this.stackConfig);
        }

        @Override
        public final Builder stackConfig(StackConfigInput stackConfig) {
            StackConfigInput oldValue = this.stackConfig;
            this.stackConfig = stackConfig;
            this.handleUnionValueChange(Type.STACK_CONFIG, oldValue, this.stackConfig);
            return this;
        }

        public final TemporalStatisticsConfigInput.Builder getTemporalStatisticsConfig() {
            return this.temporalStatisticsConfig != null ? this.temporalStatisticsConfig.toBuilder() : null;
        }

        public final void setTemporalStatisticsConfig(TemporalStatisticsConfigInput.BuilderImpl temporalStatisticsConfig) {
            TemporalStatisticsConfigInput oldValue = this.temporalStatisticsConfig;
            this.temporalStatisticsConfig = temporalStatisticsConfig != null ? temporalStatisticsConfig.build() : null;
            this.handleUnionValueChange(Type.TEMPORAL_STATISTICS_CONFIG, oldValue, this.temporalStatisticsConfig);
        }

        @Override
        public final Builder temporalStatisticsConfig(TemporalStatisticsConfigInput temporalStatisticsConfig) {
            TemporalStatisticsConfigInput oldValue = this.temporalStatisticsConfig;
            this.temporalStatisticsConfig = temporalStatisticsConfig;
            this.handleUnionValueChange(Type.TEMPORAL_STATISTICS_CONFIG, oldValue, this.temporalStatisticsConfig);
            return this;
        }

        public final ZonalStatisticsConfigInput.Builder getZonalStatisticsConfig() {
            return this.zonalStatisticsConfig != null ? this.zonalStatisticsConfig.toBuilder() : null;
        }

        public final void setZonalStatisticsConfig(ZonalStatisticsConfigInput.BuilderImpl zonalStatisticsConfig) {
            ZonalStatisticsConfigInput oldValue = this.zonalStatisticsConfig;
            this.zonalStatisticsConfig = zonalStatisticsConfig != null ? zonalStatisticsConfig.build() : null;
            this.handleUnionValueChange(Type.ZONAL_STATISTICS_CONFIG, oldValue, this.zonalStatisticsConfig);
        }

        @Override
        public final Builder zonalStatisticsConfig(ZonalStatisticsConfigInput zonalStatisticsConfig) {
            ZonalStatisticsConfigInput oldValue = this.zonalStatisticsConfig;
            this.zonalStatisticsConfig = zonalStatisticsConfig;
            this.handleUnionValueChange(Type.ZONAL_STATISTICS_CONFIG, oldValue, this.zonalStatisticsConfig);
            return this;
        }

        public JobConfigInput build() {
            return new JobConfigInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobConfigInput> {
        public Builder bandMathConfig(BandMathConfigInput var1);

        default public Builder bandMathConfig(Consumer<BandMathConfigInput.Builder> bandMathConfig) {
            return this.bandMathConfig((BandMathConfigInput)((BandMathConfigInput.Builder)BandMathConfigInput.builder().applyMutation(bandMathConfig)).build());
        }

        public Builder cloudMaskingConfig(CloudMaskingConfigInput var1);

        default public Builder cloudMaskingConfig(Consumer<CloudMaskingConfigInput.Builder> cloudMaskingConfig) {
            return this.cloudMaskingConfig((CloudMaskingConfigInput)((CloudMaskingConfigInput.Builder)CloudMaskingConfigInput.builder().applyMutation(cloudMaskingConfig)).build());
        }

        public Builder cloudRemovalConfig(CloudRemovalConfigInput var1);

        default public Builder cloudRemovalConfig(Consumer<CloudRemovalConfigInput.Builder> cloudRemovalConfig) {
            return this.cloudRemovalConfig((CloudRemovalConfigInput)((CloudRemovalConfigInput.Builder)CloudRemovalConfigInput.builder().applyMutation(cloudRemovalConfig)).build());
        }

        public Builder geoMosaicConfig(GeoMosaicConfigInput var1);

        default public Builder geoMosaicConfig(Consumer<GeoMosaicConfigInput.Builder> geoMosaicConfig) {
            return this.geoMosaicConfig((GeoMosaicConfigInput)((GeoMosaicConfigInput.Builder)GeoMosaicConfigInput.builder().applyMutation(geoMosaicConfig)).build());
        }

        public Builder landCoverSegmentationConfig(LandCoverSegmentationConfigInput var1);

        default public Builder landCoverSegmentationConfig(Consumer<LandCoverSegmentationConfigInput.Builder> landCoverSegmentationConfig) {
            return this.landCoverSegmentationConfig((LandCoverSegmentationConfigInput)((LandCoverSegmentationConfigInput.Builder)LandCoverSegmentationConfigInput.builder().applyMutation(landCoverSegmentationConfig)).build());
        }

        public Builder resamplingConfig(ResamplingConfigInput var1);

        default public Builder resamplingConfig(Consumer<ResamplingConfigInput.Builder> resamplingConfig) {
            return this.resamplingConfig((ResamplingConfigInput)((ResamplingConfigInput.Builder)ResamplingConfigInput.builder().applyMutation(resamplingConfig)).build());
        }

        public Builder stackConfig(StackConfigInput var1);

        default public Builder stackConfig(Consumer<StackConfigInput.Builder> stackConfig) {
            return this.stackConfig((StackConfigInput)((StackConfigInput.Builder)StackConfigInput.builder().applyMutation(stackConfig)).build());
        }

        public Builder temporalStatisticsConfig(TemporalStatisticsConfigInput var1);

        default public Builder temporalStatisticsConfig(Consumer<TemporalStatisticsConfigInput.Builder> temporalStatisticsConfig) {
            return this.temporalStatisticsConfig((TemporalStatisticsConfigInput)((TemporalStatisticsConfigInput.Builder)TemporalStatisticsConfigInput.builder().applyMutation(temporalStatisticsConfig)).build());
        }

        public Builder zonalStatisticsConfig(ZonalStatisticsConfigInput var1);

        default public Builder zonalStatisticsConfig(Consumer<ZonalStatisticsConfigInput.Builder> zonalStatisticsConfig) {
            return this.zonalStatisticsConfig((ZonalStatisticsConfigInput)((ZonalStatisticsConfigInput.Builder)ZonalStatisticsConfigInput.builder().applyMutation(zonalStatisticsConfig)).build());
        }
    }
}

