/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakergeospatial.model.CustomIndicesInput;
import software.amazon.awssdk.services.sagemakergeospatial.model.StringListInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BandMathConfigInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BandMathConfigInput> {
    private static final SdkField<CustomIndicesInput> CUSTOM_INDICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomIndices").getter(BandMathConfigInput.getter(BandMathConfigInput::customIndices)).setter(BandMathConfigInput.setter(Builder::customIndices)).constructor(CustomIndicesInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomIndices").build()}).build();
    private static final SdkField<List<String>> PREDEFINED_INDICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PredefinedIndices").getter(BandMathConfigInput.getter(BandMathConfigInput::predefinedIndices)).setter(BandMathConfigInput.setter(Builder::predefinedIndices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedIndices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_INDICES_FIELD, PREDEFINED_INDICES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BandMathConfigInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CustomIndicesInput customIndices;
    private final List<String> predefinedIndices;

    private BandMathConfigInput(BuilderImpl builder) {
        this.customIndices = builder.customIndices;
        this.predefinedIndices = builder.predefinedIndices;
    }

    public final CustomIndicesInput customIndices() {
        return this.customIndices;
    }

    public final boolean hasPredefinedIndices() {
        return this.predefinedIndices != null && !(this.predefinedIndices instanceof SdkAutoConstructList);
    }

    public final List<String> predefinedIndices() {
        return this.predefinedIndices;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customIndices());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPredefinedIndices() ? this.predefinedIndices() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BandMathConfigInput)) {
            return false;
        }
        BandMathConfigInput other = (BandMathConfigInput)obj;
        return Objects.equals(this.customIndices(), other.customIndices()) && this.hasPredefinedIndices() == other.hasPredefinedIndices() && Objects.equals(this.predefinedIndices(), other.predefinedIndices());
    }

    public final String toString() {
        return ToString.builder((String)"BandMathConfigInput").add("CustomIndices", (Object)this.customIndices()).add("PredefinedIndices", this.hasPredefinedIndices() ? this.predefinedIndices() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomIndices": {
                return Optional.ofNullable(clazz.cast(this.customIndices()));
            }
            case "PredefinedIndices": {
                return Optional.ofNullable(clazz.cast(this.predefinedIndices()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CustomIndices", CUSTOM_INDICES_FIELD);
        map.put("PredefinedIndices", PREDEFINED_INDICES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BandMathConfigInput, T> g) {
        return obj -> g.apply((BandMathConfigInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CustomIndicesInput customIndices;
        private List<String> predefinedIndices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BandMathConfigInput model) {
            this.customIndices(model.customIndices);
            this.predefinedIndices(model.predefinedIndices);
        }

        public final CustomIndicesInput.Builder getCustomIndices() {
            return this.customIndices != null ? this.customIndices.toBuilder() : null;
        }

        public final void setCustomIndices(CustomIndicesInput.BuilderImpl customIndices) {
            this.customIndices = customIndices != null ? customIndices.build() : null;
        }

        @Override
        public final Builder customIndices(CustomIndicesInput customIndices) {
            this.customIndices = customIndices;
            return this;
        }

        public final Collection<String> getPredefinedIndices() {
            if (this.predefinedIndices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.predefinedIndices;
        }

        public final void setPredefinedIndices(Collection<String> predefinedIndices) {
            this.predefinedIndices = StringListInputCopier.copy(predefinedIndices);
        }

        @Override
        public final Builder predefinedIndices(Collection<String> predefinedIndices) {
            this.predefinedIndices = StringListInputCopier.copy(predefinedIndices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predefinedIndices(String ... predefinedIndices) {
            this.predefinedIndices(Arrays.asList(predefinedIndices));
            return this;
        }

        public BandMathConfigInput build() {
            return new BandMathConfigInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BandMathConfigInput> {
        public Builder customIndices(CustomIndicesInput var1);

        default public Builder customIndices(Consumer<CustomIndicesInput.Builder> customIndices) {
            return this.customIndices((CustomIndicesInput)((CustomIndicesInput.Builder)CustomIndicesInput.builder().applyMutation(customIndices)).build());
        }

        public Builder predefinedIndices(Collection<String> var1);

        public Builder predefinedIndices(String ... var1);
    }
}

