/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakerruntime.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemakerruntime.model.SageMakerRuntimeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeEndpointResponse
extends SageMakerRuntimeResponse
implements ToCopyableBuilder<Builder, InvokeEndpointResponse> {
    private static final SdkField<SdkBytes> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Body").getter(InvokeEndpointResponse.getter(InvokeEndpointResponse::body)).setter(InvokeEndpointResponse.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(InvokeEndpointResponse.getter(InvokeEndpointResponse::contentType)).setter(InvokeEndpointResponse.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<String> INVOKED_PRODUCTION_VARIANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvokedProductionVariant").getter(InvokeEndpointResponse.getter(InvokeEndpointResponse::invokedProductionVariant)).setter(InvokeEndpointResponse.setter(Builder::invokedProductionVariant)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-Amzn-Invoked-Production-Variant").build()}).build();
    private static final SdkField<String> CUSTOM_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomAttributes").getter(InvokeEndpointResponse.getter(InvokeEndpointResponse::customAttributes)).setter(InvokeEndpointResponse.setter(Builder::customAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Custom-Attributes").build()}).build();
    private static final SdkField<String> NEW_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewSessionId").getter(InvokeEndpointResponse.getter(InvokeEndpointResponse::newSessionId)).setter(InvokeEndpointResponse.setter(Builder::newSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-New-Session-Id").build()}).build();
    private static final SdkField<String> CLOSED_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClosedSessionId").getter(InvokeEndpointResponse.getter(InvokeEndpointResponse::closedSessionId)).setter(InvokeEndpointResponse.setter(Builder::closedSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Closed-Session-Id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD, CONTENT_TYPE_FIELD, INVOKED_PRODUCTION_VARIANT_FIELD, CUSTOM_ATTRIBUTES_FIELD, NEW_SESSION_ID_FIELD, CLOSED_SESSION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvokeEndpointResponse.memberNameToFieldInitializer();
    private final SdkBytes body;
    private final String contentType;
    private final String invokedProductionVariant;
    private final String customAttributes;
    private final String newSessionId;
    private final String closedSessionId;

    private InvokeEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.body = builder.body;
        this.contentType = builder.contentType;
        this.invokedProductionVariant = builder.invokedProductionVariant;
        this.customAttributes = builder.customAttributes;
        this.newSessionId = builder.newSessionId;
        this.closedSessionId = builder.closedSessionId;
    }

    public final SdkBytes body() {
        return this.body;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String invokedProductionVariant() {
        return this.invokedProductionVariant;
    }

    public final String customAttributes() {
        return this.customAttributes;
    }

    public final String newSessionId() {
        return this.newSessionId;
    }

    public final String closedSessionId() {
        return this.closedSessionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.invokedProductionVariant());
        hashCode = 31 * hashCode + Objects.hashCode(this.customAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.newSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.closedSessionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeEndpointResponse)) {
            return false;
        }
        InvokeEndpointResponse other = (InvokeEndpointResponse)((Object)obj);
        return Objects.equals(this.body(), other.body()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.invokedProductionVariant(), other.invokedProductionVariant()) && Objects.equals(this.customAttributes(), other.customAttributes()) && Objects.equals(this.newSessionId(), other.newSessionId()) && Objects.equals(this.closedSessionId(), other.closedSessionId());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeEndpointResponse").add("Body", (Object)(this.body() == null ? null : "*** Sensitive Data Redacted ***")).add("ContentType", (Object)this.contentType()).add("InvokedProductionVariant", (Object)this.invokedProductionVariant()).add("CustomAttributes", (Object)(this.customAttributes() == null ? null : "*** Sensitive Data Redacted ***")).add("NewSessionId", (Object)this.newSessionId()).add("ClosedSessionId", (Object)this.closedSessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "InvokedProductionVariant": {
                return Optional.ofNullable(clazz.cast(this.invokedProductionVariant()));
            }
            case "CustomAttributes": {
                return Optional.ofNullable(clazz.cast(this.customAttributes()));
            }
            case "NewSessionId": {
                return Optional.ofNullable(clazz.cast(this.newSessionId()));
            }
            case "ClosedSessionId": {
                return Optional.ofNullable(clazz.cast(this.closedSessionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Body", BODY_FIELD);
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        map.put("x-Amzn-Invoked-Production-Variant", INVOKED_PRODUCTION_VARIANT_FIELD);
        map.put("X-Amzn-SageMaker-Custom-Attributes", CUSTOM_ATTRIBUTES_FIELD);
        map.put("X-Amzn-SageMaker-New-Session-Id", NEW_SESSION_ID_FIELD);
        map.put("X-Amzn-SageMaker-Closed-Session-Id", CLOSED_SESSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeEndpointResponse, T> g) {
        return obj -> g.apply((InvokeEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRuntimeResponse.BuilderImpl
    implements Builder {
        private SdkBytes body;
        private String contentType;
        private String invokedProductionVariant;
        private String customAttributes;
        private String newSessionId;
        private String closedSessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeEndpointResponse model) {
            super(model);
            this.body(model.body);
            this.contentType(model.contentType);
            this.invokedProductionVariant(model.invokedProductionVariant);
            this.customAttributes(model.customAttributes);
            this.newSessionId(model.newSessionId);
            this.closedSessionId(model.closedSessionId);
        }

        public final ByteBuffer getBody() {
            return this.body == null ? null : this.body.asByteBuffer();
        }

        public final void setBody(ByteBuffer body) {
            this.body(body == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)body));
        }

        @Override
        public final Builder body(SdkBytes body) {
            this.body = body;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getInvokedProductionVariant() {
            return this.invokedProductionVariant;
        }

        public final void setInvokedProductionVariant(String invokedProductionVariant) {
            this.invokedProductionVariant = invokedProductionVariant;
        }

        @Override
        public final Builder invokedProductionVariant(String invokedProductionVariant) {
            this.invokedProductionVariant = invokedProductionVariant;
            return this;
        }

        public final String getCustomAttributes() {
            return this.customAttributes;
        }

        public final void setCustomAttributes(String customAttributes) {
            this.customAttributes = customAttributes;
        }

        @Override
        public final Builder customAttributes(String customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        public final String getNewSessionId() {
            return this.newSessionId;
        }

        public final void setNewSessionId(String newSessionId) {
            this.newSessionId = newSessionId;
        }

        @Override
        public final Builder newSessionId(String newSessionId) {
            this.newSessionId = newSessionId;
            return this;
        }

        public final String getClosedSessionId() {
            return this.closedSessionId;
        }

        public final void setClosedSessionId(String closedSessionId) {
            this.closedSessionId = closedSessionId;
        }

        @Override
        public final Builder closedSessionId(String closedSessionId) {
            this.closedSessionId = closedSessionId;
            return this;
        }

        @Override
        public InvokeEndpointResponse build() {
            return new InvokeEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeEndpointResponse> {
        public Builder body(SdkBytes var1);

        public Builder contentType(String var1);

        public Builder invokedProductionVariant(String var1);

        public Builder customAttributes(String var1);

        public Builder newSessionId(String var1);

        public Builder closedSessionId(String var1);
    }
}

