/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.savingsplans.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.savingsplans.model.CurrencyCode;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateProperty;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanRatePropertyListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateServiceCode;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SavingsPlanRate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SavingsPlanRate> {
    private static final SdkField<String> RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rate").getter(SavingsPlanRate.getter(SavingsPlanRate::rate)).setter(SavingsPlanRate.setter(Builder::rate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rate").build()}).build();
    private static final SdkField<String> CURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currency").getter(SavingsPlanRate.getter(SavingsPlanRate::currencyAsString)).setter(SavingsPlanRate.setter(Builder::currency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unit").getter(SavingsPlanRate.getter(SavingsPlanRate::unitAsString)).setter(SavingsPlanRate.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("productType").getter(SavingsPlanRate.getter(SavingsPlanRate::productTypeAsString)).setter(SavingsPlanRate.setter(Builder::productType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productType").build()}).build();
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceCode").getter(SavingsPlanRate.getter(SavingsPlanRate::serviceCodeAsString)).setter(SavingsPlanRate.setter(Builder::serviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()}).build();
    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageType").getter(SavingsPlanRate.getter(SavingsPlanRate::usageType)).setter(SavingsPlanRate.setter(Builder::usageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operation").getter(SavingsPlanRate.getter(SavingsPlanRate::operation)).setter(SavingsPlanRate.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()}).build();
    private static final SdkField<List<SavingsPlanRateProperty>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("properties").getter(SavingsPlanRate.getter(SavingsPlanRate::properties)).setter(SavingsPlanRate.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SavingsPlanRateProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RATE_FIELD, CURRENCY_FIELD, UNIT_FIELD, PRODUCT_TYPE_FIELD, SERVICE_CODE_FIELD, USAGE_TYPE_FIELD, OPERATION_FIELD, PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String rate;
    private final String currency;
    private final String unit;
    private final String productType;
    private final String serviceCode;
    private final String usageType;
    private final String operation;
    private final List<SavingsPlanRateProperty> properties;

    private SavingsPlanRate(BuilderImpl builder) {
        this.rate = builder.rate;
        this.currency = builder.currency;
        this.unit = builder.unit;
        this.productType = builder.productType;
        this.serviceCode = builder.serviceCode;
        this.usageType = builder.usageType;
        this.operation = builder.operation;
        this.properties = builder.properties;
    }

    public final String rate() {
        return this.rate;
    }

    public final CurrencyCode currency() {
        return CurrencyCode.fromValue(this.currency);
    }

    public final String currencyAsString() {
        return this.currency;
    }

    public final SavingsPlanRateUnit unit() {
        return SavingsPlanRateUnit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public final SavingsPlanProductType productType() {
        return SavingsPlanProductType.fromValue(this.productType);
    }

    public final String productTypeAsString() {
        return this.productType;
    }

    public final SavingsPlanRateServiceCode serviceCode() {
        return SavingsPlanRateServiceCode.fromValue(this.serviceCode);
    }

    public final String serviceCodeAsString() {
        return this.serviceCode;
    }

    public final String usageType() {
        return this.usageType;
    }

    public final String operation() {
        return this.operation;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructList);
    }

    public final List<SavingsPlanRateProperty> properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rate());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlanRate)) {
            return false;
        }
        SavingsPlanRate other = (SavingsPlanRate)obj;
        return Objects.equals(this.rate(), other.rate()) && Objects.equals(this.currencyAsString(), other.currencyAsString()) && Objects.equals(this.unitAsString(), other.unitAsString()) && Objects.equals(this.productTypeAsString(), other.productTypeAsString()) && Objects.equals(this.serviceCodeAsString(), other.serviceCodeAsString()) && Objects.equals(this.usageType(), other.usageType()) && Objects.equals(this.operation(), other.operation()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties());
    }

    public final String toString() {
        return ToString.builder((String)"SavingsPlanRate").add("Rate", (Object)this.rate()).add("Currency", (Object)this.currencyAsString()).add("Unit", (Object)this.unitAsString()).add("ProductType", (Object)this.productTypeAsString()).add("ServiceCode", (Object)this.serviceCodeAsString()).add("UsageType", (Object)this.usageType()).add("Operation", (Object)this.operation()).add("Properties", this.hasProperties() ? this.properties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "rate": {
                return Optional.ofNullable(clazz.cast(this.rate()));
            }
            case "currency": {
                return Optional.ofNullable(clazz.cast(this.currencyAsString()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
            case "productType": {
                return Optional.ofNullable(clazz.cast(this.productTypeAsString()));
            }
            case "serviceCode": {
                return Optional.ofNullable(clazz.cast(this.serviceCodeAsString()));
            }
            case "usageType": {
                return Optional.ofNullable(clazz.cast(this.usageType()));
            }
            case "operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlanRate, T> g) {
        return obj -> g.apply((SavingsPlanRate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String rate;
        private String currency;
        private String unit;
        private String productType;
        private String serviceCode;
        private String usageType;
        private String operation;
        private List<SavingsPlanRateProperty> properties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlanRate model) {
            this.rate(model.rate);
            this.currency(model.currency);
            this.unit(model.unit);
            this.productType(model.productType);
            this.serviceCode(model.serviceCode);
            this.usageType(model.usageType);
            this.operation(model.operation);
            this.properties(model.properties);
        }

        public final String getRate() {
            return this.rate;
        }

        public final void setRate(String rate) {
            this.rate = rate;
        }

        @Override
        @Transient
        public final Builder rate(String rate) {
            this.rate = rate;
            return this;
        }

        public final String getCurrency() {
            return this.currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        @Transient
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        @Transient
        public final Builder currency(CurrencyCode currency) {
            this.currency(currency == null ? null : currency.toString());
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        @Transient
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        @Transient
        public final Builder unit(SavingsPlanRateUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final String getProductType() {
            return this.productType;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        @Override
        @Transient
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        @Transient
        public final Builder productType(SavingsPlanProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        @Transient
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        @Override
        @Transient
        public final Builder serviceCode(SavingsPlanRateServiceCode serviceCode) {
            this.serviceCode(serviceCode == null ? null : serviceCode.toString());
            return this;
        }

        public final String getUsageType() {
            return this.usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        @Transient
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        @Transient
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final List<SavingsPlanRateProperty.Builder> getProperties() {
            List<SavingsPlanRateProperty.Builder> result = SavingsPlanRatePropertyListCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProperties(Collection<SavingsPlanRateProperty.BuilderImpl> properties) {
            this.properties = SavingsPlanRatePropertyListCopier.copyFromBuilder(properties);
        }

        @Override
        @Transient
        public final Builder properties(Collection<SavingsPlanRateProperty> properties) {
            this.properties = SavingsPlanRatePropertyListCopier.copy(properties);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder properties(SavingsPlanRateProperty ... properties) {
            this.properties(Arrays.asList(properties));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder properties(Consumer<SavingsPlanRateProperty.Builder> ... properties) {
            this.properties(Stream.of(properties).map(c -> (SavingsPlanRateProperty)((SavingsPlanRateProperty.Builder)SavingsPlanRateProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SavingsPlanRate build() {
            return new SavingsPlanRate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SavingsPlanRate> {
        public Builder rate(String var1);

        public Builder currency(String var1);

        public Builder currency(CurrencyCode var1);

        public Builder unit(String var1);

        public Builder unit(SavingsPlanRateUnit var1);

        public Builder productType(String var1);

        public Builder productType(SavingsPlanProductType var1);

        public Builder serviceCode(String var1);

        public Builder serviceCode(SavingsPlanRateServiceCode var1);

        public Builder usageType(String var1);

        public Builder operation(String var1);

        public Builder properties(Collection<SavingsPlanRateProperty> var1);

        public Builder properties(SavingsPlanRateProperty ... var1);

        public Builder properties(Consumer<SavingsPlanRateProperty.Builder> ... var1);
    }
}

