/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.savingsplans.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CurrencyCode {
    CNY("CNY"),
    USD("USD"),
    EUR("EUR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CurrencyCode> VALUE_MAP;
    private final String value;

    private CurrencyCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CurrencyCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CurrencyCode> knownValues() {
        EnumSet<CurrencyCode> knownValues = EnumSet.allOf(CurrencyCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CurrencyCode.class, CurrencyCode::toString);
    }
}

