/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.scheduler.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.scheduler.model.ScheduleGroupListCopier;
import software.amazon.awssdk.services.scheduler.model.ScheduleGroupSummary;
import software.amazon.awssdk.services.scheduler.model.SchedulerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListScheduleGroupsResponse
extends SchedulerResponse
implements ToCopyableBuilder<Builder, ListScheduleGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListScheduleGroupsResponse.getter(ListScheduleGroupsResponse::nextToken)).setter(ListScheduleGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ScheduleGroupSummary>> SCHEDULE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScheduleGroups").getter(ListScheduleGroupsResponse.getter(ListScheduleGroupsResponse::scheduleGroups)).setter(ListScheduleGroupsResponse.setter(Builder::scheduleGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduleGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SCHEDULE_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListScheduleGroupsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ScheduleGroupSummary> scheduleGroups;

    private ListScheduleGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.scheduleGroups = builder.scheduleGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasScheduleGroups() {
        return this.scheduleGroups != null && !(this.scheduleGroups instanceof SdkAutoConstructList);
    }

    public final List<ScheduleGroupSummary> scheduleGroups() {
        return this.scheduleGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScheduleGroups() ? this.scheduleGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScheduleGroupsResponse)) {
            return false;
        }
        ListScheduleGroupsResponse other = (ListScheduleGroupsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasScheduleGroups() == other.hasScheduleGroups() && Objects.equals(this.scheduleGroups(), other.scheduleGroups());
    }

    public final String toString() {
        return ToString.builder((String)"ListScheduleGroupsResponse").add("NextToken", (Object)this.nextToken()).add("ScheduleGroups", this.hasScheduleGroups() ? this.scheduleGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ScheduleGroups": {
                return Optional.ofNullable(clazz.cast(this.scheduleGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ScheduleGroups", SCHEDULE_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListScheduleGroupsResponse, T> g) {
        return obj -> g.apply((ListScheduleGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SchedulerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ScheduleGroupSummary> scheduleGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListScheduleGroupsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.scheduleGroups(model.scheduleGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ScheduleGroupSummary.Builder> getScheduleGroups() {
            List<ScheduleGroupSummary.Builder> result = ScheduleGroupListCopier.copyToBuilder(this.scheduleGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScheduleGroups(Collection<ScheduleGroupSummary.BuilderImpl> scheduleGroups) {
            this.scheduleGroups = ScheduleGroupListCopier.copyFromBuilder(scheduleGroups);
        }

        @Override
        public final Builder scheduleGroups(Collection<ScheduleGroupSummary> scheduleGroups) {
            this.scheduleGroups = ScheduleGroupListCopier.copy(scheduleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduleGroups(ScheduleGroupSummary ... scheduleGroups) {
            this.scheduleGroups(Arrays.asList(scheduleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduleGroups(Consumer<ScheduleGroupSummary.Builder> ... scheduleGroups) {
            this.scheduleGroups(Stream.of(scheduleGroups).map(c -> (ScheduleGroupSummary)((ScheduleGroupSummary.Builder)ScheduleGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListScheduleGroupsResponse build() {
            return new ListScheduleGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SchedulerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListScheduleGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder scheduleGroups(Collection<ScheduleGroupSummary> var1);

        public Builder scheduleGroups(ScheduleGroupSummary ... var1);

        public Builder scheduleGroups(Consumer<ScheduleGroupSummary.Builder> ... var1);
    }
}

