/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.scheduler.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PlacementStrategyType {
    RANDOM("random"),
    SPREAD("spread"),
    BINPACK("binpack"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PlacementStrategyType> VALUE_MAP;
    private final String value;

    private PlacementStrategyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PlacementStrategyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PlacementStrategyType> knownValues() {
        EnumSet<PlacementStrategyType> knownValues = EnumSet.allOf(PlacementStrategyType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PlacementStrategyType.class, PlacementStrategyType::toString);
    }
}

