/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.schemas.model.DiscovererSummary;
import software.amazon.awssdk.services.schemas.model.SchemasResponse;
import software.amazon.awssdk.services.schemas.model.___listOfDiscovererSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDiscoverersResponse
extends SchemasResponse
implements ToCopyableBuilder<Builder, ListDiscoverersResponse> {
    private static final SdkField<List<DiscovererSummary>> DISCOVERERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Discoverers").getter(ListDiscoverersResponse.getter(ListDiscoverersResponse::discoverers)).setter(ListDiscoverersResponse.setter(Builder::discoverers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Discoverers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DiscovererSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDiscoverersResponse.getter(ListDiscoverersResponse::nextToken)).setter(ListDiscoverersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DiscovererSummary> discoverers;
    private final String nextToken;

    private ListDiscoverersResponse(BuilderImpl builder) {
        super(builder);
        this.discoverers = builder.discoverers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDiscoverers() {
        return this.discoverers != null && !(this.discoverers instanceof SdkAutoConstructList);
    }

    public final List<DiscovererSummary> discoverers() {
        return this.discoverers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDiscoverers() ? this.discoverers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDiscoverersResponse)) {
            return false;
        }
        ListDiscoverersResponse other = (ListDiscoverersResponse)((Object)obj);
        return this.hasDiscoverers() == other.hasDiscoverers() && Objects.equals(this.discoverers(), other.discoverers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDiscoverersResponse").add("Discoverers", this.hasDiscoverers() ? this.discoverers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Discoverers": {
                return Optional.ofNullable(clazz.cast(this.discoverers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDiscoverersResponse, T> g) {
        return obj -> g.apply((ListDiscoverersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SchemasResponse.BuilderImpl
    implements Builder {
        private List<DiscovererSummary> discoverers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDiscoverersResponse model) {
            super(model);
            this.discoverers(model.discoverers);
            this.nextToken(model.nextToken);
        }

        public final List<DiscovererSummary.Builder> getDiscoverers() {
            List<DiscovererSummary.Builder> result = ___listOfDiscovererSummaryCopier.copyToBuilder(this.discoverers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDiscoverers(Collection<DiscovererSummary.BuilderImpl> discoverers) {
            this.discoverers = ___listOfDiscovererSummaryCopier.copyFromBuilder(discoverers);
        }

        @Override
        @Transient
        public final Builder discoverers(Collection<DiscovererSummary> discoverers) {
            this.discoverers = ___listOfDiscovererSummaryCopier.copy(discoverers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder discoverers(DiscovererSummary ... discoverers) {
            this.discoverers(Arrays.asList(discoverers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder discoverers(Consumer<DiscovererSummary.Builder> ... discoverers) {
            this.discoverers(Stream.of(discoverers).map(c -> (DiscovererSummary)((DiscovererSummary.Builder)DiscovererSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDiscoverersResponse build() {
            return new ListDiscoverersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SchemasResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDiscoverersResponse> {
        public Builder discoverers(Collection<DiscovererSummary> var1);

        public Builder discoverers(DiscovererSummary ... var1);

        public Builder discoverers(Consumer<DiscovererSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

