/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.schemas.SchemasClient;
import software.amazon.awssdk.services.schemas.internal.UserAgentUtils;
import software.amazon.awssdk.services.schemas.model.ListSchemaVersionsRequest;
import software.amazon.awssdk.services.schemas.model.ListSchemaVersionsResponse;
import software.amazon.awssdk.services.schemas.model.SchemaVersionSummary;

public class ListSchemaVersionsIterable
implements SdkIterable<ListSchemaVersionsResponse> {
    private final SchemasClient client;
    private final ListSchemaVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSchemaVersionsIterable(SchemasClient client, ListSchemaVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSchemaVersionsResponseFetcher();
    }

    public Iterator<ListSchemaVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SchemaVersionSummary> schemaVersions() {
        Function<ListSchemaVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.schemaVersions() != null) {
                return response.schemaVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSchemaVersionsResponseFetcher
    implements SyncPageFetcher<ListSchemaVersionsResponse> {
        private ListSchemaVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSchemaVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSchemaVersionsResponse nextPage(ListSchemaVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListSchemaVersionsIterable.this.client.listSchemaVersions(ListSchemaVersionsIterable.this.firstRequest);
            }
            return ListSchemaVersionsIterable.this.client.listSchemaVersions((ListSchemaVersionsRequest)((Object)ListSchemaVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

