/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SecurityHubFeature {
    SECURITY_HUB("SecurityHub"),
    SECURITY_HUB_V2("SecurityHubV2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SecurityHubFeature> VALUE_MAP;
    private final String value;

    private SecurityHubFeature(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SecurityHubFeature fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SecurityHubFeature> knownValues() {
        EnumSet<SecurityHubFeature> knownValues = EnumSet.allOf(SecurityHubFeature.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SecurityHubFeature.class, SecurityHubFeature::toString);
    }
}

