/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.OcsfFindingsListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFindingsV2Response
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, GetFindingsV2Response> {
    private static final SdkField<List<Document>> FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Findings").getter(GetFindingsV2Response.getter(GetFindingsV2Response::findings)).setter(GetFindingsV2Response.setter(Builder::findings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Findings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetFindingsV2Response.getter(GetFindingsV2Response::nextToken)).setter(GetFindingsV2Response.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDINGS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetFindingsV2Response.memberNameToFieldInitializer();
    private final List<Document> findings;
    private final String nextToken;

    private GetFindingsV2Response(BuilderImpl builder) {
        super(builder);
        this.findings = builder.findings;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFindings() {
        return this.findings != null && !(this.findings instanceof SdkAutoConstructList);
    }

    public final List<Document> findings() {
        return this.findings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindings() ? this.findings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingsV2Response)) {
            return false;
        }
        GetFindingsV2Response other = (GetFindingsV2Response)((Object)obj);
        return this.hasFindings() == other.hasFindings() && Objects.equals(this.findings(), other.findings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetFindingsV2Response").add("Findings", this.hasFindings() ? this.findings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Findings": {
                return Optional.ofNullable(clazz.cast(this.findings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Findings", FINDINGS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFindingsV2Response, T> g) {
        return obj -> g.apply((GetFindingsV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<Document> findings = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingsV2Response model) {
            super(model);
            this.findings(model.findings);
            this.nextToken(model.nextToken);
        }

        public final Collection<Document> getFindings() {
            if (this.findings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.findings;
        }

        public final void setFindings(Collection<Document> findings) {
            this.findings = OcsfFindingsListCopier.copy(findings);
        }

        @Override
        public final Builder findings(Collection<Document> findings) {
            this.findings = OcsfFindingsListCopier.copy(findings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Document ... findings) {
            this.findings(Arrays.asList(findings));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetFindingsV2Response build() {
            return new GetFindingsV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFindingsV2Response> {
        public Builder findings(Collection<Document> var1);

        public Builder findings(Document ... var1);

        public Builder nextToken(String var1);
    }
}

