/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IntegrationV2Type {
    SEND_FINDINGS_TO_SECURITY_HUB("SEND_FINDINGS_TO_SECURITY_HUB"),
    RECEIVE_FINDINGS_FROM_SECURITY_HUB("RECEIVE_FINDINGS_FROM_SECURITY_HUB"),
    UPDATE_FINDINGS_IN_SECURITY_HUB("UPDATE_FINDINGS_IN_SECURITY_HUB"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IntegrationV2Type> VALUE_MAP;
    private final String value;

    private IntegrationV2Type(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IntegrationV2Type fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IntegrationV2Type> knownValues() {
        EnumSet<IntegrationV2Type> knownValues = EnumSet.allOf(IntegrationV2Type.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IntegrationV2Type.class, IntegrationV2Type::toString);
    }
}

