/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityir.model.SecurityIrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCaseCommentResponse
extends SecurityIrResponse
implements ToCopyableBuilder<Builder, UpdateCaseCommentResponse> {
    private static final SdkField<String> COMMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commentId").getter(UpdateCaseCommentResponse.getter(UpdateCaseCommentResponse::commentId)).setter(UpdateCaseCommentResponse.setter(Builder::commentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commentId").build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("body").getter(UpdateCaseCommentResponse.getter(UpdateCaseCommentResponse::body)).setter(UpdateCaseCommentResponse.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_ID_FIELD, BODY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateCaseCommentResponse.memberNameToFieldInitializer();
    private final String commentId;
    private final String body;

    private UpdateCaseCommentResponse(BuilderImpl builder) {
        super(builder);
        this.commentId = builder.commentId;
        this.body = builder.body;
    }

    public final String commentId() {
        return this.commentId;
    }

    public final String body() {
        return this.body;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.commentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCaseCommentResponse)) {
            return false;
        }
        UpdateCaseCommentResponse other = (UpdateCaseCommentResponse)((Object)obj);
        return Objects.equals(this.commentId(), other.commentId()) && Objects.equals(this.body(), other.body());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCaseCommentResponse").add("CommentId", (Object)this.commentId()).add("Body", (Object)(this.body() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commentId": {
                return Optional.ofNullable(clazz.cast(this.commentId()));
            }
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("commentId", COMMENT_ID_FIELD);
        map.put("body", BODY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCaseCommentResponse, T> g) {
        return obj -> g.apply((UpdateCaseCommentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityIrResponse.BuilderImpl
    implements Builder {
        private String commentId;
        private String body;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCaseCommentResponse model) {
            super(model);
            this.commentId(model.commentId);
            this.body(model.body);
        }

        public final String getCommentId() {
            return this.commentId;
        }

        public final void setCommentId(String commentId) {
            this.commentId = commentId;
        }

        @Override
        public final Builder commentId(String commentId) {
            this.commentId = commentId;
            return this;
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        @Override
        public UpdateCaseCommentResponse build() {
            return new UpdateCaseCommentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityIrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCaseCommentResponse> {
        public Builder commentId(String var1);

        public Builder body(String var1);
    }
}

