/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityir.SecurityIrAsyncClient;
import software.amazon.awssdk.services.securityir.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityir.model.CaseEditItem;
import software.amazon.awssdk.services.securityir.model.ListCaseEditsRequest;
import software.amazon.awssdk.services.securityir.model.ListCaseEditsResponse;

public class ListCaseEditsPublisher
implements SdkPublisher<ListCaseEditsResponse> {
    private final SecurityIrAsyncClient client;
    private final ListCaseEditsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCaseEditsPublisher(SecurityIrAsyncClient client, ListCaseEditsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCaseEditsPublisher(SecurityIrAsyncClient client, ListCaseEditsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCaseEditsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCaseEditsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CaseEditItem> items() {
        Function<ListCaseEditsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCaseEditsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCaseEditsResponseFetcher
    implements AsyncPageFetcher<ListCaseEditsResponse> {
        private ListCaseEditsResponseFetcher() {
        }

        public boolean hasNextPage(ListCaseEditsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCaseEditsResponse> nextPage(ListCaseEditsResponse previousPage) {
            if (previousPage == null) {
                return ListCaseEditsPublisher.this.client.listCaseEdits(ListCaseEditsPublisher.this.firstRequest);
            }
            return ListCaseEditsPublisher.this.client.listCaseEdits((ListCaseEditsRequest)((Object)ListCaseEditsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

