/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityir.model.OptInFeatureName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OptInFeature
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OptInFeature> {
    private static final SdkField<String> FEATURE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("featureName").getter(OptInFeature.getter(OptInFeature::featureNameAsString)).setter(OptInFeature.setter(Builder::featureName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureName").build()}).build();
    private static final SdkField<Boolean> IS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isEnabled").getter(OptInFeature.getter(OptInFeature::isEnabled)).setter(OptInFeature.setter(Builder::isEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_NAME_FIELD, IS_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OptInFeature.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String featureName;
    private final Boolean isEnabled;

    private OptInFeature(BuilderImpl builder) {
        this.featureName = builder.featureName;
        this.isEnabled = builder.isEnabled;
    }

    public final OptInFeatureName featureName() {
        return OptInFeatureName.fromValue(this.featureName);
    }

    public final String featureNameAsString() {
        return this.featureName;
    }

    public final Boolean isEnabled() {
        return this.isEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.featureNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptInFeature)) {
            return false;
        }
        OptInFeature other = (OptInFeature)obj;
        return Objects.equals(this.featureNameAsString(), other.featureNameAsString()) && Objects.equals(this.isEnabled(), other.isEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"OptInFeature").add("FeatureName", (Object)this.featureNameAsString()).add("IsEnabled", (Object)this.isEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "featureName": {
                return Optional.ofNullable(clazz.cast(this.featureNameAsString()));
            }
            case "isEnabled": {
                return Optional.ofNullable(clazz.cast(this.isEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("featureName", FEATURE_NAME_FIELD);
        map.put("isEnabled", IS_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OptInFeature, T> g) {
        return obj -> g.apply((OptInFeature)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String featureName;
        private Boolean isEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(OptInFeature model) {
            this.featureName(model.featureName);
            this.isEnabled(model.isEnabled);
        }

        public final String getFeatureName() {
            return this.featureName;
        }

        public final void setFeatureName(String featureName) {
            this.featureName = featureName;
        }

        @Override
        public final Builder featureName(String featureName) {
            this.featureName = featureName;
            return this;
        }

        @Override
        public final Builder featureName(OptInFeatureName featureName) {
            this.featureName(featureName == null ? null : featureName.toString());
            return this;
        }

        public final Boolean getIsEnabled() {
            return this.isEnabled;
        }

        public final void setIsEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        @Override
        public final Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public OptInFeature build() {
            return new OptInFeature(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OptInFeature> {
        public Builder featureName(String var1);

        public Builder featureName(OptInFeatureName var1);

        public Builder isEnabled(Boolean var1);
    }
}

