/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OptInFeatureName {
    TRIAGE("Triage"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OptInFeatureName> VALUE_MAP;
    private final String value;

    private OptInFeatureName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OptInFeatureName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OptInFeatureName> knownValues() {
        EnumSet<OptInFeatureName> knownValues = EnumSet.allOf(OptInFeatureName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OptInFeatureName.class, OptInFeatureName::toString);
    }
}

