/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityir.SecurityIrClient;
import software.amazon.awssdk.services.securityir.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityir.model.InvestigationAction;
import software.amazon.awssdk.services.securityir.model.ListInvestigationsRequest;
import software.amazon.awssdk.services.securityir.model.ListInvestigationsResponse;

public class ListInvestigationsIterable
implements SdkIterable<ListInvestigationsResponse> {
    private final SecurityIrClient client;
    private final ListInvestigationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInvestigationsIterable(SecurityIrClient client, ListInvestigationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInvestigationsResponseFetcher();
    }

    public Iterator<ListInvestigationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InvestigationAction> investigationActions() {
        Function<ListInvestigationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.investigationActions() != null) {
                return response.investigationActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInvestigationsResponseFetcher
    implements SyncPageFetcher<ListInvestigationsResponse> {
        private ListInvestigationsResponseFetcher() {
        }

        public boolean hasNextPage(ListInvestigationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInvestigationsResponse nextPage(ListInvestigationsResponse previousPage) {
            if (previousPage == null) {
                return ListInvestigationsIterable.this.client.listInvestigations(ListInvestigationsIterable.this.firstRequest);
            }
            return ListInvestigationsIterable.this.client.listInvestigations((ListInvestigationsRequest)((Object)ListInvestigationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

