/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityir.SecurityIrAsyncClient;
import software.amazon.awssdk.services.securityir.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityir.model.InvestigationAction;
import software.amazon.awssdk.services.securityir.model.ListInvestigationsRequest;
import software.amazon.awssdk.services.securityir.model.ListInvestigationsResponse;

public class ListInvestigationsPublisher
implements SdkPublisher<ListInvestigationsResponse> {
    private final SecurityIrAsyncClient client;
    private final ListInvestigationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInvestigationsPublisher(SecurityIrAsyncClient client, ListInvestigationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInvestigationsPublisher(SecurityIrAsyncClient client, ListInvestigationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInvestigationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInvestigationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InvestigationAction> investigationActions() {
        Function<ListInvestigationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.investigationActions() != null) {
                return response.investigationActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInvestigationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInvestigationsResponseFetcher
    implements AsyncPageFetcher<ListInvestigationsResponse> {
        private ListInvestigationsResponseFetcher() {
        }

        public boolean hasNextPage(ListInvestigationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInvestigationsResponse> nextPage(ListInvestigationsResponse previousPage) {
            if (previousPage == null) {
                return ListInvestigationsPublisher.this.client.listInvestigations(ListInvestigationsPublisher.this.firstRequest);
            }
            return ListInvestigationsPublisher.this.client.listInvestigations((ListInvestigationsRequest)((Object)ListInvestigationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

