/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityir.SecurityIrAsyncClient;
import software.amazon.awssdk.services.securityir.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityir.model.ListMembershipItem;
import software.amazon.awssdk.services.securityir.model.ListMembershipsRequest;
import software.amazon.awssdk.services.securityir.model.ListMembershipsResponse;

public class ListMembershipsPublisher
implements SdkPublisher<ListMembershipsResponse> {
    private final SecurityIrAsyncClient client;
    private final ListMembershipsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMembershipsPublisher(SecurityIrAsyncClient client, ListMembershipsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMembershipsPublisher(SecurityIrAsyncClient client, ListMembershipsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMembershipsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMembershipsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListMembershipItem> items() {
        Function<ListMembershipsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMembershipsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMembershipsResponseFetcher
    implements AsyncPageFetcher<ListMembershipsResponse> {
        private ListMembershipsResponseFetcher() {
        }

        public boolean hasNextPage(ListMembershipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMembershipsResponse> nextPage(ListMembershipsResponse previousPage) {
            if (previousPage == null) {
                return ListMembershipsPublisher.this.client.listMemberships(ListMembershipsPublisher.this.firstRequest);
            }
            return ListMembershipsPublisher.this.client.listMemberships((ListMembershipsRequest)((Object)ListMembershipsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

