/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.DataLakeException;
import software.amazon.awssdk.services.securitylake.model.DataLakeExceptionListCopier;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataLakeExceptionsResponse
extends SecurityLakeResponse
implements ToCopyableBuilder<Builder, ListDataLakeExceptionsResponse> {
    private static final SdkField<List<DataLakeException>> EXCEPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("exceptions").getter(ListDataLakeExceptionsResponse.getter(ListDataLakeExceptionsResponse::exceptions)).setter(ListDataLakeExceptionsResponse.setter(Builder::exceptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exceptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataLakeException::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDataLakeExceptionsResponse.getter(ListDataLakeExceptionsResponse::nextToken)).setter(ListDataLakeExceptionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCEPTIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDataLakeExceptionsResponse.memberNameToFieldInitializer();
    private final List<DataLakeException> exceptions;
    private final String nextToken;

    private ListDataLakeExceptionsResponse(BuilderImpl builder) {
        super(builder);
        this.exceptions = builder.exceptions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasExceptions() {
        return this.exceptions != null && !(this.exceptions instanceof SdkAutoConstructList);
    }

    public final List<DataLakeException> exceptions() {
        return this.exceptions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExceptions() ? this.exceptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataLakeExceptionsResponse)) {
            return false;
        }
        ListDataLakeExceptionsResponse other = (ListDataLakeExceptionsResponse)((Object)obj);
        return this.hasExceptions() == other.hasExceptions() && Objects.equals(this.exceptions(), other.exceptions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataLakeExceptionsResponse").add("Exceptions", this.hasExceptions() ? this.exceptions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exceptions": {
                return Optional.ofNullable(clazz.cast(this.exceptions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("exceptions", EXCEPTIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataLakeExceptionsResponse, T> g) {
        return obj -> g.apply((ListDataLakeExceptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeResponse.BuilderImpl
    implements Builder {
        private List<DataLakeException> exceptions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataLakeExceptionsResponse model) {
            super(model);
            this.exceptions(model.exceptions);
            this.nextToken(model.nextToken);
        }

        public final List<DataLakeException.Builder> getExceptions() {
            List<DataLakeException.Builder> result = DataLakeExceptionListCopier.copyToBuilder(this.exceptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExceptions(Collection<DataLakeException.BuilderImpl> exceptions) {
            this.exceptions = DataLakeExceptionListCopier.copyFromBuilder(exceptions);
        }

        @Override
        public final Builder exceptions(Collection<DataLakeException> exceptions) {
            this.exceptions = DataLakeExceptionListCopier.copy(exceptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exceptions(DataLakeException ... exceptions) {
            this.exceptions(Arrays.asList(exceptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exceptions(Consumer<DataLakeException.Builder> ... exceptions) {
            this.exceptions(Stream.of(exceptions).map(c -> (DataLakeException)((DataLakeException.Builder)DataLakeException.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataLakeExceptionsResponse build() {
            return new ListDataLakeExceptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityLakeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataLakeExceptionsResponse> {
        public Builder exceptions(Collection<DataLakeException> var1);

        public Builder exceptions(DataLakeException ... var1);

        public Builder exceptions(Consumer<DataLakeException.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

