/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.DataLakeSourceStatus;
import software.amazon.awssdk.services.securitylake.model.DataLakeSourceStatusListCopier;
import software.amazon.awssdk.services.securitylake.model.OcsfEventClassListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataLakeSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataLakeSource> {
    private static final SdkField<String> ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("account").getter(DataLakeSource.getter(DataLakeSource::account)).setter(DataLakeSource.setter(Builder::account)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("account").build()}).build();
    private static final SdkField<List<String>> EVENT_CLASSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventClasses").getter(DataLakeSource.getter(DataLakeSource::eventClasses)).setter(DataLakeSource.setter(Builder::eventClasses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventClasses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceName").getter(DataLakeSource.getter(DataLakeSource::sourceName)).setter(DataLakeSource.setter(Builder::sourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceName").build()}).build();
    private static final SdkField<List<DataLakeSourceStatus>> SOURCE_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceStatuses").getter(DataLakeSource.getter(DataLakeSource::sourceStatuses)).setter(DataLakeSource.setter(Builder::sourceStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataLakeSourceStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_FIELD, EVENT_CLASSES_FIELD, SOURCE_NAME_FIELD, SOURCE_STATUSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataLakeSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String account;
    private final List<String> eventClasses;
    private final String sourceName;
    private final List<DataLakeSourceStatus> sourceStatuses;

    private DataLakeSource(BuilderImpl builder) {
        this.account = builder.account;
        this.eventClasses = builder.eventClasses;
        this.sourceName = builder.sourceName;
        this.sourceStatuses = builder.sourceStatuses;
    }

    public final String account() {
        return this.account;
    }

    public final boolean hasEventClasses() {
        return this.eventClasses != null && !(this.eventClasses instanceof SdkAutoConstructList);
    }

    public final List<String> eventClasses() {
        return this.eventClasses;
    }

    public final String sourceName() {
        return this.sourceName;
    }

    public final boolean hasSourceStatuses() {
        return this.sourceStatuses != null && !(this.sourceStatuses instanceof SdkAutoConstructList);
    }

    public final List<DataLakeSourceStatus> sourceStatuses() {
        return this.sourceStatuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.account());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventClasses() ? this.eventClasses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceStatuses() ? this.sourceStatuses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeSource)) {
            return false;
        }
        DataLakeSource other = (DataLakeSource)obj;
        return Objects.equals(this.account(), other.account()) && this.hasEventClasses() == other.hasEventClasses() && Objects.equals(this.eventClasses(), other.eventClasses()) && Objects.equals(this.sourceName(), other.sourceName()) && this.hasSourceStatuses() == other.hasSourceStatuses() && Objects.equals(this.sourceStatuses(), other.sourceStatuses());
    }

    public final String toString() {
        return ToString.builder((String)"DataLakeSource").add("Account", (Object)this.account()).add("EventClasses", this.hasEventClasses() ? this.eventClasses() : null).add("SourceName", (Object)this.sourceName()).add("SourceStatuses", this.hasSourceStatuses() ? this.sourceStatuses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "account": {
                return Optional.ofNullable(clazz.cast(this.account()));
            }
            case "eventClasses": {
                return Optional.ofNullable(clazz.cast(this.eventClasses()));
            }
            case "sourceName": {
                return Optional.ofNullable(clazz.cast(this.sourceName()));
            }
            case "sourceStatuses": {
                return Optional.ofNullable(clazz.cast(this.sourceStatuses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("account", ACCOUNT_FIELD);
        map.put("eventClasses", EVENT_CLASSES_FIELD);
        map.put("sourceName", SOURCE_NAME_FIELD);
        map.put("sourceStatuses", SOURCE_STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataLakeSource, T> g) {
        return obj -> g.apply((DataLakeSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String account;
        private List<String> eventClasses = DefaultSdkAutoConstructList.getInstance();
        private String sourceName;
        private List<DataLakeSourceStatus> sourceStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeSource model) {
            this.account(model.account);
            this.eventClasses(model.eventClasses);
            this.sourceName(model.sourceName);
            this.sourceStatuses(model.sourceStatuses);
        }

        public final String getAccount() {
            return this.account;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final Collection<String> getEventClasses() {
            if (this.eventClasses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventClasses;
        }

        public final void setEventClasses(Collection<String> eventClasses) {
            this.eventClasses = OcsfEventClassListCopier.copy(eventClasses);
        }

        @Override
        public final Builder eventClasses(Collection<String> eventClasses) {
            this.eventClasses = OcsfEventClassListCopier.copy(eventClasses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventClasses(String ... eventClasses) {
            this.eventClasses(Arrays.asList(eventClasses));
            return this;
        }

        public final String getSourceName() {
            return this.sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public final List<DataLakeSourceStatus.Builder> getSourceStatuses() {
            List<DataLakeSourceStatus.Builder> result = DataLakeSourceStatusListCopier.copyToBuilder(this.sourceStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceStatuses(Collection<DataLakeSourceStatus.BuilderImpl> sourceStatuses) {
            this.sourceStatuses = DataLakeSourceStatusListCopier.copyFromBuilder(sourceStatuses);
        }

        @Override
        public final Builder sourceStatuses(Collection<DataLakeSourceStatus> sourceStatuses) {
            this.sourceStatuses = DataLakeSourceStatusListCopier.copy(sourceStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceStatuses(DataLakeSourceStatus ... sourceStatuses) {
            this.sourceStatuses(Arrays.asList(sourceStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceStatuses(Consumer<DataLakeSourceStatus.Builder> ... sourceStatuses) {
            this.sourceStatuses(Stream.of(sourceStatuses).map(c -> (DataLakeSourceStatus)((DataLakeSourceStatus.Builder)DataLakeSourceStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DataLakeSource build() {
            return new DataLakeSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataLakeSource> {
        public Builder account(String var1);

        public Builder eventClasses(Collection<String> var1);

        public Builder eventClasses(String ... var1);

        public Builder sourceName(String var1);

        public Builder sourceStatuses(Collection<DataLakeSourceStatus> var1);

        public Builder sourceStatuses(DataLakeSourceStatus ... var1);

        public Builder sourceStatuses(Consumer<DataLakeSourceStatus.Builder> ... var1);
    }
}

