/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCloudFormationChangeSetResponse
extends ServerlessApplicationRepositoryResponse
implements ToCopyableBuilder<Builder, CreateCloudFormationChangeSetResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(CreateCloudFormationChangeSetResponse.getter(CreateCloudFormationChangeSetResponse::applicationId)).setter(CreateCloudFormationChangeSetResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> CHANGE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeSetId").getter(CreateCloudFormationChangeSetResponse.getter(CreateCloudFormationChangeSetResponse::changeSetId)).setter(CreateCloudFormationChangeSetResponse.setter(Builder::changeSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeSetId").build()}).build();
    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SemanticVersion").getter(CreateCloudFormationChangeSetResponse.getter(CreateCloudFormationChangeSetResponse::semanticVersion)).setter(CreateCloudFormationChangeSetResponse.setter(Builder::semanticVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()}).build();
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(CreateCloudFormationChangeSetResponse.getter(CreateCloudFormationChangeSetResponse::stackId)).setter(CreateCloudFormationChangeSetResponse.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CHANGE_SET_ID_FIELD, SEMANTIC_VERSION_FIELD, STACK_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCloudFormationChangeSetResponse.memberNameToFieldInitializer();
    private final String applicationId;
    private final String changeSetId;
    private final String semanticVersion;
    private final String stackId;

    private CreateCloudFormationChangeSetResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.changeSetId = builder.changeSetId;
        this.semanticVersion = builder.semanticVersion;
        this.stackId = builder.stackId;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String changeSetId() {
        return this.changeSetId;
    }

    public final String semanticVersion() {
        return this.semanticVersion;
    }

    public final String stackId() {
        return this.stackId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudFormationChangeSetResponse)) {
            return false;
        }
        CreateCloudFormationChangeSetResponse other = (CreateCloudFormationChangeSetResponse)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.changeSetId(), other.changeSetId()) && Objects.equals(this.semanticVersion(), other.semanticVersion()) && Objects.equals(this.stackId(), other.stackId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCloudFormationChangeSetResponse").add("ApplicationId", (Object)this.applicationId()).add("ChangeSetId", (Object)this.changeSetId()).add("SemanticVersion", (Object)this.semanticVersion()).add("StackId", (Object)this.stackId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "ChangeSetId": {
                return Optional.ofNullable(clazz.cast(this.changeSetId()));
            }
            case "SemanticVersion": {
                return Optional.ofNullable(clazz.cast(this.semanticVersion()));
            }
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("changeSetId", CHANGE_SET_ID_FIELD);
        map.put("semanticVersion", SEMANTIC_VERSION_FIELD);
        map.put("stackId", STACK_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCloudFormationChangeSetResponse, T> g) {
        return obj -> g.apply((CreateCloudFormationChangeSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServerlessApplicationRepositoryResponse.BuilderImpl
    implements Builder {
        private String applicationId;
        private String changeSetId;
        private String semanticVersion;
        private String stackId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudFormationChangeSetResponse model) {
            super(model);
            this.applicationId(model.applicationId);
            this.changeSetId(model.changeSetId);
            this.semanticVersion(model.semanticVersion);
            this.stackId(model.stackId);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getChangeSetId() {
            return this.changeSetId;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final String getSemanticVersion() {
            return this.semanticVersion;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final String getStackId() {
            return this.stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        @Override
        public CreateCloudFormationChangeSetResponse build() {
            return new CreateCloudFormationChangeSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ServerlessApplicationRepositoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCloudFormationChangeSetResponse> {
        public Builder applicationId(String var1);

        public Builder changeSetId(String var1);

        public Builder semanticVersion(String var1);

        public Builder stackId(String var1);
    }
}

