/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.LastSyncStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LastSync
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LastSync> {
    private static final SdkField<Instant> LAST_SYNC_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastSyncTime").getter(LastSync.getter(LastSync::lastSyncTime)).setter(LastSync.setter(Builder::lastSyncTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSyncTime").build()}).build();
    private static final SdkField<String> LAST_SYNC_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastSyncStatus").getter(LastSync.getter(LastSync::lastSyncStatusAsString)).setter(LastSync.setter(Builder::lastSyncStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSyncStatus").build()}).build();
    private static final SdkField<String> LAST_SYNC_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastSyncStatusMessage").getter(LastSync.getter(LastSync::lastSyncStatusMessage)).setter(LastSync.setter(Builder::lastSyncStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSyncStatusMessage").build()}).build();
    private static final SdkField<Instant> LAST_SUCCESSFUL_SYNC_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastSuccessfulSyncTime").getter(LastSync.getter(LastSync::lastSuccessfulSyncTime)).setter(LastSync.setter(Builder::lastSuccessfulSyncTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulSyncTime").build()}).build();
    private static final SdkField<String> LAST_SUCCESSFUL_SYNC_PROVISIONING_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastSuccessfulSyncProvisioningArtifactId").getter(LastSync.getter(LastSync::lastSuccessfulSyncProvisioningArtifactId)).setter(LastSync.setter(Builder::lastSuccessfulSyncProvisioningArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulSyncProvisioningArtifactId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_SYNC_TIME_FIELD, LAST_SYNC_STATUS_FIELD, LAST_SYNC_STATUS_MESSAGE_FIELD, LAST_SUCCESSFUL_SYNC_TIME_FIELD, LAST_SUCCESSFUL_SYNC_PROVISIONING_ARTIFACT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LastSync.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant lastSyncTime;
    private final String lastSyncStatus;
    private final String lastSyncStatusMessage;
    private final Instant lastSuccessfulSyncTime;
    private final String lastSuccessfulSyncProvisioningArtifactId;

    private LastSync(BuilderImpl builder) {
        this.lastSyncTime = builder.lastSyncTime;
        this.lastSyncStatus = builder.lastSyncStatus;
        this.lastSyncStatusMessage = builder.lastSyncStatusMessage;
        this.lastSuccessfulSyncTime = builder.lastSuccessfulSyncTime;
        this.lastSuccessfulSyncProvisioningArtifactId = builder.lastSuccessfulSyncProvisioningArtifactId;
    }

    public final Instant lastSyncTime() {
        return this.lastSyncTime;
    }

    public final LastSyncStatus lastSyncStatus() {
        return LastSyncStatus.fromValue(this.lastSyncStatus);
    }

    public final String lastSyncStatusAsString() {
        return this.lastSyncStatus;
    }

    public final String lastSyncStatusMessage() {
        return this.lastSyncStatusMessage;
    }

    public final Instant lastSuccessfulSyncTime() {
        return this.lastSuccessfulSyncTime;
    }

    public final String lastSuccessfulSyncProvisioningArtifactId() {
        return this.lastSuccessfulSyncProvisioningArtifactId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSyncTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSyncStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSyncStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulSyncTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulSyncProvisioningArtifactId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LastSync)) {
            return false;
        }
        LastSync other = (LastSync)obj;
        return Objects.equals(this.lastSyncTime(), other.lastSyncTime()) && Objects.equals(this.lastSyncStatusAsString(), other.lastSyncStatusAsString()) && Objects.equals(this.lastSyncStatusMessage(), other.lastSyncStatusMessage()) && Objects.equals(this.lastSuccessfulSyncTime(), other.lastSuccessfulSyncTime()) && Objects.equals(this.lastSuccessfulSyncProvisioningArtifactId(), other.lastSuccessfulSyncProvisioningArtifactId());
    }

    public final String toString() {
        return ToString.builder((String)"LastSync").add("LastSyncTime", (Object)this.lastSyncTime()).add("LastSyncStatus", (Object)this.lastSyncStatusAsString()).add("LastSyncStatusMessage", (Object)this.lastSyncStatusMessage()).add("LastSuccessfulSyncTime", (Object)this.lastSuccessfulSyncTime()).add("LastSuccessfulSyncProvisioningArtifactId", (Object)this.lastSuccessfulSyncProvisioningArtifactId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LastSyncTime": {
                return Optional.ofNullable(clazz.cast(this.lastSyncTime()));
            }
            case "LastSyncStatus": {
                return Optional.ofNullable(clazz.cast(this.lastSyncStatusAsString()));
            }
            case "LastSyncStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.lastSyncStatusMessage()));
            }
            case "LastSuccessfulSyncTime": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulSyncTime()));
            }
            case "LastSuccessfulSyncProvisioningArtifactId": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulSyncProvisioningArtifactId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LastSyncTime", LAST_SYNC_TIME_FIELD);
        map.put("LastSyncStatus", LAST_SYNC_STATUS_FIELD);
        map.put("LastSyncStatusMessage", LAST_SYNC_STATUS_MESSAGE_FIELD);
        map.put("LastSuccessfulSyncTime", LAST_SUCCESSFUL_SYNC_TIME_FIELD);
        map.put("LastSuccessfulSyncProvisioningArtifactId", LAST_SUCCESSFUL_SYNC_PROVISIONING_ARTIFACT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LastSync, T> g) {
        return obj -> g.apply((LastSync)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant lastSyncTime;
        private String lastSyncStatus;
        private String lastSyncStatusMessage;
        private Instant lastSuccessfulSyncTime;
        private String lastSuccessfulSyncProvisioningArtifactId;

        private BuilderImpl() {
        }

        private BuilderImpl(LastSync model) {
            this.lastSyncTime(model.lastSyncTime);
            this.lastSyncStatus(model.lastSyncStatus);
            this.lastSyncStatusMessage(model.lastSyncStatusMessage);
            this.lastSuccessfulSyncTime(model.lastSuccessfulSyncTime);
            this.lastSuccessfulSyncProvisioningArtifactId(model.lastSuccessfulSyncProvisioningArtifactId);
        }

        public final Instant getLastSyncTime() {
            return this.lastSyncTime;
        }

        public final void setLastSyncTime(Instant lastSyncTime) {
            this.lastSyncTime = lastSyncTime;
        }

        @Override
        public final Builder lastSyncTime(Instant lastSyncTime) {
            this.lastSyncTime = lastSyncTime;
            return this;
        }

        public final String getLastSyncStatus() {
            return this.lastSyncStatus;
        }

        public final void setLastSyncStatus(String lastSyncStatus) {
            this.lastSyncStatus = lastSyncStatus;
        }

        @Override
        public final Builder lastSyncStatus(String lastSyncStatus) {
            this.lastSyncStatus = lastSyncStatus;
            return this;
        }

        @Override
        public final Builder lastSyncStatus(LastSyncStatus lastSyncStatus) {
            this.lastSyncStatus(lastSyncStatus == null ? null : lastSyncStatus.toString());
            return this;
        }

        public final String getLastSyncStatusMessage() {
            return this.lastSyncStatusMessage;
        }

        public final void setLastSyncStatusMessage(String lastSyncStatusMessage) {
            this.lastSyncStatusMessage = lastSyncStatusMessage;
        }

        @Override
        public final Builder lastSyncStatusMessage(String lastSyncStatusMessage) {
            this.lastSyncStatusMessage = lastSyncStatusMessage;
            return this;
        }

        public final Instant getLastSuccessfulSyncTime() {
            return this.lastSuccessfulSyncTime;
        }

        public final void setLastSuccessfulSyncTime(Instant lastSuccessfulSyncTime) {
            this.lastSuccessfulSyncTime = lastSuccessfulSyncTime;
        }

        @Override
        public final Builder lastSuccessfulSyncTime(Instant lastSuccessfulSyncTime) {
            this.lastSuccessfulSyncTime = lastSuccessfulSyncTime;
            return this;
        }

        public final String getLastSuccessfulSyncProvisioningArtifactId() {
            return this.lastSuccessfulSyncProvisioningArtifactId;
        }

        public final void setLastSuccessfulSyncProvisioningArtifactId(String lastSuccessfulSyncProvisioningArtifactId) {
            this.lastSuccessfulSyncProvisioningArtifactId = lastSuccessfulSyncProvisioningArtifactId;
        }

        @Override
        public final Builder lastSuccessfulSyncProvisioningArtifactId(String lastSuccessfulSyncProvisioningArtifactId) {
            this.lastSuccessfulSyncProvisioningArtifactId = lastSuccessfulSyncProvisioningArtifactId;
            return this;
        }

        public LastSync build() {
            return new LastSync(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LastSync> {
        public Builder lastSyncTime(Instant var1);

        public Builder lastSyncStatus(String var1);

        public Builder lastSyncStatus(LastSyncStatus var1);

        public Builder lastSyncStatusMessage(String var1);

        public Builder lastSuccessfulSyncTime(Instant var1);

        public Builder lastSuccessfulSyncProvisioningArtifactId(String var1);
    }
}

