/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAttributeGroupRequest extends ServiceCatalogAppRegistryRequest implements
        ToCopyableBuilder<DeleteAttributeGroupRequest.Builder, DeleteAttributeGroupRequest> {
    private static final SdkField<String> ATTRIBUTE_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attributeGroup").getter(getter(DeleteAttributeGroupRequest::attributeGroup))
            .setter(setter(Builder::attributeGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("attributeGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_GROUP_FIELD));

    private final String attributeGroup;

    private DeleteAttributeGroupRequest(BuilderImpl builder) {
        super(builder);
        this.attributeGroup = builder.attributeGroup;
    }

    /**
     * <p>
     * The name or ID of the attribute group that holds the attributes to describe the application.
     * </p>
     * 
     * @return The name or ID of the attribute group that holds the attributes to describe the application.
     */
    public final String attributeGroup() {
        return attributeGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attributeGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAttributeGroupRequest)) {
            return false;
        }
        DeleteAttributeGroupRequest other = (DeleteAttributeGroupRequest) obj;
        return Objects.equals(attributeGroup(), other.attributeGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAttributeGroupRequest").add("AttributeGroup", attributeGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributeGroup":
            return Optional.ofNullable(clazz.cast(attributeGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAttributeGroupRequest, T> g) {
        return obj -> g.apply((DeleteAttributeGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogAppRegistryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteAttributeGroupRequest> {
        /**
         * <p>
         * The name or ID of the attribute group that holds the attributes to describe the application.
         * </p>
         * 
         * @param attributeGroup
         *        The name or ID of the attribute group that holds the attributes to describe the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeGroup(String attributeGroup);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogAppRegistryRequest.BuilderImpl implements Builder {
        private String attributeGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAttributeGroupRequest model) {
            super(model);
            attributeGroup(model.attributeGroup);
        }

        public final String getAttributeGroup() {
            return attributeGroup;
        }

        public final void setAttributeGroup(String attributeGroup) {
            this.attributeGroup = attributeGroup;
        }

        @Override
        @Transient
        public final Builder attributeGroup(String attributeGroup) {
            this.attributeGroup = attributeGroup;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAttributeGroupRequest build() {
            return new DeleteAttributeGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
