/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicediscovery.model.Namespace;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetNamespaceResponse
extends ServiceDiscoveryResponse
implements ToCopyableBuilder<Builder, GetNamespaceResponse> {
    private static final SdkField<Namespace> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Namespace").getter(GetNamespaceResponse.getter(GetNamespaceResponse::namespace)).setter(GetNamespaceResponse.setter(Builder::namespace)).constructor(Namespace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetNamespaceResponse.memberNameToFieldInitializer();
    private final Namespace namespace;

    private GetNamespaceResponse(BuilderImpl builder) {
        super(builder);
        this.namespace = builder.namespace;
    }

    public final Namespace namespace() {
        return this.namespace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNamespaceResponse)) {
            return false;
        }
        GetNamespaceResponse other = (GetNamespaceResponse)((Object)obj);
        return Objects.equals(this.namespace(), other.namespace());
    }

    public final String toString() {
        return ToString.builder((String)"GetNamespaceResponse").add("Namespace", (Object)this.namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Namespace>> map = new HashMap<String, SdkField<Namespace>>();
        map.put("Namespace", NAMESPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetNamespaceResponse, T> g) {
        return obj -> g.apply((GetNamespaceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceDiscoveryResponse.BuilderImpl
    implements Builder {
        private Namespace namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNamespaceResponse model) {
            super(model);
            this.namespace(model.namespace);
        }

        public final Namespace.Builder getNamespace() {
            return this.namespace != null ? this.namespace.toBuilder() : null;
        }

        public final void setNamespace(Namespace.BuilderImpl namespace) {
            this.namespace = namespace != null ? namespace.build() : null;
        }

        @Override
        public final Builder namespace(Namespace namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public GetNamespaceResponse build() {
            return new GetNamespaceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ServiceDiscoveryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetNamespaceResponse> {
        public Builder namespace(Namespace var1);

        default public Builder namespace(Consumer<Namespace.Builder> namespace) {
            return this.namespace((Namespace)((Namespace.Builder)Namespace.builder().applyMutation(namespace)).build());
        }
    }
}

