/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicediscovery.model.SOA;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DnsProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DnsProperties> {
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostedZoneId").getter(DnsProperties.getter(DnsProperties::hostedZoneId)).setter(DnsProperties.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId").build()}).build();
    private static final SdkField<SOA> SOA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SOA").getter(DnsProperties.getter(DnsProperties::soa)).setter(DnsProperties.setter(Builder::soa)).constructor(SOA::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SOA").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_ID_FIELD, SOA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DnsProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String hostedZoneId;
    private final SOA soa;

    private DnsProperties(BuilderImpl builder) {
        this.hostedZoneId = builder.hostedZoneId;
        this.soa = builder.soa;
    }

    public final String hostedZoneId() {
        return this.hostedZoneId;
    }

    public final SOA soa() {
        return this.soa;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.soa());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsProperties)) {
            return false;
        }
        DnsProperties other = (DnsProperties)obj;
        return Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.soa(), other.soa());
    }

    public final String toString() {
        return ToString.builder((String)"DnsProperties").add("HostedZoneId", (Object)this.hostedZoneId()).add("SOA", (Object)this.soa()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "SOA": {
                return Optional.ofNullable(clazz.cast(this.soa()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HostedZoneId", HOSTED_ZONE_ID_FIELD);
        map.put("SOA", SOA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DnsProperties, T> g) {
        return obj -> g.apply((DnsProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hostedZoneId;
        private SOA soa;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsProperties model) {
            this.hostedZoneId(model.hostedZoneId);
            this.soa(model.soa);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final SOA.Builder getSoa() {
            return this.soa != null ? this.soa.toBuilder() : null;
        }

        public final void setSoa(SOA.BuilderImpl soa) {
            this.soa = soa != null ? soa.build() : null;
        }

        @Override
        public final Builder soa(SOA soa) {
            this.soa = soa;
            return this;
        }

        public DnsProperties build() {
            return new DnsProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DnsProperties> {
        public Builder hostedZoneId(String var1);

        public Builder soa(SOA var1);

        default public Builder soa(Consumer<SOA.Builder> soa) {
            return this.soa((SOA)((SOA.Builder)SOA.builder().applyMutation(soa)).build());
        }
    }
}

