/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents sending statistics data. Each <code>SendDataPoint</code> contains statistics for a 15-minute period of
 * sending activity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendDataPoint implements SdkPojo, Serializable, ToCopyableBuilder<SendDataPoint.Builder, SendDataPoint> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(SendDataPoint::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<Long> DELIVERY_ATTEMPTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DeliveryAttempts").getter(getter(SendDataPoint::deliveryAttempts))
            .setter(setter(Builder::deliveryAttempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryAttempts").build()).build();

    private static final SdkField<Long> BOUNCES_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Bounces")
            .getter(getter(SendDataPoint::bounces)).setter(setter(Builder::bounces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bounces").build()).build();

    private static final SdkField<Long> COMPLAINTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Complaints")
            .getter(getter(SendDataPoint::complaints)).setter(setter(Builder::complaints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Complaints").build()).build();

    private static final SdkField<Long> REJECTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Rejects")
            .getter(getter(SendDataPoint::rejects)).setter(setter(Builder::rejects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rejects").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD,
            DELIVERY_ATTEMPTS_FIELD, BOUNCES_FIELD, COMPLAINTS_FIELD, REJECTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant timestamp;

    private final Long deliveryAttempts;

    private final Long bounces;

    private final Long complaints;

    private final Long rejects;

    private SendDataPoint(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.deliveryAttempts = builder.deliveryAttempts;
        this.bounces = builder.bounces;
        this.complaints = builder.complaints;
        this.rejects = builder.rejects;
    }

    /**
     * <p>
     * Time of the data point.
     * </p>
     * 
     * @return Time of the data point.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * Number of emails that have been sent.
     * </p>
     * 
     * @return Number of emails that have been sent.
     */
    public final Long deliveryAttempts() {
        return deliveryAttempts;
    }

    /**
     * <p>
     * Number of emails that have bounced.
     * </p>
     * 
     * @return Number of emails that have bounced.
     */
    public final Long bounces() {
        return bounces;
    }

    /**
     * <p>
     * Number of unwanted emails that were rejected by recipients.
     * </p>
     * 
     * @return Number of unwanted emails that were rejected by recipients.
     */
    public final Long complaints() {
        return complaints;
    }

    /**
     * <p>
     * Number of emails rejected by Amazon SES.
     * </p>
     * 
     * @return Number of emails rejected by Amazon SES.
     */
    public final Long rejects() {
        return rejects;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(bounces());
        hashCode = 31 * hashCode + Objects.hashCode(complaints());
        hashCode = 31 * hashCode + Objects.hashCode(rejects());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendDataPoint)) {
            return false;
        }
        SendDataPoint other = (SendDataPoint) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(deliveryAttempts(), other.deliveryAttempts())
                && Objects.equals(bounces(), other.bounces()) && Objects.equals(complaints(), other.complaints())
                && Objects.equals(rejects(), other.rejects());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendDataPoint").add("Timestamp", timestamp()).add("DeliveryAttempts", deliveryAttempts())
                .add("Bounces", bounces()).add("Complaints", complaints()).add("Rejects", rejects()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "DeliveryAttempts":
            return Optional.ofNullable(clazz.cast(deliveryAttempts()));
        case "Bounces":
            return Optional.ofNullable(clazz.cast(bounces()));
        case "Complaints":
            return Optional.ofNullable(clazz.cast(complaints()));
        case "Rejects":
            return Optional.ofNullable(clazz.cast(rejects()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendDataPoint, T> g) {
        return obj -> g.apply((SendDataPoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SendDataPoint> {
        /**
         * <p>
         * Time of the data point.
         * </p>
         * 
         * @param timestamp
         *        Time of the data point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * Number of emails that have been sent.
         * </p>
         * 
         * @param deliveryAttempts
         *        Number of emails that have been sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryAttempts(Long deliveryAttempts);

        /**
         * <p>
         * Number of emails that have bounced.
         * </p>
         * 
         * @param bounces
         *        Number of emails that have bounced.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bounces(Long bounces);

        /**
         * <p>
         * Number of unwanted emails that were rejected by recipients.
         * </p>
         * 
         * @param complaints
         *        Number of unwanted emails that were rejected by recipients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complaints(Long complaints);

        /**
         * <p>
         * Number of emails rejected by Amazon SES.
         * </p>
         * 
         * @param rejects
         *        Number of emails rejected by Amazon SES.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejects(Long rejects);
    }

    static final class BuilderImpl implements Builder {
        private Instant timestamp;

        private Long deliveryAttempts;

        private Long bounces;

        private Long complaints;

        private Long rejects;

        private BuilderImpl() {
        }

        private BuilderImpl(SendDataPoint model) {
            timestamp(model.timestamp);
            deliveryAttempts(model.deliveryAttempts);
            bounces(model.bounces);
            complaints(model.complaints);
            rejects(model.rejects);
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        @Transient
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Long getDeliveryAttempts() {
            return deliveryAttempts;
        }

        public final void setDeliveryAttempts(Long deliveryAttempts) {
            this.deliveryAttempts = deliveryAttempts;
        }

        @Override
        @Transient
        public final Builder deliveryAttempts(Long deliveryAttempts) {
            this.deliveryAttempts = deliveryAttempts;
            return this;
        }

        public final Long getBounces() {
            return bounces;
        }

        public final void setBounces(Long bounces) {
            this.bounces = bounces;
        }

        @Override
        @Transient
        public final Builder bounces(Long bounces) {
            this.bounces = bounces;
            return this;
        }

        public final Long getComplaints() {
            return complaints;
        }

        public final void setComplaints(Long complaints) {
            this.complaints = complaints;
        }

        @Override
        @Transient
        public final Builder complaints(Long complaints) {
            this.complaints = complaints;
            return this;
        }

        public final Long getRejects() {
            return rejects;
        }

        public final void setRejects(Long rejects) {
            this.rejects = rejects;
        }

        @Override
        @Transient
        public final Builder rejects(Long rejects) {
            this.rejects = rejects;
            return this;
        }

        @Override
        public SendDataPoint build() {
            return new SendDataPoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
