/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the message to be sent, composed of a subject and a body.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Message implements SdkPojo, Serializable, ToCopyableBuilder<Message.Builder, Message> {
    private static final SdkField<Content> SUBJECT_FIELD = SdkField.<Content> builder(MarshallingType.SDK_POJO)
            .memberName("Subject").getter(getter(Message::subject)).setter(setter(Builder::subject))
            .constructor(Content::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<Body> BODY_FIELD = SdkField.<Body> builder(MarshallingType.SDK_POJO).memberName("Body")
            .getter(getter(Message::body)).setter(setter(Builder::body)).constructor(Body::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBJECT_FIELD, BODY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Content subject;

    private final Body body;

    private Message(BuilderImpl builder) {
        this.subject = builder.subject;
        this.body = builder.body;
    }

    /**
     * <p>
     * The subject of the message: A short summary of the content, which appears in the recipient's inbox.
     * </p>
     * 
     * @return The subject of the message: A short summary of the content, which appears in the recipient's inbox.
     */
    public final Content subject() {
        return subject;
    }

    /**
     * <p>
     * The message body.
     * </p>
     * 
     * @return The message body.
     */
    public final Body body() {
        return body;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message) obj;
        return Objects.equals(subject(), other.subject()) && Objects.equals(body(), other.body());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Message").add("Subject", subject()).add("Body", body()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Message, T> g) {
        return obj -> g.apply((Message) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Message> {
        /**
         * <p>
         * The subject of the message: A short summary of the content, which appears in the recipient's inbox.
         * </p>
         * 
         * @param subject
         *        The subject of the message: A short summary of the content, which appears in the recipient's inbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(Content subject);

        /**
         * <p>
         * The subject of the message: A short summary of the content, which appears in the recipient's inbox.
         * </p>
         * This is a convenience method that creates an instance of the {@link Content.Builder} avoiding the need to
         * create one manually via {@link Content#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Content.Builder#build()} is called immediately and its result is
         * passed to {@link #subject(Content)}.
         * 
         * @param subject
         *        a consumer that will call methods on {@link Content.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subject(Content)
         */
        default Builder subject(Consumer<Content.Builder> subject) {
            return subject(Content.builder().applyMutation(subject).build());
        }

        /**
         * <p>
         * The message body.
         * </p>
         * 
         * @param body
         *        The message body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(Body body);

        /**
         * <p>
         * The message body.
         * </p>
         * This is a convenience method that creates an instance of the {@link Body.Builder} avoiding the need to create
         * one manually via {@link Body#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Body.Builder#build()} is called immediately and its result is
         * passed to {@link #body(Body)}.
         * 
         * @param body
         *        a consumer that will call methods on {@link Body.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #body(Body)
         */
        default Builder body(Consumer<Body.Builder> body) {
            return body(Body.builder().applyMutation(body).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Content subject;

        private Body body;

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            subject(model.subject);
            body(model.body);
        }

        public final Content.Builder getSubject() {
            return subject != null ? subject.toBuilder() : null;
        }

        public final void setSubject(Content.BuilderImpl subject) {
            this.subject = subject != null ? subject.build() : null;
        }

        @Override
        public final Builder subject(Content subject) {
            this.subject = subject;
            return this;
        }

        public final Body.Builder getBody() {
            return body != null ? body.toBuilder() : null;
        }

        public final void setBody(Body.BuilderImpl body) {
            this.body = body != null ? body.build() : null;
        }

        @Override
        public final Builder body(Body body) {
            this.body = body;
            return this;
        }

        @Override
        public Message build() {
            return new Message(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
