/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of the <code>SendBulkEmail</code> operation of each specified <code>BulkEmailEntry</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BulkEmailEntryResult implements SdkPojo, Serializable,
        ToCopyableBuilder<BulkEmailEntryResult.Builder, BulkEmailEntryResult> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(BulkEmailEntryResult::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Error")
            .getter(getter(BulkEmailEntryResult::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageId").getter(getter(BulkEmailEntryResult::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ERROR_FIELD,
            MESSAGE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String error;

    private final String messageId;

    private BulkEmailEntryResult(BuilderImpl builder) {
        this.status = builder.status;
        this.error = builder.error;
        this.messageId = builder.messageId;
    }

    /**
     * <p>
     * The status of a message sent using the <code>SendBulkTemplatedEmail</code> operation.
     * </p>
     * <p>
     * Possible values for this parameter include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SUCCESS: Amazon SES accepted the message, and will attempt to deliver it to the recipients.
     * </p>
     * </li>
     * <li>
     * <p>
     * MESSAGE_REJECTED: The message was rejected because it contained a virus.
     * </p>
     * </li>
     * <li>
     * <p>
     * MAIL_FROM_DOMAIN_NOT_VERIFIED: The sender's email address or domain was not verified.
     * </p>
     * </li>
     * <li>
     * <p>
     * CONFIGURATION_SET_DOES_NOT_EXIST: The configuration set you specified does not exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * TEMPLATE_DOES_NOT_EXIST: The template you specified does not exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACCOUNT_SUSPENDED: Your account has been shut down because of issues related to your email sending practices.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACCOUNT_THROTTLED: The number of emails you can send has been reduced because your account has exceeded its
     * allocated sending limit.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACCOUNT_DAILY_QUOTA_EXCEEDED: You have reached or exceeded the maximum number of emails you can send from your
     * account in a 24-hour period.
     * </p>
     * </li>
     * <li>
     * <p>
     * INVALID_SENDING_POOL_NAME: The configuration set you specified refers to an IP pool that does not exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACCOUNT_SENDING_PAUSED: Email sending for the Amazon SES account was disabled using the <a
     * href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateAccountSendingEnabled.html"
     * >UpdateAccountSendingEnabled</a> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * CONFIGURATION_SET_SENDING_PAUSED: Email sending for this configuration set was disabled using the <a
     * href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateConfigurationSetSendingEnabled.html"
     * >UpdateConfigurationSetSendingEnabled</a> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * INVALID_PARAMETER_VALUE: One or more of the parameters you specified when calling this operation was invalid. See
     * the error message for additional information.
     * </p>
     * </li>
     * <li>
     * <p>
     * TRANSIENT_FAILURE: Amazon SES was unable to process your request because of a temporary issue.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED: Amazon SES was unable to process your request. See the error message for additional information.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BulkEmailStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a message sent using the <code>SendBulkTemplatedEmail</code> operation.</p>
     *         <p>
     *         Possible values for this parameter include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         SUCCESS: Amazon SES accepted the message, and will attempt to deliver it to the recipients.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MESSAGE_REJECTED: The message was rejected because it contained a virus.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAIL_FROM_DOMAIN_NOT_VERIFIED: The sender's email address or domain was not verified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CONFIGURATION_SET_DOES_NOT_EXIST: The configuration set you specified does not exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TEMPLATE_DOES_NOT_EXIST: The template you specified does not exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_SUSPENDED: Your account has been shut down because of issues related to your email sending
     *         practices.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_THROTTLED: The number of emails you can send has been reduced because your account has exceeded
     *         its allocated sending limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_DAILY_QUOTA_EXCEEDED: You have reached or exceeded the maximum number of emails you can send from
     *         your account in a 24-hour period.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SENDING_POOL_NAME: The configuration set you specified refers to an IP pool that does not exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_SENDING_PAUSED: Email sending for the Amazon SES account was disabled using the <a
     *         href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateAccountSendingEnabled.html"
     *         >UpdateAccountSendingEnabled</a> operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CONFIGURATION_SET_SENDING_PAUSED: Email sending for this configuration set was disabled using the <a
     *         href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateConfigurationSetSendingEnabled.html">
     *         UpdateConfigurationSetSendingEnabled</a> operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARAMETER_VALUE: One or more of the parameters you specified when calling this operation was
     *         invalid. See the error message for additional information.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TRANSIENT_FAILURE: Amazon SES was unable to process your request because of a temporary issue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED: Amazon SES was unable to process your request. See the error message for additional information.
     *         </p>
     *         </li>
     * @see BulkEmailStatus
     */
    public final BulkEmailStatus status() {
        return BulkEmailStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a message sent using the <code>SendBulkTemplatedEmail</code> operation.
     * </p>
     * <p>
     * Possible values for this parameter include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SUCCESS: Amazon SES accepted the message, and will attempt to deliver it to the recipients.
     * </p>
     * </li>
     * <li>
     * <p>
     * MESSAGE_REJECTED: The message was rejected because it contained a virus.
     * </p>
     * </li>
     * <li>
     * <p>
     * MAIL_FROM_DOMAIN_NOT_VERIFIED: The sender's email address or domain was not verified.
     * </p>
     * </li>
     * <li>
     * <p>
     * CONFIGURATION_SET_DOES_NOT_EXIST: The configuration set you specified does not exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * TEMPLATE_DOES_NOT_EXIST: The template you specified does not exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACCOUNT_SUSPENDED: Your account has been shut down because of issues related to your email sending practices.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACCOUNT_THROTTLED: The number of emails you can send has been reduced because your account has exceeded its
     * allocated sending limit.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACCOUNT_DAILY_QUOTA_EXCEEDED: You have reached or exceeded the maximum number of emails you can send from your
     * account in a 24-hour period.
     * </p>
     * </li>
     * <li>
     * <p>
     * INVALID_SENDING_POOL_NAME: The configuration set you specified refers to an IP pool that does not exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACCOUNT_SENDING_PAUSED: Email sending for the Amazon SES account was disabled using the <a
     * href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateAccountSendingEnabled.html"
     * >UpdateAccountSendingEnabled</a> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * CONFIGURATION_SET_SENDING_PAUSED: Email sending for this configuration set was disabled using the <a
     * href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateConfigurationSetSendingEnabled.html"
     * >UpdateConfigurationSetSendingEnabled</a> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * INVALID_PARAMETER_VALUE: One or more of the parameters you specified when calling this operation was invalid. See
     * the error message for additional information.
     * </p>
     * </li>
     * <li>
     * <p>
     * TRANSIENT_FAILURE: Amazon SES was unable to process your request because of a temporary issue.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED: Amazon SES was unable to process your request. See the error message for additional information.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BulkEmailStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a message sent using the <code>SendBulkTemplatedEmail</code> operation.</p>
     *         <p>
     *         Possible values for this parameter include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         SUCCESS: Amazon SES accepted the message, and will attempt to deliver it to the recipients.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MESSAGE_REJECTED: The message was rejected because it contained a virus.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAIL_FROM_DOMAIN_NOT_VERIFIED: The sender's email address or domain was not verified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CONFIGURATION_SET_DOES_NOT_EXIST: The configuration set you specified does not exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TEMPLATE_DOES_NOT_EXIST: The template you specified does not exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_SUSPENDED: Your account has been shut down because of issues related to your email sending
     *         practices.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_THROTTLED: The number of emails you can send has been reduced because your account has exceeded
     *         its allocated sending limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_DAILY_QUOTA_EXCEEDED: You have reached or exceeded the maximum number of emails you can send from
     *         your account in a 24-hour period.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_SENDING_POOL_NAME: The configuration set you specified refers to an IP pool that does not exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACCOUNT_SENDING_PAUSED: Email sending for the Amazon SES account was disabled using the <a
     *         href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateAccountSendingEnabled.html"
     *         >UpdateAccountSendingEnabled</a> operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CONFIGURATION_SET_SENDING_PAUSED: Email sending for this configuration set was disabled using the <a
     *         href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateConfigurationSetSendingEnabled.html">
     *         UpdateConfigurationSetSendingEnabled</a> operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_PARAMETER_VALUE: One or more of the parameters you specified when calling this operation was
     *         invalid. See the error message for additional information.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TRANSIENT_FAILURE: Amazon SES was unable to process your request because of a temporary issue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED: Amazon SES was unable to process your request. See the error message for additional information.
     *         </p>
     *         </li>
     * @see BulkEmailStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A description of an error that prevented a message being sent using the <code>SendBulkTemplatedEmail</code>
     * operation.
     * </p>
     * 
     * @return A description of an error that prevented a message being sent using the
     *         <code>SendBulkTemplatedEmail</code> operation.
     */
    public final String error() {
        return error;
    }

    /**
     * <p>
     * The unique message identifier returned from the <code>SendBulkTemplatedEmail</code> operation.
     * </p>
     * 
     * @return The unique message identifier returned from the <code>SendBulkTemplatedEmail</code> operation.
     */
    public final String messageId() {
        return messageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BulkEmailEntryResult)) {
            return false;
        }
        BulkEmailEntryResult other = (BulkEmailEntryResult) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(error(), other.error())
                && Objects.equals(messageId(), other.messageId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BulkEmailEntryResult").add("Status", statusAsString()).add("Error", error())
                .add("MessageId", messageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "MessageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BulkEmailEntryResult, T> g) {
        return obj -> g.apply((BulkEmailEntryResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BulkEmailEntryResult> {
        /**
         * <p>
         * The status of a message sent using the <code>SendBulkTemplatedEmail</code> operation.
         * </p>
         * <p>
         * Possible values for this parameter include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SUCCESS: Amazon SES accepted the message, and will attempt to deliver it to the recipients.
         * </p>
         * </li>
         * <li>
         * <p>
         * MESSAGE_REJECTED: The message was rejected because it contained a virus.
         * </p>
         * </li>
         * <li>
         * <p>
         * MAIL_FROM_DOMAIN_NOT_VERIFIED: The sender's email address or domain was not verified.
         * </p>
         * </li>
         * <li>
         * <p>
         * CONFIGURATION_SET_DOES_NOT_EXIST: The configuration set you specified does not exist.
         * </p>
         * </li>
         * <li>
         * <p>
         * TEMPLATE_DOES_NOT_EXIST: The template you specified does not exist.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACCOUNT_SUSPENDED: Your account has been shut down because of issues related to your email sending practices.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACCOUNT_THROTTLED: The number of emails you can send has been reduced because your account has exceeded its
         * allocated sending limit.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACCOUNT_DAILY_QUOTA_EXCEEDED: You have reached or exceeded the maximum number of emails you can send from
         * your account in a 24-hour period.
         * </p>
         * </li>
         * <li>
         * <p>
         * INVALID_SENDING_POOL_NAME: The configuration set you specified refers to an IP pool that does not exist.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACCOUNT_SENDING_PAUSED: Email sending for the Amazon SES account was disabled using the <a
         * href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateAccountSendingEnabled.html"
         * >UpdateAccountSendingEnabled</a> operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * CONFIGURATION_SET_SENDING_PAUSED: Email sending for this configuration set was disabled using the <a
         * href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateConfigurationSetSendingEnabled.html"
         * >UpdateConfigurationSetSendingEnabled</a> operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * INVALID_PARAMETER_VALUE: One or more of the parameters you specified when calling this operation was invalid.
         * See the error message for additional information.
         * </p>
         * </li>
         * <li>
         * <p>
         * TRANSIENT_FAILURE: Amazon SES was unable to process your request because of a temporary issue.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: Amazon SES was unable to process your request. See the error message for additional information.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of a message sent using the <code>SendBulkTemplatedEmail</code> operation.</p>
         *        <p>
         *        Possible values for this parameter include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SUCCESS: Amazon SES accepted the message, and will attempt to deliver it to the recipients.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MESSAGE_REJECTED: The message was rejected because it contained a virus.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MAIL_FROM_DOMAIN_NOT_VERIFIED: The sender's email address or domain was not verified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CONFIGURATION_SET_DOES_NOT_EXIST: The configuration set you specified does not exist.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TEMPLATE_DOES_NOT_EXIST: The template you specified does not exist.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACCOUNT_SUSPENDED: Your account has been shut down because of issues related to your email sending
         *        practices.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACCOUNT_THROTTLED: The number of emails you can send has been reduced because your account has
         *        exceeded its allocated sending limit.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACCOUNT_DAILY_QUOTA_EXCEEDED: You have reached or exceeded the maximum number of emails you can send
         *        from your account in a 24-hour period.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INVALID_SENDING_POOL_NAME: The configuration set you specified refers to an IP pool that does not
         *        exist.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACCOUNT_SENDING_PAUSED: Email sending for the Amazon SES account was disabled using the <a
         *        href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateAccountSendingEnabled.html"
         *        >UpdateAccountSendingEnabled</a> operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CONFIGURATION_SET_SENDING_PAUSED: Email sending for this configuration set was disabled using the <a
         *        href
         *        ="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateConfigurationSetSendingEnabled.html"
         *        >UpdateConfigurationSetSendingEnabled</a> operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INVALID_PARAMETER_VALUE: One or more of the parameters you specified when calling this operation was
         *        invalid. See the error message for additional information.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TRANSIENT_FAILURE: Amazon SES was unable to process your request because of a temporary issue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: Amazon SES was unable to process your request. See the error message for additional
         *        information.
         *        </p>
         *        </li>
         * @see BulkEmailStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BulkEmailStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a message sent using the <code>SendBulkTemplatedEmail</code> operation.
         * </p>
         * <p>
         * Possible values for this parameter include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SUCCESS: Amazon SES accepted the message, and will attempt to deliver it to the recipients.
         * </p>
         * </li>
         * <li>
         * <p>
         * MESSAGE_REJECTED: The message was rejected because it contained a virus.
         * </p>
         * </li>
         * <li>
         * <p>
         * MAIL_FROM_DOMAIN_NOT_VERIFIED: The sender's email address or domain was not verified.
         * </p>
         * </li>
         * <li>
         * <p>
         * CONFIGURATION_SET_DOES_NOT_EXIST: The configuration set you specified does not exist.
         * </p>
         * </li>
         * <li>
         * <p>
         * TEMPLATE_DOES_NOT_EXIST: The template you specified does not exist.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACCOUNT_SUSPENDED: Your account has been shut down because of issues related to your email sending practices.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACCOUNT_THROTTLED: The number of emails you can send has been reduced because your account has exceeded its
         * allocated sending limit.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACCOUNT_DAILY_QUOTA_EXCEEDED: You have reached or exceeded the maximum number of emails you can send from
         * your account in a 24-hour period.
         * </p>
         * </li>
         * <li>
         * <p>
         * INVALID_SENDING_POOL_NAME: The configuration set you specified refers to an IP pool that does not exist.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACCOUNT_SENDING_PAUSED: Email sending for the Amazon SES account was disabled using the <a
         * href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateAccountSendingEnabled.html"
         * >UpdateAccountSendingEnabled</a> operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * CONFIGURATION_SET_SENDING_PAUSED: Email sending for this configuration set was disabled using the <a
         * href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateConfigurationSetSendingEnabled.html"
         * >UpdateConfigurationSetSendingEnabled</a> operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * INVALID_PARAMETER_VALUE: One or more of the parameters you specified when calling this operation was invalid.
         * See the error message for additional information.
         * </p>
         * </li>
         * <li>
         * <p>
         * TRANSIENT_FAILURE: Amazon SES was unable to process your request because of a temporary issue.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: Amazon SES was unable to process your request. See the error message for additional information.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of a message sent using the <code>SendBulkTemplatedEmail</code> operation.</p>
         *        <p>
         *        Possible values for this parameter include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SUCCESS: Amazon SES accepted the message, and will attempt to deliver it to the recipients.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MESSAGE_REJECTED: The message was rejected because it contained a virus.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MAIL_FROM_DOMAIN_NOT_VERIFIED: The sender's email address or domain was not verified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CONFIGURATION_SET_DOES_NOT_EXIST: The configuration set you specified does not exist.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TEMPLATE_DOES_NOT_EXIST: The template you specified does not exist.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACCOUNT_SUSPENDED: Your account has been shut down because of issues related to your email sending
         *        practices.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACCOUNT_THROTTLED: The number of emails you can send has been reduced because your account has
         *        exceeded its allocated sending limit.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACCOUNT_DAILY_QUOTA_EXCEEDED: You have reached or exceeded the maximum number of emails you can send
         *        from your account in a 24-hour period.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INVALID_SENDING_POOL_NAME: The configuration set you specified refers to an IP pool that does not
         *        exist.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACCOUNT_SENDING_PAUSED: Email sending for the Amazon SES account was disabled using the <a
         *        href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateAccountSendingEnabled.html"
         *        >UpdateAccountSendingEnabled</a> operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CONFIGURATION_SET_SENDING_PAUSED: Email sending for this configuration set was disabled using the <a
         *        href
         *        ="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateConfigurationSetSendingEnabled.html"
         *        >UpdateConfigurationSetSendingEnabled</a> operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INVALID_PARAMETER_VALUE: One or more of the parameters you specified when calling this operation was
         *        invalid. See the error message for additional information.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TRANSIENT_FAILURE: Amazon SES was unable to process your request because of a temporary issue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: Amazon SES was unable to process your request. See the error message for additional
         *        information.
         *        </p>
         *        </li>
         * @see BulkEmailStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BulkEmailStatus
         */
        Builder status(BulkEmailStatus status);

        /**
         * <p>
         * A description of an error that prevented a message being sent using the <code>SendBulkTemplatedEmail</code>
         * operation.
         * </p>
         * 
         * @param error
         *        A description of an error that prevented a message being sent using the
         *        <code>SendBulkTemplatedEmail</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * <p>
         * The unique message identifier returned from the <code>SendBulkTemplatedEmail</code> operation.
         * </p>
         * 
         * @param messageId
         *        The unique message identifier returned from the <code>SendBulkTemplatedEmail</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String error;

        private String messageId;

        private BuilderImpl() {
        }

        private BuilderImpl(BulkEmailEntryResult model) {
            status(model.status);
            error(model.error);
            messageId(model.messageId);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(BulkEmailStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        @Transient
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        @Transient
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        @Override
        public BulkEmailEntryResult build() {
            return new BulkEmailEntryResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
