/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used for filtering by a specific topic preference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicFilter implements SdkPojo, Serializable, ToCopyableBuilder<TopicFilter.Builder, TopicFilter> {
    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicName").getter(getter(TopicFilter::topicName)).setter(setter(Builder::topicName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicName").build()).build();

    private static final SdkField<Boolean> USE_DEFAULT_IF_PREFERENCE_UNAVAILABLE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseDefaultIfPreferenceUnavailable")
            .getter(getter(TopicFilter::useDefaultIfPreferenceUnavailable))
            .setter(setter(Builder::useDefaultIfPreferenceUnavailable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseDefaultIfPreferenceUnavailable")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_NAME_FIELD,
            USE_DEFAULT_IF_PREFERENCE_UNAVAILABLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String topicName;

    private final Boolean useDefaultIfPreferenceUnavailable;

    private TopicFilter(BuilderImpl builder) {
        this.topicName = builder.topicName;
        this.useDefaultIfPreferenceUnavailable = builder.useDefaultIfPreferenceUnavailable;
    }

    /**
     * <p>
     * The name of a topic on which you wish to apply the filter.
     * </p>
     * 
     * @return The name of a topic on which you wish to apply the filter.
     */
    public final String topicName() {
        return topicName;
    }

    /**
     * <p>
     * Notes that the default subscription status should be applied to a contact because the contact has not noted their
     * preference for subscribing to a topic.
     * </p>
     * 
     * @return Notes that the default subscription status should be applied to a contact because the contact has not
     *         noted their preference for subscribing to a topic.
     */
    public final Boolean useDefaultIfPreferenceUnavailable() {
        return useDefaultIfPreferenceUnavailable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topicName());
        hashCode = 31 * hashCode + Objects.hashCode(useDefaultIfPreferenceUnavailable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicFilter)) {
            return false;
        }
        TopicFilter other = (TopicFilter) obj;
        return Objects.equals(topicName(), other.topicName())
                && Objects.equals(useDefaultIfPreferenceUnavailable(), other.useDefaultIfPreferenceUnavailable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicFilter").add("TopicName", topicName())
                .add("UseDefaultIfPreferenceUnavailable", useDefaultIfPreferenceUnavailable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicName":
            return Optional.ofNullable(clazz.cast(topicName()));
        case "UseDefaultIfPreferenceUnavailable":
            return Optional.ofNullable(clazz.cast(useDefaultIfPreferenceUnavailable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicFilter, T> g) {
        return obj -> g.apply((TopicFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicFilter> {
        /**
         * <p>
         * The name of a topic on which you wish to apply the filter.
         * </p>
         * 
         * @param topicName
         *        The name of a topic on which you wish to apply the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicName(String topicName);

        /**
         * <p>
         * Notes that the default subscription status should be applied to a contact because the contact has not noted
         * their preference for subscribing to a topic.
         * </p>
         * 
         * @param useDefaultIfPreferenceUnavailable
         *        Notes that the default subscription status should be applied to a contact because the contact has not
         *        noted their preference for subscribing to a topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useDefaultIfPreferenceUnavailable(Boolean useDefaultIfPreferenceUnavailable);
    }

    static final class BuilderImpl implements Builder {
        private String topicName;

        private Boolean useDefaultIfPreferenceUnavailable;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicFilter model) {
            topicName(model.topicName);
            useDefaultIfPreferenceUnavailable(model.useDefaultIfPreferenceUnavailable);
        }

        public final String getTopicName() {
            return topicName;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        @Transient
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final Boolean getUseDefaultIfPreferenceUnavailable() {
            return useDefaultIfPreferenceUnavailable;
        }

        public final void setUseDefaultIfPreferenceUnavailable(Boolean useDefaultIfPreferenceUnavailable) {
            this.useDefaultIfPreferenceUnavailable = useDefaultIfPreferenceUnavailable;
        }

        @Override
        @Transient
        public final Builder useDefaultIfPreferenceUnavailable(Boolean useDefaultIfPreferenceUnavailable) {
            this.useDefaultIfPreferenceUnavailable = useDefaultIfPreferenceUnavailable;
            return this;
        }

        @Override
        public TopicFilter build() {
            return new TopicFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
