/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sesv2.endpoints.SesV2EndpointParams;
import software.amazon.awssdk.services.sesv2.endpoints.SesV2EndpointProvider;
import software.amazon.awssdk.services.sesv2.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.sesv2.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.sesv2.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultSesV2EndpointProvider
implements SesV2EndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(SesV2EndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            RuleResult result = DefaultSesV2EndpointProvider.endpointRule0(params, new LocalState(params.region()));
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(SesV2EndpointParams params, LocalState locals) {
        RuleResult result = DefaultSesV2EndpointProvider.endpointRule1(params, locals);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultSesV2EndpointProvider.endpointRule12(params, locals);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultSesV2EndpointProvider.endpointRule16(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultSesV2EndpointProvider.endpointRule31(params, locals);
    }

    private static RuleResult endpointRule1(SesV2EndpointParams params, LocalState locals) {
        if (params.endpointId() != null && locals.region() != null) {
            RulePartition partitionResult = null;
            partitionResult = RulesFunctions.awsPartition(locals.region());
            if (partitionResult != null) {
                RuleResult result = DefaultSesV2EndpointProvider.endpointRule2(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
                if (result.isResolved()) {
                    return result;
                }
                return DefaultSesV2EndpointProvider.endpointRule11(params, locals);
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(SesV2EndpointParams params, LocalState locals) {
        if (RulesFunctions.isValidHostLabel(params.endpointId(), true)) {
            RuleResult result = DefaultSesV2EndpointProvider.endpointRule3(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultSesV2EndpointProvider.endpointRule10(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(SesV2EndpointParams params, LocalState locals) {
        if (!params.useFips().booleanValue()) {
            RuleResult result = DefaultSesV2EndpointProvider.endpointRule4(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultSesV2EndpointProvider.endpointRule5(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultSesV2EndpointProvider.endpointRule9(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule4(SesV2EndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().signingName("ses").signingRegionSet(Arrays.asList("*")).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule5(SesV2EndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultSesV2EndpointProvider.endpointRule6(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultSesV2EndpointProvider.endpointRule8(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(SesV2EndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            return DefaultSesV2EndpointProvider.endpointRule7(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(SesV2EndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.endpointId() + ".endpoints.email.global." + locals.partitionResult().dualStackDnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().signingName("ses").signingRegionSet(Arrays.asList("*")).build())).build());
    }

    private static RuleResult endpointRule8(SesV2EndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
    }

    private static RuleResult endpointRule9(SesV2EndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.endpointId() + ".endpoints.email." + locals.partitionResult().dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().signingName("ses").signingRegionSet(Arrays.asList("*")).build())).build());
    }

    private static RuleResult endpointRule10(SesV2EndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: FIPS is not supported with multi-region endpoints");
    }

    private static RuleResult endpointRule11(SesV2EndpointParams params, LocalState locals) {
        return RuleResult.error("EndpointId must be a valid host label");
    }

    private static RuleResult endpointRule12(SesV2EndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleResult result = DefaultSesV2EndpointProvider.endpointRule13(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultSesV2EndpointProvider.endpointRule14(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultSesV2EndpointProvider.endpointRule15(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(SesV2EndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule14(SesV2EndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule15(SesV2EndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule16(SesV2EndpointParams params, LocalState locals) {
        if (locals.region() != null) {
            return DefaultSesV2EndpointProvider.endpointRule17(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(SesV2EndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            RuleResult result = DefaultSesV2EndpointProvider.endpointRule18(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
            if (result.isResolved()) {
                return result;
            }
            result = DefaultSesV2EndpointProvider.endpointRule22(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultSesV2EndpointProvider.endpointRule26(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultSesV2EndpointProvider.endpointRule30(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule18(SesV2EndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultSesV2EndpointProvider.endpointRule19(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultSesV2EndpointProvider.endpointRule21(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule19(SesV2EndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS() && locals.partitionResult().supportsDualStack()) {
            return DefaultSesV2EndpointProvider.endpointRule20(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(SesV2EndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://email-fips." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule21(SesV2EndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static RuleResult endpointRule22(SesV2EndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultSesV2EndpointProvider.endpointRule23(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultSesV2EndpointProvider.endpointRule25(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule23(SesV2EndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            return DefaultSesV2EndpointProvider.endpointRule24(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule24(SesV2EndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://email-fips." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule25(SesV2EndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
    }

    private static RuleResult endpointRule26(SesV2EndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultSesV2EndpointProvider.endpointRule27(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultSesV2EndpointProvider.endpointRule29(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule27(SesV2EndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            return DefaultSesV2EndpointProvider.endpointRule28(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule28(SesV2EndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://email." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule29(SesV2EndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
    }

    private static RuleResult endpointRule30(SesV2EndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://email." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule31(SesV2EndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static final class LocalStateBuilder {
        private String region;
        private RulePartition partitionResult;

        LocalStateBuilder() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalStateBuilder(LocalState locals) {
            this.region = locals.region;
            this.partitionResult = locals.partitionResult;
        }

        public LocalStateBuilder region(String value) {
            this.region = value;
            return this;
        }

        public LocalStateBuilder partitionResult(RulePartition value) {
            this.partitionResult = value;
            return this;
        }

        LocalState build() {
            return new LocalState(this);
        }
    }

    private static final class LocalState {
        private final String region;
        private final RulePartition partitionResult;

        LocalState() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalState(Region region) {
            this.region = region != null ? region.id() : null;
            this.partitionResult = null;
        }

        LocalState(LocalStateBuilder builder) {
            this.region = builder.region;
            this.partitionResult = builder.partitionResult;
        }

        public String region() {
            return this.region;
        }

        public RulePartition partitionResult() {
            return this.partitionResult;
        }

        public LocalStateBuilder toBuilder() {
            return new LocalStateBuilder(this);
        }
    }
}

