/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteTenantResourceAssociationRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, DeleteTenantResourceAssociationRequest> {
    private static final SdkField<String> TENANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TenantName").getter(DeleteTenantResourceAssociationRequest.getter(DeleteTenantResourceAssociationRequest::tenantName)).setter(DeleteTenantResourceAssociationRequest.setter(Builder::tenantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantName").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(DeleteTenantResourceAssociationRequest.getter(DeleteTenantResourceAssociationRequest::resourceArn)).setter(DeleteTenantResourceAssociationRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_NAME_FIELD, RESOURCE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteTenantResourceAssociationRequest.memberNameToFieldInitializer();
    private final String tenantName;
    private final String resourceArn;

    private DeleteTenantResourceAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.tenantName = builder.tenantName;
        this.resourceArn = builder.resourceArn;
    }

    public final String tenantName() {
        return this.tenantName;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTenantResourceAssociationRequest)) {
            return false;
        }
        DeleteTenantResourceAssociationRequest other = (DeleteTenantResourceAssociationRequest)((Object)obj);
        return Objects.equals(this.tenantName(), other.tenantName()) && Objects.equals(this.resourceArn(), other.resourceArn());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteTenantResourceAssociationRequest").add("TenantName", (Object)this.tenantName()).add("ResourceArn", (Object)this.resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TenantName": {
                return Optional.ofNullable(clazz.cast(this.tenantName()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TenantName", TENANT_NAME_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteTenantResourceAssociationRequest, T> g) {
        return obj -> g.apply((DeleteTenantResourceAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private String tenantName;
        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTenantResourceAssociationRequest model) {
            super(model);
            this.tenantName(model.tenantName);
            this.resourceArn(model.resourceArn);
        }

        public final String getTenantName() {
            return this.tenantName;
        }

        public final void setTenantName(String tenantName) {
            this.tenantName = tenantName;
        }

        @Override
        public final Builder tenantName(String tenantName) {
            this.tenantName = tenantName;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteTenantResourceAssociationRequest build() {
            return new DeleteTenantResourceAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteTenantResourceAssociationRequest> {
        public Builder tenantName(String var1);

        public Builder resourceArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

