/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2Client;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.ListResourceTenantsRequest;
import software.amazon.awssdk.services.sesv2.model.ListResourceTenantsResponse;
import software.amazon.awssdk.services.sesv2.model.ResourceTenantMetadata;

public class ListResourceTenantsIterable
implements SdkIterable<ListResourceTenantsResponse> {
    private final SesV2Client client;
    private final ListResourceTenantsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceTenantsIterable(SesV2Client client, ListResourceTenantsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourceTenantsResponseFetcher();
    }

    public Iterator<ListResourceTenantsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceTenantMetadata> resourceTenants() {
        Function<ListResourceTenantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceTenants() != null) {
                return response.resourceTenants().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceTenantsResponseFetcher
    implements SyncPageFetcher<ListResourceTenantsResponse> {
        private ListResourceTenantsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceTenantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceTenantsResponse nextPage(ListResourceTenantsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceTenantsIterable.this.client.listResourceTenants(ListResourceTenantsIterable.this.firstRequest);
            }
            return ListResourceTenantsIterable.this.client.listResourceTenants((ListResourceTenantsRequest)((Object)ListResourceTenantsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

