/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.sfn.model.CreateActivityRequest;
import software.amazon.awssdk.services.sfn.model.CreateActivityResponse;
import software.amazon.awssdk.services.sfn.model.CreateStateMachineAliasRequest;
import software.amazon.awssdk.services.sfn.model.CreateStateMachineAliasResponse;
import software.amazon.awssdk.services.sfn.model.CreateStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.CreateStateMachineResponse;
import software.amazon.awssdk.services.sfn.model.DeleteActivityRequest;
import software.amazon.awssdk.services.sfn.model.DeleteActivityResponse;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineAliasRequest;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineAliasResponse;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineResponse;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineVersionRequest;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineVersionResponse;
import software.amazon.awssdk.services.sfn.model.DescribeActivityRequest;
import software.amazon.awssdk.services.sfn.model.DescribeActivityResponse;
import software.amazon.awssdk.services.sfn.model.DescribeExecutionRequest;
import software.amazon.awssdk.services.sfn.model.DescribeExecutionResponse;
import software.amazon.awssdk.services.sfn.model.DescribeMapRunRequest;
import software.amazon.awssdk.services.sfn.model.DescribeMapRunResponse;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineAliasRequest;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineAliasResponse;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionRequest;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionResponse;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineResponse;
import software.amazon.awssdk.services.sfn.model.GetActivityTaskRequest;
import software.amazon.awssdk.services.sfn.model.GetActivityTaskResponse;
import software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest;
import software.amazon.awssdk.services.sfn.model.GetExecutionHistoryResponse;
import software.amazon.awssdk.services.sfn.model.ListActivitiesRequest;
import software.amazon.awssdk.services.sfn.model.ListActivitiesResponse;
import software.amazon.awssdk.services.sfn.model.ListExecutionsRequest;
import software.amazon.awssdk.services.sfn.model.ListExecutionsResponse;
import software.amazon.awssdk.services.sfn.model.ListMapRunsRequest;
import software.amazon.awssdk.services.sfn.model.ListMapRunsResponse;
import software.amazon.awssdk.services.sfn.model.ListStateMachineAliasesRequest;
import software.amazon.awssdk.services.sfn.model.ListStateMachineAliasesResponse;
import software.amazon.awssdk.services.sfn.model.ListStateMachineVersionsRequest;
import software.amazon.awssdk.services.sfn.model.ListStateMachineVersionsResponse;
import software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest;
import software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse;
import software.amazon.awssdk.services.sfn.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.sfn.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.sfn.model.PublishStateMachineVersionRequest;
import software.amazon.awssdk.services.sfn.model.PublishStateMachineVersionResponse;
import software.amazon.awssdk.services.sfn.model.RedriveExecutionRequest;
import software.amazon.awssdk.services.sfn.model.RedriveExecutionResponse;
import software.amazon.awssdk.services.sfn.model.SendTaskFailureRequest;
import software.amazon.awssdk.services.sfn.model.SendTaskFailureResponse;
import software.amazon.awssdk.services.sfn.model.SendTaskHeartbeatRequest;
import software.amazon.awssdk.services.sfn.model.SendTaskHeartbeatResponse;
import software.amazon.awssdk.services.sfn.model.SendTaskSuccessRequest;
import software.amazon.awssdk.services.sfn.model.SendTaskSuccessResponse;
import software.amazon.awssdk.services.sfn.model.StartExecutionRequest;
import software.amazon.awssdk.services.sfn.model.StartExecutionResponse;
import software.amazon.awssdk.services.sfn.model.StartSyncExecutionRequest;
import software.amazon.awssdk.services.sfn.model.StartSyncExecutionResponse;
import software.amazon.awssdk.services.sfn.model.StopExecutionRequest;
import software.amazon.awssdk.services.sfn.model.StopExecutionResponse;
import software.amazon.awssdk.services.sfn.model.TagResourceRequest;
import software.amazon.awssdk.services.sfn.model.TagResourceResponse;
import software.amazon.awssdk.services.sfn.model.TestStateRequest;
import software.amazon.awssdk.services.sfn.model.TestStateResponse;
import software.amazon.awssdk.services.sfn.model.UntagResourceRequest;
import software.amazon.awssdk.services.sfn.model.UntagResourceResponse;
import software.amazon.awssdk.services.sfn.model.UpdateMapRunRequest;
import software.amazon.awssdk.services.sfn.model.UpdateMapRunResponse;
import software.amazon.awssdk.services.sfn.model.UpdateStateMachineAliasRequest;
import software.amazon.awssdk.services.sfn.model.UpdateStateMachineAliasResponse;
import software.amazon.awssdk.services.sfn.model.UpdateStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.UpdateStateMachineResponse;
import software.amazon.awssdk.services.sfn.paginators.GetExecutionHistoryPublisher;
import software.amazon.awssdk.services.sfn.paginators.ListActivitiesPublisher;
import software.amazon.awssdk.services.sfn.paginators.ListExecutionsPublisher;
import software.amazon.awssdk.services.sfn.paginators.ListMapRunsPublisher;
import software.amazon.awssdk.services.sfn.paginators.ListStateMachinesPublisher;

/**
 * Service client for accessing AWS SFN asynchronously. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Step Functions</fullname>
 * <p>
 * Step Functions is a service that lets you coordinate the components of distributed applications and microservices
 * using visual workflows.
 * </p>
 * <p>
 * You can use Step Functions to build applications from individual components, each of which performs a discrete
 * function, or <i>task</i>, allowing you to scale and change applications quickly. Step Functions provides a console
 * that helps visualize the components of your application as a series of steps. Step Functions automatically triggers
 * and tracks each step, and retries steps when there are errors, so your application executes predictably and in the
 * right order every time. Step Functions logs the state of each step, so you can quickly diagnose and debug any issues.
 * </p>
 * <p>
 * Step Functions manages operations and underlying infrastructure to ensure your application is available at any scale.
 * You can run tasks on Amazon Web Services, your own servers, or any system that has access to Amazon Web Services. You
 * can access and use Step Functions using the console, the Amazon Web Services SDKs, or an HTTP API. For more
 * information about Step Functions, see the <i> <a
 * href="https://docs.aws.amazon.com/step-functions/latest/dg/welcome.html">Step Functions Developer Guide</a> </i>.
 * </p>
 * <important>
 * <p>
 * If you use the Step Functions API actions using Amazon Web Services SDK integrations, make sure the API actions are
 * in camel case and parameter names are in Pascal case. For example, you could use Step Functions API action
 * <code>startSyncExecution</code> and specify its parameter as <code>StateMachineArn</code>.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SfnAsyncClient extends AwsClient {
    String SERVICE_NAME = "states";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "states";

    /**
     * <p>
     * Creates an activity. An activity is a task that you write in any programming language and host on any machine
     * that has access to Step Functions. Activities must poll Step Functions using the <code>GetActivityTask</code> API
     * action and respond using <code>SendTask*</code> API actions. This function lets Step Functions know the existence
     * of your activity and returns an identifier for use in a state machine and when polling from the activity.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note> <note>
     * <p>
     * <code>CreateActivity</code> is an idempotent API. Subsequent requests won’t create a duplicate resource if it was
     * already created. <code>CreateActivity</code>'s idempotency check is based on the activity <code>name</code>. If a
     * following request has different <code>tags</code> values, Step Functions will ignore these differences and treat
     * it as an idempotent request of the previous. In this case, <code>tags</code> will not be updated, even if they
     * are different.
     * </p>
     * </note>
     *
     * @param createActivityRequest
     * @return A Java Future containing the result of the CreateActivity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ActivityLimitExceededException The maximum number of activities has been reached. Existing activities
     *         must be deleted before a new activity can be created.</li>
     *         <li>InvalidNameException The provided name is not valid.</li>
     *         <li>TooManyTagsException You've exceeded the number of tags allowed for a resource. See the <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html"> Limits Topic</a> in the Step
     *         Functions Developer Guide.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.CreateActivity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateActivity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateActivityResponse> createActivity(CreateActivityRequest createActivityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an activity. An activity is a task that you write in any programming language and host on any machine
     * that has access to Step Functions. Activities must poll Step Functions using the <code>GetActivityTask</code> API
     * action and respond using <code>SendTask*</code> API actions. This function lets Step Functions know the existence
     * of your activity and returns an identifier for use in a state machine and when polling from the activity.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note> <note>
     * <p>
     * <code>CreateActivity</code> is an idempotent API. Subsequent requests won’t create a duplicate resource if it was
     * already created. <code>CreateActivity</code>'s idempotency check is based on the activity <code>name</code>. If a
     * following request has different <code>tags</code> values, Step Functions will ignore these differences and treat
     * it as an idempotent request of the previous. In this case, <code>tags</code> will not be updated, even if they
     * are different.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateActivityRequest.Builder} avoiding the need to
     * create one manually via {@link CreateActivityRequest#builder()}
     * </p>
     *
     * @param createActivityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.CreateActivityRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateActivity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ActivityLimitExceededException The maximum number of activities has been reached. Existing activities
     *         must be deleted before a new activity can be created.</li>
     *         <li>InvalidNameException The provided name is not valid.</li>
     *         <li>TooManyTagsException You've exceeded the number of tags allowed for a resource. See the <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html"> Limits Topic</a> in the Step
     *         Functions Developer Guide.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.CreateActivity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateActivity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateActivityResponse> createActivity(Consumer<CreateActivityRequest.Builder> createActivityRequest) {
        return createActivity(CreateActivityRequest.builder().applyMutation(createActivityRequest).build());
    }

    /**
     * <p>
     * Creates a state machine. A state machine consists of a collection of states that can do work (<code>Task</code>
     * states), determine to which states to transition next (<code>Choice</code> states), stop an execution with an
     * error (<code>Fail</code> states), and so on. State machines are specified using a JSON-based, structured
     * language. For more information, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States
     * Language</a> in the Step Functions User Guide.
     * </p>
     * <p>
     * If you set the <code>publish</code> parameter of this API action to <code>true</code>, it publishes version
     * <code>1</code> as the first revision of the state machine.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note> <note>
     * <p>
     * <code>CreateStateMachine</code> is an idempotent API. Subsequent requests won’t create a duplicate resource if it
     * was already created. <code>CreateStateMachine</code>'s idempotency check is based on the state machine
     * <code>name</code>, <code>definition</code>, <code>type</code>, <code>LoggingConfiguration</code>, and
     * <code>TracingConfiguration</code>. The check is also based on the <code>publish</code> and
     * <code>versionDescription</code> parameters. If a following request has a different <code>roleArn</code> or
     * <code>tags</code>, Step Functions will ignore these differences and treat it as an idempotent request of the
     * previous. In this case, <code>roleArn</code> and <code>tags</code> will not be updated, even if they are
     * different.
     * </p>
     * </note>
     *
     * @param createStateMachineRequest
     * @return A Java Future containing the result of the CreateStateMachine operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidDefinitionException The provided Amazon States Language definition is not valid.</li>
     *         <li>InvalidNameException The provided name is not valid.</li>
     *         <li>InvalidLoggingConfigurationException</li>
     *         <li>InvalidTracingConfigurationException Your <code>tracingConfiguration</code> key does not match, or
     *         <code>enabled</code> has not been set to <code>true</code> or <code>false</code>.</li>
     *         <li>StateMachineAlreadyExistsException A state machine with the same name but a different definition or
     *         role ARN already exists.</li>
     *         <li>StateMachineDeletingException The specified state machine is being deleted.</li>
     *         <li>StateMachineLimitExceededException The maximum number of state machines has been reached. Existing
     *         state machines must be deleted before a new state machine can be created.</li>
     *         <li>StateMachineTypeNotSupportedException</li>
     *         <li>TooManyTagsException You've exceeded the number of tags allowed for a resource. See the <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html"> Limits Topic</a> in the Step
     *         Functions Developer Guide.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state. This error occurs
     *         when there're concurrent requests for <a>DeleteStateMachineVersion</a>,
     *         <a>PublishStateMachineVersion</a>, or <a>UpdateStateMachine</a> with the <code>publish</code> parameter
     *         set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.CreateStateMachine
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateStateMachine" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateStateMachineResponse> createStateMachine(CreateStateMachineRequest createStateMachineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a state machine. A state machine consists of a collection of states that can do work (<code>Task</code>
     * states), determine to which states to transition next (<code>Choice</code> states), stop an execution with an
     * error (<code>Fail</code> states), and so on. State machines are specified using a JSON-based, structured
     * language. For more information, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States
     * Language</a> in the Step Functions User Guide.
     * </p>
     * <p>
     * If you set the <code>publish</code> parameter of this API action to <code>true</code>, it publishes version
     * <code>1</code> as the first revision of the state machine.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note> <note>
     * <p>
     * <code>CreateStateMachine</code> is an idempotent API. Subsequent requests won’t create a duplicate resource if it
     * was already created. <code>CreateStateMachine</code>'s idempotency check is based on the state machine
     * <code>name</code>, <code>definition</code>, <code>type</code>, <code>LoggingConfiguration</code>, and
     * <code>TracingConfiguration</code>. The check is also based on the <code>publish</code> and
     * <code>versionDescription</code> parameters. If a following request has a different <code>roleArn</code> or
     * <code>tags</code>, Step Functions will ignore these differences and treat it as an idempotent request of the
     * previous. In this case, <code>roleArn</code> and <code>tags</code> will not be updated, even if they are
     * different.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStateMachineRequest.Builder} avoiding the
     * need to create one manually via {@link CreateStateMachineRequest#builder()}
     * </p>
     *
     * @param createStateMachineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.CreateStateMachineRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateStateMachine operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidDefinitionException The provided Amazon States Language definition is not valid.</li>
     *         <li>InvalidNameException The provided name is not valid.</li>
     *         <li>InvalidLoggingConfigurationException</li>
     *         <li>InvalidTracingConfigurationException Your <code>tracingConfiguration</code> key does not match, or
     *         <code>enabled</code> has not been set to <code>true</code> or <code>false</code>.</li>
     *         <li>StateMachineAlreadyExistsException A state machine with the same name but a different definition or
     *         role ARN already exists.</li>
     *         <li>StateMachineDeletingException The specified state machine is being deleted.</li>
     *         <li>StateMachineLimitExceededException The maximum number of state machines has been reached. Existing
     *         state machines must be deleted before a new state machine can be created.</li>
     *         <li>StateMachineTypeNotSupportedException</li>
     *         <li>TooManyTagsException You've exceeded the number of tags allowed for a resource. See the <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html"> Limits Topic</a> in the Step
     *         Functions Developer Guide.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state. This error occurs
     *         when there're concurrent requests for <a>DeleteStateMachineVersion</a>,
     *         <a>PublishStateMachineVersion</a>, or <a>UpdateStateMachine</a> with the <code>publish</code> parameter
     *         set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.CreateStateMachine
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateStateMachine" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateStateMachineResponse> createStateMachine(
            Consumer<CreateStateMachineRequest.Builder> createStateMachineRequest) {
        return createStateMachine(CreateStateMachineRequest.builder().applyMutation(createStateMachineRequest).build());
    }

    /**
     * <p>
     * Creates an <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> for a
     * state machine that points to one or two <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">versions</a> of
     * the same state machine. You can set your application to call <a>StartExecution</a> with an alias and update the
     * version the alias uses without changing the client's code.
     * </p>
     * <p>
     * You can also map an alias to split <a>StartExecution</a> requests between two versions of a state machine. To do
     * this, add a second <code>RoutingConfig</code> object in the <code>routingConfiguration</code> parameter. You must
     * also specify the percentage of execution run requests each version should receive in both
     * <code>RoutingConfig</code> objects. Step Functions randomly chooses which version runs a given execution based on
     * the percentage you specify.
     * </p>
     * <p>
     * To create an alias that points to a single version, specify a single <code>RoutingConfig</code> object with a
     * <code>weight</code> set to 100.
     * </p>
     * <p>
     * You can create up to 100 aliases for each state machine. You must delete unused aliases using the
     * <a>DeleteStateMachineAlias</a> API action.
     * </p>
     * <p>
     * <code>CreateStateMachineAlias</code> is an idempotent API. Step Functions bases the idempotency check on the
     * <code>stateMachineArn</code>, <code>description</code>, <code>name</code>, and <code>routingConfiguration</code>
     * parameters. Requests that contain the same values for these parameters return a successful idempotent response
     * without creating a duplicate resource.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DescribeStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineAliases</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>UpdateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteStateMachineAlias</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createStateMachineAliasRequest
     * @return A Java Future containing the result of the CreateStateMachineAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNameException The provided name is not valid.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>StateMachineDeletingException The specified state machine is being deleted.</li>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state. This error occurs
     *         when there're concurrent requests for <a>DeleteStateMachineVersion</a>,
     *         <a>PublishStateMachineVersion</a>, or <a>UpdateStateMachine</a> with the <code>publish</code> parameter
     *         set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</p>
     *         <p>
     *         HTTP Status Code: 402</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.CreateStateMachineAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateStateMachineAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStateMachineAliasResponse> createStateMachineAlias(
            CreateStateMachineAliasRequest createStateMachineAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> for a
     * state machine that points to one or two <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">versions</a> of
     * the same state machine. You can set your application to call <a>StartExecution</a> with an alias and update the
     * version the alias uses without changing the client's code.
     * </p>
     * <p>
     * You can also map an alias to split <a>StartExecution</a> requests between two versions of a state machine. To do
     * this, add a second <code>RoutingConfig</code> object in the <code>routingConfiguration</code> parameter. You must
     * also specify the percentage of execution run requests each version should receive in both
     * <code>RoutingConfig</code> objects. Step Functions randomly chooses which version runs a given execution based on
     * the percentage you specify.
     * </p>
     * <p>
     * To create an alias that points to a single version, specify a single <code>RoutingConfig</code> object with a
     * <code>weight</code> set to 100.
     * </p>
     * <p>
     * You can create up to 100 aliases for each state machine. You must delete unused aliases using the
     * <a>DeleteStateMachineAlias</a> API action.
     * </p>
     * <p>
     * <code>CreateStateMachineAlias</code> is an idempotent API. Step Functions bases the idempotency check on the
     * <code>stateMachineArn</code>, <code>description</code>, <code>name</code>, and <code>routingConfiguration</code>
     * parameters. Requests that contain the same values for these parameters return a successful idempotent response
     * without creating a duplicate resource.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DescribeStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineAliases</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>UpdateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteStateMachineAlias</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStateMachineAliasRequest.Builder} avoiding
     * the need to create one manually via {@link CreateStateMachineAliasRequest#builder()}
     * </p>
     *
     * @param createStateMachineAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.CreateStateMachineAliasRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateStateMachineAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNameException The provided name is not valid.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>StateMachineDeletingException The specified state machine is being deleted.</li>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state. This error occurs
     *         when there're concurrent requests for <a>DeleteStateMachineVersion</a>,
     *         <a>PublishStateMachineVersion</a>, or <a>UpdateStateMachine</a> with the <code>publish</code> parameter
     *         set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</p>
     *         <p>
     *         HTTP Status Code: 402</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.CreateStateMachineAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateStateMachineAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStateMachineAliasResponse> createStateMachineAlias(
            Consumer<CreateStateMachineAliasRequest.Builder> createStateMachineAliasRequest) {
        return createStateMachineAlias(CreateStateMachineAliasRequest.builder().applyMutation(createStateMachineAliasRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an activity.
     * </p>
     *
     * @param deleteActivityRequest
     * @return A Java Future containing the result of the DeleteActivity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.DeleteActivity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteActivity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteActivityResponse> deleteActivity(DeleteActivityRequest deleteActivityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an activity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteActivityRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteActivityRequest#builder()}
     * </p>
     *
     * @param deleteActivityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.DeleteActivityRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteActivity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.DeleteActivity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteActivity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteActivityResponse> deleteActivity(Consumer<DeleteActivityRequest.Builder> deleteActivityRequest) {
        return deleteActivity(DeleteActivityRequest.builder().applyMutation(deleteActivityRequest).build());
    }

    /**
     * <p>
     * Deletes a state machine. This is an asynchronous operation. It sets the state machine's status to
     * <code>DELETING</code> and begins the deletion process. A state machine is deleted only when all its executions
     * are completed. On the next state transition, the state machine's executions are terminated.
     * </p>
     * <p>
     * A qualified state machine ARN can either refer to a <i>Distributed Map state</i> defined within a state machine,
     * a version ARN, or an alias ARN.
     * </p>
     * <p>
     * The following are some examples of qualified and unqualified state machine ARNs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to a <i>Distributed Map state</i> with a label
     * <code>mapStateLabel</code> in a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a <i>Distributed Map state</i>, the request fails
     * with <code>ValidationException</code>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following unqualified state machine ARN refers to a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:partition:states:region:account-id:stateMachine:myStateMachine</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This API action also deletes all <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">versions</a> and
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">aliases</a>
     * associated with a state machine.
     * </p>
     * <note>
     * <p>
     * For <code>EXPRESS</code> state machines, the deletion happens eventually (usually in less than a minute). Running
     * executions may emit logs after <code>DeleteStateMachine</code> API is called.
     * </p>
     * </note>
     *
     * @param deleteStateMachineRequest
     * @return A Java Future containing the result of the DeleteStateMachine operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.DeleteStateMachine
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteStateMachine" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteStateMachineResponse> deleteStateMachine(DeleteStateMachineRequest deleteStateMachineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a state machine. This is an asynchronous operation. It sets the state machine's status to
     * <code>DELETING</code> and begins the deletion process. A state machine is deleted only when all its executions
     * are completed. On the next state transition, the state machine's executions are terminated.
     * </p>
     * <p>
     * A qualified state machine ARN can either refer to a <i>Distributed Map state</i> defined within a state machine,
     * a version ARN, or an alias ARN.
     * </p>
     * <p>
     * The following are some examples of qualified and unqualified state machine ARNs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to a <i>Distributed Map state</i> with a label
     * <code>mapStateLabel</code> in a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a <i>Distributed Map state</i>, the request fails
     * with <code>ValidationException</code>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following unqualified state machine ARN refers to a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:partition:states:region:account-id:stateMachine:myStateMachine</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This API action also deletes all <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">versions</a> and
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">aliases</a>
     * associated with a state machine.
     * </p>
     * <note>
     * <p>
     * For <code>EXPRESS</code> state machines, the deletion happens eventually (usually in less than a minute). Running
     * executions may emit logs after <code>DeleteStateMachine</code> API is called.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStateMachineRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteStateMachineRequest#builder()}
     * </p>
     *
     * @param deleteStateMachineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.DeleteStateMachineRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteStateMachine operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.DeleteStateMachine
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteStateMachine" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteStateMachineResponse> deleteStateMachine(
            Consumer<DeleteStateMachineRequest.Builder> deleteStateMachineRequest) {
        return deleteStateMachine(DeleteStateMachineRequest.builder().applyMutation(deleteStateMachineRequest).build());
    }

    /**
     * <p>
     * Deletes a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a>.
     * </p>
     * <p>
     * After you delete a state machine alias, you can't use it to start executions. When you delete a state machine
     * alias, Step Functions doesn't delete the state machine versions that alias references.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>CreateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DescribeStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineAliases</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>UpdateStateMachineAlias</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteStateMachineAliasRequest
     * @return A Java Future containing the result of the DeleteStateMachineAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state. This error occurs
     *         when there're concurrent requests for <a>DeleteStateMachineVersion</a>,
     *         <a>PublishStateMachineVersion</a>, or <a>UpdateStateMachine</a> with the <code>publish</code> parameter
     *         set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.DeleteStateMachineAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteStateMachineAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteStateMachineAliasResponse> deleteStateMachineAlias(
            DeleteStateMachineAliasRequest deleteStateMachineAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a>.
     * </p>
     * <p>
     * After you delete a state machine alias, you can't use it to start executions. When you delete a state machine
     * alias, Step Functions doesn't delete the state machine versions that alias references.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>CreateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DescribeStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineAliases</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>UpdateStateMachineAlias</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStateMachineAliasRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteStateMachineAliasRequest#builder()}
     * </p>
     *
     * @param deleteStateMachineAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.DeleteStateMachineAliasRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteStateMachineAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state. This error occurs
     *         when there're concurrent requests for <a>DeleteStateMachineVersion</a>,
     *         <a>PublishStateMachineVersion</a>, or <a>UpdateStateMachine</a> with the <code>publish</code> parameter
     *         set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.DeleteStateMachineAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteStateMachineAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteStateMachineAliasResponse> deleteStateMachineAlias(
            Consumer<DeleteStateMachineAliasRequest.Builder> deleteStateMachineAliasRequest) {
        return deleteStateMachineAlias(DeleteStateMachineAliasRequest.builder().applyMutation(deleteStateMachineAliasRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>.
     * After you delete a version, you can't call <a>StartExecution</a> using that version's ARN or use the version with
     * a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a>.
     * </p>
     * <note>
     * <p>
     * Deleting a state machine version won't terminate its in-progress executions.
     * </p>
     * </note> <note>
     * <p>
     * You can't delete a state machine version currently referenced by one or more aliases. Before you delete a
     * version, you must either delete the aliases or update them to point to another state machine version.
     * </p>
     * </note>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>PublishStateMachineVersion</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineVersions</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteStateMachineVersionRequest
     * @return A Java Future containing the result of the DeleteStateMachineVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state. This error occurs
     *         when there're concurrent requests for <a>DeleteStateMachineVersion</a>,
     *         <a>PublishStateMachineVersion</a>, or <a>UpdateStateMachine</a> with the <code>publish</code> parameter
     *         set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.DeleteStateMachineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteStateMachineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteStateMachineVersionResponse> deleteStateMachineVersion(
            DeleteStateMachineVersionRequest deleteStateMachineVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>.
     * After you delete a version, you can't call <a>StartExecution</a> using that version's ARN or use the version with
     * a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a>.
     * </p>
     * <note>
     * <p>
     * Deleting a state machine version won't terminate its in-progress executions.
     * </p>
     * </note> <note>
     * <p>
     * You can't delete a state machine version currently referenced by one or more aliases. Before you delete a
     * version, you must either delete the aliases or update them to point to another state machine version.
     * </p>
     * </note>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>PublishStateMachineVersion</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineVersions</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStateMachineVersionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteStateMachineVersionRequest#builder()}
     * </p>
     *
     * @param deleteStateMachineVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.DeleteStateMachineVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteStateMachineVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state. This error occurs
     *         when there're concurrent requests for <a>DeleteStateMachineVersion</a>,
     *         <a>PublishStateMachineVersion</a>, or <a>UpdateStateMachine</a> with the <code>publish</code> parameter
     *         set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.DeleteStateMachineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteStateMachineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteStateMachineVersionResponse> deleteStateMachineVersion(
            Consumer<DeleteStateMachineVersionRequest.Builder> deleteStateMachineVersionRequest) {
        return deleteStateMachineVersion(DeleteStateMachineVersionRequest.builder()
                .applyMutation(deleteStateMachineVersionRequest).build());
    }

    /**
     * <p>
     * Describes an activity.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     *
     * @param describeActivityRequest
     * @return A Java Future containing the result of the DescribeActivity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ActivityDoesNotExistException The specified activity does not exist.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.DescribeActivity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeActivity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeActivityResponse> describeActivity(DescribeActivityRequest describeActivityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an activity.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActivityRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeActivityRequest#builder()}
     * </p>
     *
     * @param describeActivityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.DescribeActivityRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeActivity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ActivityDoesNotExistException The specified activity does not exist.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.DescribeActivity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeActivity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeActivityResponse> describeActivity(
            Consumer<DescribeActivityRequest.Builder> describeActivityRequest) {
        return describeActivity(DescribeActivityRequest.builder().applyMutation(describeActivityRequest).build());
    }

    /**
     * <p>
     * Provides information about a state machine execution, such as the state machine associated with the execution,
     * the execution input and output, and relevant execution metadata. If you've <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html">redriven</a> an execution,
     * you can use this API action to return information about the redrives of that execution. In addition, you can use
     * this API action to return the Map Run Amazon Resource Name (ARN) if the execution was dispatched by a Map Run.
     * </p>
     * <p>
     * If you specify a version or alias ARN when you call the <a>StartExecution</a> API action,
     * <code>DescribeExecution</code> returns that ARN.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     * <p>
     * Executions of an <code>EXPRESS</code> state machine aren't supported by <code>DescribeExecution</code> unless a
     * Map Run dispatched them.
     * </p>
     *
     * @param describeExecutionRequest
     * @return A Java Future containing the result of the DescribeExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ExecutionDoesNotExistException The specified execution does not exist.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.DescribeExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeExecutionResponse> describeExecution(DescribeExecutionRequest describeExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a state machine execution, such as the state machine associated with the execution,
     * the execution input and output, and relevant execution metadata. If you've <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html">redriven</a> an execution,
     * you can use this API action to return information about the redrives of that execution. In addition, you can use
     * this API action to return the Map Run Amazon Resource Name (ARN) if the execution was dispatched by a Map Run.
     * </p>
     * <p>
     * If you specify a version or alias ARN when you call the <a>StartExecution</a> API action,
     * <code>DescribeExecution</code> returns that ARN.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     * <p>
     * Executions of an <code>EXPRESS</code> state machine aren't supported by <code>DescribeExecution</code> unless a
     * Map Run dispatched them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExecutionRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeExecutionRequest#builder()}
     * </p>
     *
     * @param describeExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.DescribeExecutionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ExecutionDoesNotExistException The specified execution does not exist.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.DescribeExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeExecutionResponse> describeExecution(
            Consumer<DescribeExecutionRequest.Builder> describeExecutionRequest) {
        return describeExecution(DescribeExecutionRequest.builder().applyMutation(describeExecutionRequest).build());
    }

    /**
     * <p>
     * Provides information about a Map Run's configuration, progress, and results. If you've <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html">redriven</a> a Map Run, this API
     * action also returns information about the redrives of that Map Run. For more information, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html">Examining Map Run</a>
     * in the <i>Step Functions Developer Guide</i>.
     * </p>
     *
     * @param describeMapRunRequest
     * @return A Java Future containing the result of the DescribeMapRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.DescribeMapRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeMapRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeMapRunResponse> describeMapRun(DescribeMapRunRequest describeMapRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a Map Run's configuration, progress, and results. If you've <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html">redriven</a> a Map Run, this API
     * action also returns information about the redrives of that Map Run. For more information, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html">Examining Map Run</a>
     * in the <i>Step Functions Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMapRunRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeMapRunRequest#builder()}
     * </p>
     *
     * @param describeMapRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.DescribeMapRunRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeMapRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.DescribeMapRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeMapRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeMapRunResponse> describeMapRun(Consumer<DescribeMapRunRequest.Builder> describeMapRunRequest) {
        return describeMapRun(DescribeMapRunRequest.builder().applyMutation(describeMapRunRequest).build());
    }

    /**
     * <p>
     * Provides information about a state machine's definition, its IAM role Amazon Resource Name (ARN), and
     * configuration.
     * </p>
     * <p>
     * A qualified state machine ARN can either refer to a <i>Distributed Map state</i> defined within a state machine,
     * a version ARN, or an alias ARN.
     * </p>
     * <p>
     * The following are some examples of qualified and unqualified state machine ARNs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to a <i>Distributed Map state</i> with a label
     * <code>mapStateLabel</code> in a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a <i>Distributed Map state</i>, the request fails
     * with <code>ValidationException</code>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to an alias named <code>PROD</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine:PROD&gt;</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a version ARN or an alias ARN, the request starts
     * execution for that version or alias.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following unqualified state machine ARN refers to a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This API action returns the details for a state machine version if the <code>stateMachineArn</code> you specify
     * is a state machine version ARN.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     *
     * @param describeStateMachineRequest
     * @return A Java Future containing the result of the DescribeStateMachine operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>StateMachineDoesNotExistException The specified state machine does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.DescribeStateMachine
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachine" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeStateMachineResponse> describeStateMachine(
            DescribeStateMachineRequest describeStateMachineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a state machine's definition, its IAM role Amazon Resource Name (ARN), and
     * configuration.
     * </p>
     * <p>
     * A qualified state machine ARN can either refer to a <i>Distributed Map state</i> defined within a state machine,
     * a version ARN, or an alias ARN.
     * </p>
     * <p>
     * The following are some examples of qualified and unqualified state machine ARNs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to a <i>Distributed Map state</i> with a label
     * <code>mapStateLabel</code> in a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a <i>Distributed Map state</i>, the request fails
     * with <code>ValidationException</code>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to an alias named <code>PROD</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine:PROD&gt;</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a version ARN or an alias ARN, the request starts
     * execution for that version or alias.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following unqualified state machine ARN refers to a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This API action returns the details for a state machine version if the <code>stateMachineArn</code> you specify
     * is a state machine version ARN.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStateMachineRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStateMachineRequest#builder()}
     * </p>
     *
     * @param describeStateMachineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.DescribeStateMachineRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeStateMachine operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>StateMachineDoesNotExistException The specified state machine does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.DescribeStateMachine
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachine" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeStateMachineResponse> describeStateMachine(
            Consumer<DescribeStateMachineRequest.Builder> describeStateMachineRequest) {
        return describeStateMachine(DescribeStateMachineRequest.builder().applyMutation(describeStateMachineRequest).build());
    }

    /**
     * <p>
     * Returns details about a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a>.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>CreateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineAliases</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>UpdateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteStateMachineAlias</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeStateMachineAliasRequest
     * @return A Java Future containing the result of the DescribeStateMachineAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.DescribeStateMachineAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachineAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStateMachineAliasResponse> describeStateMachineAlias(
            DescribeStateMachineAliasRequest describeStateMachineAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a>.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>CreateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineAliases</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>UpdateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteStateMachineAlias</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStateMachineAliasRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeStateMachineAliasRequest#builder()}
     * </p>
     *
     * @param describeStateMachineAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.DescribeStateMachineAliasRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeStateMachineAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.DescribeStateMachineAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachineAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStateMachineAliasResponse> describeStateMachineAlias(
            Consumer<DescribeStateMachineAliasRequest.Builder> describeStateMachineAliasRequest) {
        return describeStateMachineAlias(DescribeStateMachineAliasRequest.builder()
                .applyMutation(describeStateMachineAliasRequest).build());
    }

    /**
     * <p>
     * Provides information about a state machine's definition, its execution role ARN, and configuration. If a Map Run
     * dispatched the execution, this action returns the Map Run Amazon Resource Name (ARN) in the response. The state
     * machine returned is the state machine associated with the Map Run.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     * <p>
     * This API action is not supported by <code>EXPRESS</code> state machines.
     * </p>
     *
     * @param describeStateMachineForExecutionRequest
     * @return A Java Future containing the result of the DescribeStateMachineForExecution operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ExecutionDoesNotExistException The specified execution does not exist.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.DescribeStateMachineForExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachineForExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStateMachineForExecutionResponse> describeStateMachineForExecution(
            DescribeStateMachineForExecutionRequest describeStateMachineForExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a state machine's definition, its execution role ARN, and configuration. If a Map Run
     * dispatched the execution, this action returns the Map Run Amazon Resource Name (ARN) in the response. The state
     * machine returned is the state machine associated with the Map Run.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     * <p>
     * This API action is not supported by <code>EXPRESS</code> state machines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStateMachineForExecutionRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeStateMachineForExecutionRequest#builder()}
     * </p>
     *
     * @param describeStateMachineForExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeStateMachineForExecution operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ExecutionDoesNotExistException The specified execution does not exist.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.DescribeStateMachineForExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachineForExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStateMachineForExecutionResponse> describeStateMachineForExecution(
            Consumer<DescribeStateMachineForExecutionRequest.Builder> describeStateMachineForExecutionRequest) {
        return describeStateMachineForExecution(DescribeStateMachineForExecutionRequest.builder()
                .applyMutation(describeStateMachineForExecutionRequest).build());
    }

    /**
     * <p>
     * Used by workers to retrieve a task (with the specified activity ARN) which has been scheduled for execution by a
     * running state machine. This initiates a long poll, where the service holds the HTTP connection open and responds
     * as soon as a task becomes available (i.e. an execution of a task of this type is needed.) The maximum time the
     * service holds on to the request before responding is 60 seconds. If no task is available within 60 seconds, the
     * poll returns a <code>taskToken</code> with a null string.
     * </p>
     * <note>
     * <p>
     * This API action isn't logged in CloudTrail.
     * </p>
     * </note> <important>
     * <p>
     * Workers should set their client side socket timeout to at least 65 seconds (5 seconds higher than the maximum
     * time the service may hold the poll request).
     * </p>
     * <p>
     * Polling with <code>GetActivityTask</code> can cause latency in some implementations. See <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/bp-activity-pollers.html">Avoid Latency When Polling
     * for Activity Tasks</a> in the Step Functions Developer Guide.
     * </p>
     * </important>
     *
     * @param getActivityTaskRequest
     * @return A Java Future containing the result of the GetActivityTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ActivityDoesNotExistException The specified activity does not exist.</li>
     *         <li>ActivityWorkerLimitExceededException The maximum number of workers concurrently polling for activity
     *         tasks has been reached.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.GetActivityTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetActivityTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetActivityTaskResponse> getActivityTask(GetActivityTaskRequest getActivityTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by workers to retrieve a task (with the specified activity ARN) which has been scheduled for execution by a
     * running state machine. This initiates a long poll, where the service holds the HTTP connection open and responds
     * as soon as a task becomes available (i.e. an execution of a task of this type is needed.) The maximum time the
     * service holds on to the request before responding is 60 seconds. If no task is available within 60 seconds, the
     * poll returns a <code>taskToken</code> with a null string.
     * </p>
     * <note>
     * <p>
     * This API action isn't logged in CloudTrail.
     * </p>
     * </note> <important>
     * <p>
     * Workers should set their client side socket timeout to at least 65 seconds (5 seconds higher than the maximum
     * time the service may hold the poll request).
     * </p>
     * <p>
     * Polling with <code>GetActivityTask</code> can cause latency in some implementations. See <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/bp-activity-pollers.html">Avoid Latency When Polling
     * for Activity Tasks</a> in the Step Functions Developer Guide.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetActivityTaskRequest.Builder} avoiding the need
     * to create one manually via {@link GetActivityTaskRequest#builder()}
     * </p>
     *
     * @param getActivityTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.GetActivityTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetActivityTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ActivityDoesNotExistException The specified activity does not exist.</li>
     *         <li>ActivityWorkerLimitExceededException The maximum number of workers concurrently polling for activity
     *         tasks has been reached.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.GetActivityTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetActivityTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetActivityTaskResponse> getActivityTask(
            Consumer<GetActivityTaskRequest.Builder> getActivityTaskRequest) {
        return getActivityTask(GetActivityTaskRequest.builder().applyMutation(getActivityTaskRequest).build());
    }

    /**
     * <p>
     * Returns the history of the specified execution as a list of events. By default, the results are returned in
     * ascending order of the <code>timeStamp</code> of the events. Use the <code>reverseOrder</code> parameter to get
     * the latest events first.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <p>
     * This API action is not supported by <code>EXPRESS</code> state machines.
     * </p>
     *
     * @param getExecutionHistoryRequest
     * @return A Java Future containing the result of the GetExecutionHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ExecutionDoesNotExistException The specified execution does not exist.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.GetExecutionHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetExecutionHistory" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetExecutionHistoryResponse> getExecutionHistory(
            GetExecutionHistoryRequest getExecutionHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the history of the specified execution as a list of events. By default, the results are returned in
     * ascending order of the <code>timeStamp</code> of the events. Use the <code>reverseOrder</code> parameter to get
     * the latest events first.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <p>
     * This API action is not supported by <code>EXPRESS</code> state machines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExecutionHistoryRequest.Builder} avoiding the
     * need to create one manually via {@link GetExecutionHistoryRequest#builder()}
     * </p>
     *
     * @param getExecutionHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetExecutionHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ExecutionDoesNotExistException The specified execution does not exist.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.GetExecutionHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetExecutionHistory" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetExecutionHistoryResponse> getExecutionHistory(
            Consumer<GetExecutionHistoryRequest.Builder> getExecutionHistoryRequest) {
        return getExecutionHistory(GetExecutionHistoryRequest.builder().applyMutation(getExecutionHistoryRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getExecutionHistory(software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.GetExecutionHistoryPublisher publisher = client.getExecutionHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.GetExecutionHistoryPublisher publisher = client.getExecutionHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sfn.model.GetExecutionHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sfn.model.GetExecutionHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getExecutionHistory(software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest)} operation.</b>
     * </p>
     *
     * @param getExecutionHistoryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ExecutionDoesNotExistException The specified execution does not exist.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.GetExecutionHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetExecutionHistory" target="_top">AWS
     *      API Documentation</a>
     */
    default GetExecutionHistoryPublisher getExecutionHistoryPaginator(GetExecutionHistoryRequest getExecutionHistoryRequest) {
        return new GetExecutionHistoryPublisher(this, getExecutionHistoryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getExecutionHistory(software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.GetExecutionHistoryPublisher publisher = client.getExecutionHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.GetExecutionHistoryPublisher publisher = client.getExecutionHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sfn.model.GetExecutionHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sfn.model.GetExecutionHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getExecutionHistory(software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExecutionHistoryRequest.Builder} avoiding the
     * need to create one manually via {@link GetExecutionHistoryRequest#builder()}
     * </p>
     *
     * @param getExecutionHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ExecutionDoesNotExistException The specified execution does not exist.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.GetExecutionHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetExecutionHistory" target="_top">AWS
     *      API Documentation</a>
     */
    default GetExecutionHistoryPublisher getExecutionHistoryPaginator(
            Consumer<GetExecutionHistoryRequest.Builder> getExecutionHistoryRequest) {
        return getExecutionHistoryPaginator(GetExecutionHistoryRequest.builder().applyMutation(getExecutionHistoryRequest)
                .build());
    }

    /**
     * <p>
     * Lists the existing activities.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     *
     * @param listActivitiesRequest
     * @return A Java Future containing the result of the ListActivities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListActivities" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListActivitiesResponse> listActivities(ListActivitiesRequest listActivitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the existing activities.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActivitiesRequest.Builder} avoiding the need to
     * create one manually via {@link ListActivitiesRequest#builder()}
     * </p>
     *
     * @param listActivitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListActivitiesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListActivities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListActivities" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListActivitiesResponse> listActivities(Consumer<ListActivitiesRequest.Builder> listActivitiesRequest) {
        return listActivities(ListActivitiesRequest.builder().applyMutation(listActivitiesRequest).build());
    }

    /**
     * <p>
     * Lists the existing activities.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the ListActivities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListActivities" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListActivitiesResponse> listActivities() {
        return listActivities(ListActivitiesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listActivities(software.amazon.awssdk.services.sfn.model.ListActivitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListActivitiesPublisher publisher = client.listActivitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListActivitiesPublisher publisher = client.listActivitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sfn.model.ListActivitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sfn.model.ListActivitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActivities(software.amazon.awssdk.services.sfn.model.ListActivitiesRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListActivities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListActivitiesPublisher listActivitiesPaginator() {
        return listActivitiesPaginator(ListActivitiesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listActivities(software.amazon.awssdk.services.sfn.model.ListActivitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListActivitiesPublisher publisher = client.listActivitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListActivitiesPublisher publisher = client.listActivitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sfn.model.ListActivitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sfn.model.ListActivitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActivities(software.amazon.awssdk.services.sfn.model.ListActivitiesRequest)} operation.</b>
     * </p>
     *
     * @param listActivitiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListActivities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListActivitiesPublisher listActivitiesPaginator(ListActivitiesRequest listActivitiesRequest) {
        return new ListActivitiesPublisher(this, listActivitiesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listActivities(software.amazon.awssdk.services.sfn.model.ListActivitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListActivitiesPublisher publisher = client.listActivitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListActivitiesPublisher publisher = client.listActivitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sfn.model.ListActivitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sfn.model.ListActivitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActivities(software.amazon.awssdk.services.sfn.model.ListActivitiesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActivitiesRequest.Builder} avoiding the need to
     * create one manually via {@link ListActivitiesRequest#builder()}
     * </p>
     *
     * @param listActivitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListActivitiesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListActivities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListActivitiesPublisher listActivitiesPaginator(Consumer<ListActivitiesRequest.Builder> listActivitiesRequest) {
        return listActivitiesPaginator(ListActivitiesRequest.builder().applyMutation(listActivitiesRequest).build());
    }

    /**
     * <p>
     * Lists all executions of a state machine or a Map Run. You can list all executions related to a state machine by
     * specifying a state machine Amazon Resource Name (ARN), or those related to a Map Run by specifying a Map Run ARN.
     * Using this API action, you can also list all <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html">redriven</a> executions.
     * </p>
     * <p>
     * You can also provide a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> ARN or <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a> ARN
     * to list the executions associated with a specific alias or version.
     * </p>
     * <p>
     * Results are sorted by time, with the most recent execution first.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     * <p>
     * This API action is not supported by <code>EXPRESS</code> state machines.
     * </p>
     *
     * @param listExecutionsRequest
     * @return A Java Future containing the result of the ListExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>StateMachineDoesNotExistException The specified state machine does not exist.</li>
     *         <li>StateMachineTypeNotSupportedException</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListExecutions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExecutionsResponse> listExecutions(ListExecutionsRequest listExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all executions of a state machine or a Map Run. You can list all executions related to a state machine by
     * specifying a state machine Amazon Resource Name (ARN), or those related to a Map Run by specifying a Map Run ARN.
     * Using this API action, you can also list all <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html">redriven</a> executions.
     * </p>
     * <p>
     * You can also provide a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> ARN or <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a> ARN
     * to list the executions associated with a specific alias or version.
     * </p>
     * <p>
     * Results are sorted by time, with the most recent execution first.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     * <p>
     * This API action is not supported by <code>EXPRESS</code> state machines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExecutionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExecutionsRequest#builder()}
     * </p>
     *
     * @param listExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListExecutionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>StateMachineDoesNotExistException The specified state machine does not exist.</li>
     *         <li>StateMachineTypeNotSupportedException</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListExecutions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExecutionsResponse> listExecutions(Consumer<ListExecutionsRequest.Builder> listExecutionsRequest) {
        return listExecutions(ListExecutionsRequest.builder().applyMutation(listExecutionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listExecutions(software.amazon.awssdk.services.sfn.model.ListExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListExecutionsPublisher publisher = client.listExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListExecutionsPublisher publisher = client.listExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sfn.model.ListExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sfn.model.ListExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExecutions(software.amazon.awssdk.services.sfn.model.ListExecutionsRequest)} operation.</b>
     * </p>
     *
     * @param listExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>StateMachineDoesNotExistException The specified state machine does not exist.</li>
     *         <li>StateMachineTypeNotSupportedException</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListExecutions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExecutionsPublisher listExecutionsPaginator(ListExecutionsRequest listExecutionsRequest) {
        return new ListExecutionsPublisher(this, listExecutionsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listExecutions(software.amazon.awssdk.services.sfn.model.ListExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListExecutionsPublisher publisher = client.listExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListExecutionsPublisher publisher = client.listExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sfn.model.ListExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sfn.model.ListExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExecutions(software.amazon.awssdk.services.sfn.model.ListExecutionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExecutionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExecutionsRequest#builder()}
     * </p>
     *
     * @param listExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListExecutionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>StateMachineDoesNotExistException The specified state machine does not exist.</li>
     *         <li>StateMachineTypeNotSupportedException</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListExecutions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExecutionsPublisher listExecutionsPaginator(Consumer<ListExecutionsRequest.Builder> listExecutionsRequest) {
        return listExecutionsPaginator(ListExecutionsRequest.builder().applyMutation(listExecutionsRequest).build());
    }

    /**
     * <p>
     * Lists all Map Runs that were started by a given state machine execution. Use this API action to obtain Map Run
     * ARNs, and then call <code>DescribeMapRun</code> to obtain more information, if needed.
     * </p>
     *
     * @param listMapRunsRequest
     * @return A Java Future containing the result of the ListMapRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ExecutionDoesNotExistException The specified execution does not exist.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListMapRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListMapRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMapRunsResponse> listMapRuns(ListMapRunsRequest listMapRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Map Runs that were started by a given state machine execution. Use this API action to obtain Map Run
     * ARNs, and then call <code>DescribeMapRun</code> to obtain more information, if needed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMapRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMapRunsRequest#builder()}
     * </p>
     *
     * @param listMapRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListMapRunsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListMapRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ExecutionDoesNotExistException The specified execution does not exist.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListMapRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListMapRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMapRunsResponse> listMapRuns(Consumer<ListMapRunsRequest.Builder> listMapRunsRequest) {
        return listMapRuns(ListMapRunsRequest.builder().applyMutation(listMapRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listMapRuns(software.amazon.awssdk.services.sfn.model.ListMapRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListMapRunsPublisher publisher = client.listMapRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListMapRunsPublisher publisher = client.listMapRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sfn.model.ListMapRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sfn.model.ListMapRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMapRuns(software.amazon.awssdk.services.sfn.model.ListMapRunsRequest)} operation.</b>
     * </p>
     *
     * @param listMapRunsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ExecutionDoesNotExistException The specified execution does not exist.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListMapRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListMapRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMapRunsPublisher listMapRunsPaginator(ListMapRunsRequest listMapRunsRequest) {
        return new ListMapRunsPublisher(this, listMapRunsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listMapRuns(software.amazon.awssdk.services.sfn.model.ListMapRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListMapRunsPublisher publisher = client.listMapRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListMapRunsPublisher publisher = client.listMapRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sfn.model.ListMapRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sfn.model.ListMapRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMapRuns(software.amazon.awssdk.services.sfn.model.ListMapRunsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMapRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMapRunsRequest#builder()}
     * </p>
     *
     * @param listMapRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListMapRunsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ExecutionDoesNotExistException The specified execution does not exist.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListMapRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListMapRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMapRunsPublisher listMapRunsPaginator(Consumer<ListMapRunsRequest.Builder> listMapRunsRequest) {
        return listMapRunsPaginator(ListMapRunsRequest.builder().applyMutation(listMapRunsRequest).build());
    }

    /**
     * <p>
     * Lists <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">aliases</a> for a
     * specified state machine ARN. Results are sorted by time, with the most recently created aliases listed first.
     * </p>
     * <p>
     * To list aliases that reference a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>, you
     * can specify the version ARN in the <code>stateMachineArn</code> parameter.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>CreateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DescribeStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>UpdateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteStateMachineAlias</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listStateMachineAliasesRequest
     * @return A Java Future containing the result of the ListStateMachineAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>StateMachineDoesNotExistException The specified state machine does not exist.</li>
     *         <li>StateMachineDeletingException The specified state machine is being deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListStateMachineAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachineAliases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStateMachineAliasesResponse> listStateMachineAliases(
            ListStateMachineAliasesRequest listStateMachineAliasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">aliases</a> for a
     * specified state machine ARN. Results are sorted by time, with the most recently created aliases listed first.
     * </p>
     * <p>
     * To list aliases that reference a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>, you
     * can specify the version ARN in the <code>stateMachineArn</code> parameter.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>CreateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DescribeStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>UpdateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteStateMachineAlias</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStateMachineAliasesRequest.Builder} avoiding
     * the need to create one manually via {@link ListStateMachineAliasesRequest#builder()}
     * </p>
     *
     * @param listStateMachineAliasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListStateMachineAliasesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListStateMachineAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>StateMachineDoesNotExistException The specified state machine does not exist.</li>
     *         <li>StateMachineDeletingException The specified state machine is being deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListStateMachineAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachineAliases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStateMachineAliasesResponse> listStateMachineAliases(
            Consumer<ListStateMachineAliasesRequest.Builder> listStateMachineAliasesRequest) {
        return listStateMachineAliases(ListStateMachineAliasesRequest.builder().applyMutation(listStateMachineAliasesRequest)
                .build());
    }

    /**
     * <p>
     * Lists <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">versions</a> for
     * the specified state machine Amazon Resource Name (ARN).
     * </p>
     * <p>
     * The results are sorted in descending order of the version creation time.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>PublishStateMachineVersion</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteStateMachineVersion</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listStateMachineVersionsRequest
     * @return A Java Future containing the result of the ListStateMachineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListStateMachineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStateMachineVersionsResponse> listStateMachineVersions(
            ListStateMachineVersionsRequest listStateMachineVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">versions</a> for
     * the specified state machine Amazon Resource Name (ARN).
     * </p>
     * <p>
     * The results are sorted in descending order of the version creation time.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>PublishStateMachineVersion</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteStateMachineVersion</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStateMachineVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListStateMachineVersionsRequest#builder()}
     * </p>
     *
     * @param listStateMachineVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListStateMachineVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListStateMachineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListStateMachineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStateMachineVersionsResponse> listStateMachineVersions(
            Consumer<ListStateMachineVersionsRequest.Builder> listStateMachineVersionsRequest) {
        return listStateMachineVersions(ListStateMachineVersionsRequest.builder().applyMutation(listStateMachineVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the existing state machines.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     *
     * @param listStateMachinesRequest
     * @return A Java Future containing the result of the ListStateMachines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListStateMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachines" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStateMachinesResponse> listStateMachines(ListStateMachinesRequest listStateMachinesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the existing state machines.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStateMachinesRequest.Builder} avoiding the need
     * to create one manually via {@link ListStateMachinesRequest#builder()}
     * </p>
     *
     * @param listStateMachinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListStateMachines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListStateMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachines" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStateMachinesResponse> listStateMachines(
            Consumer<ListStateMachinesRequest.Builder> listStateMachinesRequest) {
        return listStateMachines(ListStateMachinesRequest.builder().applyMutation(listStateMachinesRequest).build());
    }

    /**
     * <p>
     * Lists the existing state machines.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the ListStateMachines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListStateMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachines" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStateMachinesResponse> listStateMachines() {
        return listStateMachines(ListStateMachinesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStateMachines(software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListStateMachinesPublisher publisher = client.listStateMachinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListStateMachinesPublisher publisher = client.listStateMachinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStateMachines(software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListStateMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachines" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStateMachinesPublisher listStateMachinesPaginator() {
        return listStateMachinesPaginator(ListStateMachinesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStateMachines(software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListStateMachinesPublisher publisher = client.listStateMachinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListStateMachinesPublisher publisher = client.listStateMachinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStateMachines(software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest)} operation.</b>
     * </p>
     *
     * @param listStateMachinesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListStateMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachines" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStateMachinesPublisher listStateMachinesPaginator(ListStateMachinesRequest listStateMachinesRequest) {
        return new ListStateMachinesPublisher(this, listStateMachinesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStateMachines(software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListStateMachinesPublisher publisher = client.listStateMachinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListStateMachinesPublisher publisher = client.listStateMachinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStateMachines(software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStateMachinesRequest.Builder} avoiding the need
     * to create one manually via {@link ListStateMachinesRequest#builder()}
     * </p>
     *
     * @param listStateMachinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListStateMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachines" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStateMachinesPublisher listStateMachinesPaginator(
            Consumer<ListStateMachinesRequest.Builder> listStateMachinesRequest) {
        return listStateMachinesPaginator(ListStateMachinesRequest.builder().applyMutation(listStateMachinesRequest).build());
    }

    /**
     * <p>
     * List tags for a given resource.
     * </p>
     * <p>
     * Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List tags for a given resource.
     * </p>
     * <p>
     * Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListTagsForResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates a <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a> from
     * the current revision of a state machine. Use versions to create immutable snapshots of your state machine. You
     * can start executions from versions either directly or with an alias. To create an alias, use
     * <a>CreateStateMachineAlias</a>.
     * </p>
     * <p>
     * You can publish up to 1000 versions for each state machine. You must manually delete unused versions using the
     * <a>DeleteStateMachineVersion</a> API action.
     * </p>
     * <p>
     * <code>PublishStateMachineVersion</code> is an idempotent API. It doesn't create a duplicate state machine version
     * if it already exists for the current revision. Step Functions bases <code>PublishStateMachineVersion</code>'s
     * idempotency check on the <code>stateMachineArn</code>, <code>name</code>, and <code>revisionId</code> parameters.
     * Requests with the same parameters return a successful idempotent response. If you don't specify a
     * <code>revisionId</code>, Step Functions checks for a previously published version of the state machine's current
     * revision.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DeleteStateMachineVersion</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineVersions</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param publishStateMachineVersionRequest
     * @return A Java Future containing the result of the PublishStateMachineVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>StateMachineDeletingException The specified state machine is being deleted.</li>
     *         <li>StateMachineDoesNotExistException The specified state machine does not exist.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</p>
     *         <p>
     *         HTTP Status Code: 402</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state. This error occurs
     *         when there're concurrent requests for <a>DeleteStateMachineVersion</a>,
     *         <a>PublishStateMachineVersion</a>, or <a>UpdateStateMachine</a> with the <code>publish</code> parameter
     *         set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.PublishStateMachineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/PublishStateMachineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PublishStateMachineVersionResponse> publishStateMachineVersion(
            PublishStateMachineVersionRequest publishStateMachineVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a> from
     * the current revision of a state machine. Use versions to create immutable snapshots of your state machine. You
     * can start executions from versions either directly or with an alias. To create an alias, use
     * <a>CreateStateMachineAlias</a>.
     * </p>
     * <p>
     * You can publish up to 1000 versions for each state machine. You must manually delete unused versions using the
     * <a>DeleteStateMachineVersion</a> API action.
     * </p>
     * <p>
     * <code>PublishStateMachineVersion</code> is an idempotent API. It doesn't create a duplicate state machine version
     * if it already exists for the current revision. Step Functions bases <code>PublishStateMachineVersion</code>'s
     * idempotency check on the <code>stateMachineArn</code>, <code>name</code>, and <code>revisionId</code> parameters.
     * Requests with the same parameters return a successful idempotent response. If you don't specify a
     * <code>revisionId</code>, Step Functions checks for a previously published version of the state machine's current
     * revision.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DeleteStateMachineVersion</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineVersions</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PublishStateMachineVersionRequest.Builder} avoiding
     * the need to create one manually via {@link PublishStateMachineVersionRequest#builder()}
     * </p>
     *
     * @param publishStateMachineVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.PublishStateMachineVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PublishStateMachineVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>StateMachineDeletingException The specified state machine is being deleted.</li>
     *         <li>StateMachineDoesNotExistException The specified state machine does not exist.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</p>
     *         <p>
     *         HTTP Status Code: 402</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state. This error occurs
     *         when there're concurrent requests for <a>DeleteStateMachineVersion</a>,
     *         <a>PublishStateMachineVersion</a>, or <a>UpdateStateMachine</a> with the <code>publish</code> parameter
     *         set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.PublishStateMachineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/PublishStateMachineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PublishStateMachineVersionResponse> publishStateMachineVersion(
            Consumer<PublishStateMachineVersionRequest.Builder> publishStateMachineVersionRequest) {
        return publishStateMachineVersion(PublishStateMachineVersionRequest.builder()
                .applyMutation(publishStateMachineVersionRequest).build());
    }

    /**
     * <p>
     * Restarts unsuccessful executions of Standard workflows that didn't complete successfully in the last 14 days.
     * These include failed, aborted, or timed out executions. When you <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html">redrive</a> an execution, it
     * continues the failed execution from the unsuccessful step and uses the same input. Step Functions preserves the
     * results and execution history of the successful steps, and doesn't rerun these steps when you redrive an
     * execution. Redriven executions use the same state machine definition and execution ARN as the original execution
     * attempt.
     * </p>
     * <p>
     * For workflows that include an <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html">Inline Map</a>
     * or <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-parallel-state.html">Parallel
     * </a> state, <code>RedriveExecution</code> API action reschedules and redrives only the iterations and branches
     * that failed or aborted.
     * </p>
     * <p>
     * To redrive a workflow that includes a Distributed Map state whose Map Run failed, you must redrive the <a href=
     * "https://docs.aws.amazon.com/step-functions/latest/dg/use-dist-map-orchestrate-large-scale-parallel-workloads.html#dist-map-orchestrate-parallel-workloads-key-terms"
     * >parent workflow</a>. The parent workflow redrives all the unsuccessful states, including a failed Map Run. If a
     * Map Run was not started in the original execution attempt, the redriven parent workflow starts the Map Run.
     * </p>
     * <note>
     * <p>
     * This API action is not supported by <code>EXPRESS</code> state machines.
     * </p>
     * <p>
     * However, you can restart the unsuccessful executions of Express child workflows in a Distributed Map by redriving
     * its Map Run. When you redrive a Map Run, the Express child workflows are rerun using the <a>StartExecution</a>
     * API action. For more information, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html">Redriving Map Runs</a>.
     * </p>
     * </note>
     * <p>
     * You can redrive executions if your original execution meets the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The execution status isn't <code>SUCCEEDED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your workflow execution has not exceeded the redrivable period of 14 days. Redrivable period refers to the time
     * during which you can redrive a given execution. This period starts from the day a state machine completes its
     * execution.
     * </p>
     * </li>
     * <li>
     * <p>
     * The workflow execution has not exceeded the maximum open time of one year. For more information about state
     * machine quotas, see <a href=
     * "https://docs.aws.amazon.com/step-functions/latest/dg/limits-overview.html#service-limits-state-machine-executions"
     * >Quotas related to state machine executions</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The execution event history count is less than 24,999. Redriven executions append their event history to the
     * existing event history. Make sure your workflow execution contains less than 24,999 events to accommodate the
     * <code>ExecutionRedriven</code> history event and at least one other history event.
     * </p>
     * </li>
     * </ul>
     *
     * @param redriveExecutionRequest
     * @return A Java Future containing the result of the RedriveExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ExecutionDoesNotExistException The specified execution does not exist.</li>
     *         <li>ExecutionNotRedrivableException The execution Amazon Resource Name (ARN) that you specified for
     *         <code>executionArn</code> cannot be redriven.</li>
     *         <li>ExecutionLimitExceededException The maximum number of running executions has been reached. Running
     *         executions must end or be stopped before a new execution can be started.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.RedriveExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/RedriveExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RedriveExecutionResponse> redriveExecution(RedriveExecutionRequest redriveExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restarts unsuccessful executions of Standard workflows that didn't complete successfully in the last 14 days.
     * These include failed, aborted, or timed out executions. When you <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html">redrive</a> an execution, it
     * continues the failed execution from the unsuccessful step and uses the same input. Step Functions preserves the
     * results and execution history of the successful steps, and doesn't rerun these steps when you redrive an
     * execution. Redriven executions use the same state machine definition and execution ARN as the original execution
     * attempt.
     * </p>
     * <p>
     * For workflows that include an <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html">Inline Map</a>
     * or <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-parallel-state.html">Parallel
     * </a> state, <code>RedriveExecution</code> API action reschedules and redrives only the iterations and branches
     * that failed or aborted.
     * </p>
     * <p>
     * To redrive a workflow that includes a Distributed Map state whose Map Run failed, you must redrive the <a href=
     * "https://docs.aws.amazon.com/step-functions/latest/dg/use-dist-map-orchestrate-large-scale-parallel-workloads.html#dist-map-orchestrate-parallel-workloads-key-terms"
     * >parent workflow</a>. The parent workflow redrives all the unsuccessful states, including a failed Map Run. If a
     * Map Run was not started in the original execution attempt, the redriven parent workflow starts the Map Run.
     * </p>
     * <note>
     * <p>
     * This API action is not supported by <code>EXPRESS</code> state machines.
     * </p>
     * <p>
     * However, you can restart the unsuccessful executions of Express child workflows in a Distributed Map by redriving
     * its Map Run. When you redrive a Map Run, the Express child workflows are rerun using the <a>StartExecution</a>
     * API action. For more information, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html">Redriving Map Runs</a>.
     * </p>
     * </note>
     * <p>
     * You can redrive executions if your original execution meets the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The execution status isn't <code>SUCCEEDED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your workflow execution has not exceeded the redrivable period of 14 days. Redrivable period refers to the time
     * during which you can redrive a given execution. This period starts from the day a state machine completes its
     * execution.
     * </p>
     * </li>
     * <li>
     * <p>
     * The workflow execution has not exceeded the maximum open time of one year. For more information about state
     * machine quotas, see <a href=
     * "https://docs.aws.amazon.com/step-functions/latest/dg/limits-overview.html#service-limits-state-machine-executions"
     * >Quotas related to state machine executions</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The execution event history count is less than 24,999. Redriven executions append their event history to the
     * existing event history. Make sure your workflow execution contains less than 24,999 events to accommodate the
     * <code>ExecutionRedriven</code> history event and at least one other history event.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RedriveExecutionRequest.Builder} avoiding the need
     * to create one manually via {@link RedriveExecutionRequest#builder()}
     * </p>
     *
     * @param redriveExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.RedriveExecutionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RedriveExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ExecutionDoesNotExistException The specified execution does not exist.</li>
     *         <li>ExecutionNotRedrivableException The execution Amazon Resource Name (ARN) that you specified for
     *         <code>executionArn</code> cannot be redriven.</li>
     *         <li>ExecutionLimitExceededException The maximum number of running executions has been reached. Running
     *         executions must end or be stopped before a new execution can be started.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.RedriveExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/RedriveExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RedriveExecutionResponse> redriveExecution(
            Consumer<RedriveExecutionRequest.Builder> redriveExecutionRequest) {
        return redriveExecution(RedriveExecutionRequest.builder().applyMutation(redriveExecutionRequest).build());
    }

    /**
     * <p>
     * Used by activity workers, Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token"
     * >callback</a> pattern, and optionally Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a>
     * pattern to report that the task identified by the <code>taskToken</code> failed.
     * </p>
     *
     * @param sendTaskFailureRequest
     * @return A Java Future containing the result of the SendTaskFailure operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TaskDoesNotExistException The activity does not exist.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>TaskTimedOutException The task token has either expired or the task associated with the token has
     *         already been closed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.SendTaskFailure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskFailure" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendTaskFailureResponse> sendTaskFailure(SendTaskFailureRequest sendTaskFailureRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by activity workers, Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token"
     * >callback</a> pattern, and optionally Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a>
     * pattern to report that the task identified by the <code>taskToken</code> failed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendTaskFailureRequest.Builder} avoiding the need
     * to create one manually via {@link SendTaskFailureRequest#builder()}
     * </p>
     *
     * @param sendTaskFailureRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.SendTaskFailureRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SendTaskFailure operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TaskDoesNotExistException The activity does not exist.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>TaskTimedOutException The task token has either expired or the task associated with the token has
     *         already been closed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.SendTaskFailure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskFailure" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendTaskFailureResponse> sendTaskFailure(
            Consumer<SendTaskFailureRequest.Builder> sendTaskFailureRequest) {
        return sendTaskFailure(SendTaskFailureRequest.builder().applyMutation(sendTaskFailureRequest).build());
    }

    /**
     * <p>
     * Used by activity workers and Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token"
     * >callback</a> pattern, and optionally Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a>
     * pattern to report to Step Functions that the task represented by the specified <code>taskToken</code> is still
     * making progress. This action resets the <code>Heartbeat</code> clock. The <code>Heartbeat</code> threshold is
     * specified in the state machine's Amazon States Language definition (<code>HeartbeatSeconds</code>). This action
     * does not in itself create an event in the execution history. However, if the task times out, the execution
     * history contains an <code>ActivityTimedOut</code> entry for activities, or a <code>TaskTimedOut</code> entry for
     * tasks using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a> or
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">
     * callback</a> pattern.
     * </p>
     * <note>
     * <p>
     * The <code>Timeout</code> of a task, defined in the state machine's Amazon States Language definition, is its
     * maximum allowed duration, regardless of the number of <a>SendTaskHeartbeat</a> requests received. Use
     * <code>HeartbeatSeconds</code> to configure the timeout interval for heartbeats.
     * </p>
     * </note>
     *
     * @param sendTaskHeartbeatRequest
     * @return A Java Future containing the result of the SendTaskHeartbeat operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TaskDoesNotExistException The activity does not exist.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>TaskTimedOutException The task token has either expired or the task associated with the token has
     *         already been closed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.SendTaskHeartbeat
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskHeartbeat" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendTaskHeartbeatResponse> sendTaskHeartbeat(SendTaskHeartbeatRequest sendTaskHeartbeatRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by activity workers and Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token"
     * >callback</a> pattern, and optionally Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a>
     * pattern to report to Step Functions that the task represented by the specified <code>taskToken</code> is still
     * making progress. This action resets the <code>Heartbeat</code> clock. The <code>Heartbeat</code> threshold is
     * specified in the state machine's Amazon States Language definition (<code>HeartbeatSeconds</code>). This action
     * does not in itself create an event in the execution history. However, if the task times out, the execution
     * history contains an <code>ActivityTimedOut</code> entry for activities, or a <code>TaskTimedOut</code> entry for
     * tasks using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a> or
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">
     * callback</a> pattern.
     * </p>
     * <note>
     * <p>
     * The <code>Timeout</code> of a task, defined in the state machine's Amazon States Language definition, is its
     * maximum allowed duration, regardless of the number of <a>SendTaskHeartbeat</a> requests received. Use
     * <code>HeartbeatSeconds</code> to configure the timeout interval for heartbeats.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendTaskHeartbeatRequest.Builder} avoiding the need
     * to create one manually via {@link SendTaskHeartbeatRequest#builder()}
     * </p>
     *
     * @param sendTaskHeartbeatRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.SendTaskHeartbeatRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SendTaskHeartbeat operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TaskDoesNotExistException The activity does not exist.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>TaskTimedOutException The task token has either expired or the task associated with the token has
     *         already been closed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.SendTaskHeartbeat
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskHeartbeat" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendTaskHeartbeatResponse> sendTaskHeartbeat(
            Consumer<SendTaskHeartbeatRequest.Builder> sendTaskHeartbeatRequest) {
        return sendTaskHeartbeat(SendTaskHeartbeatRequest.builder().applyMutation(sendTaskHeartbeatRequest).build());
    }

    /**
     * <p>
     * Used by activity workers, Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token"
     * >callback</a> pattern, and optionally Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a>
     * pattern to report that the task identified by the <code>taskToken</code> completed successfully.
     * </p>
     *
     * @param sendTaskSuccessRequest
     * @return A Java Future containing the result of the SendTaskSuccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TaskDoesNotExistException The activity does not exist.</li>
     *         <li>InvalidOutputException The provided JSON output data is not valid.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>TaskTimedOutException The task token has either expired or the task associated with the token has
     *         already been closed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.SendTaskSuccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskSuccess" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendTaskSuccessResponse> sendTaskSuccess(SendTaskSuccessRequest sendTaskSuccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by activity workers, Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token"
     * >callback</a> pattern, and optionally Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a>
     * pattern to report that the task identified by the <code>taskToken</code> completed successfully.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendTaskSuccessRequest.Builder} avoiding the need
     * to create one manually via {@link SendTaskSuccessRequest#builder()}
     * </p>
     *
     * @param sendTaskSuccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.SendTaskSuccessRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SendTaskSuccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TaskDoesNotExistException The activity does not exist.</li>
     *         <li>InvalidOutputException The provided JSON output data is not valid.</li>
     *         <li>InvalidTokenException The provided token is not valid.</li>
     *         <li>TaskTimedOutException The task token has either expired or the task associated with the token has
     *         already been closed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.SendTaskSuccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskSuccess" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendTaskSuccessResponse> sendTaskSuccess(
            Consumer<SendTaskSuccessRequest.Builder> sendTaskSuccessRequest) {
        return sendTaskSuccess(SendTaskSuccessRequest.builder().applyMutation(sendTaskSuccessRequest).build());
    }

    /**
     * <p>
     * Starts a state machine execution.
     * </p>
     * <p>
     * A qualified state machine ARN can either refer to a <i>Distributed Map state</i> defined within a state machine,
     * a version ARN, or an alias ARN.
     * </p>
     * <p>
     * The following are some examples of qualified and unqualified state machine ARNs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to a <i>Distributed Map state</i> with a label
     * <code>mapStateLabel</code> in a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a <i>Distributed Map state</i>, the request fails
     * with <code>ValidationException</code>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to an alias named <code>PROD</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine:PROD&gt;</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a version ARN or an alias ARN, the request starts
     * execution for that version or alias.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following unqualified state machine ARN refers to a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you start an execution with an unqualified state machine ARN, Step Functions uses the latest revision of the
     * state machine for the execution.
     * </p>
     * <p>
     * To start executions of a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>, call
     * <code>StartExecution</code> and provide the version ARN or the ARN of an <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> that
     * points to the version.
     * </p>
     * <note>
     * <p>
     * <code>StartExecution</code> is idempotent for <code>STANDARD</code> workflows. For a <code>STANDARD</code>
     * workflow, if you call <code>StartExecution</code> with the same name and input as a running execution, the call
     * succeeds and return the same response as the original request. If the execution is closed or if the input is
     * different, it returns a <code>400 ExecutionAlreadyExists</code> error. You can reuse names after 90 days.
     * </p>
     * <p>
     * <code>StartExecution</code> isn't idempotent for <code>EXPRESS</code> workflows.
     * </p>
     * </note>
     *
     * @param startExecutionRequest
     * @return A Java Future containing the result of the StartExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ExecutionLimitExceededException The maximum number of running executions has been reached. Running
     *         executions must end or be stopped before a new execution can be started.</li>
     *         <li>ExecutionAlreadyExistsException The execution has the same <code>name</code> as another execution
     *         (but a different <code>input</code>).</p> <note>
     *         <p>
     *         Executions with the same <code>name</code> and <code>input</code> are considered idempotent.
     *         </p>
     *         </li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidExecutionInputException The provided JSON input data is not valid.</li>
     *         <li>InvalidNameException The provided name is not valid.</li>
     *         <li>StateMachineDoesNotExistException The specified state machine does not exist.</li>
     *         <li>StateMachineDeletingException The specified state machine is being deleted.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.StartExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StartExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartExecutionResponse> startExecution(StartExecutionRequest startExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a state machine execution.
     * </p>
     * <p>
     * A qualified state machine ARN can either refer to a <i>Distributed Map state</i> defined within a state machine,
     * a version ARN, or an alias ARN.
     * </p>
     * <p>
     * The following are some examples of qualified and unqualified state machine ARNs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to a <i>Distributed Map state</i> with a label
     * <code>mapStateLabel</code> in a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a <i>Distributed Map state</i>, the request fails
     * with <code>ValidationException</code>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to an alias named <code>PROD</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine:PROD&gt;</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a version ARN or an alias ARN, the request starts
     * execution for that version or alias.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following unqualified state machine ARN refers to a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you start an execution with an unqualified state machine ARN, Step Functions uses the latest revision of the
     * state machine for the execution.
     * </p>
     * <p>
     * To start executions of a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>, call
     * <code>StartExecution</code> and provide the version ARN or the ARN of an <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> that
     * points to the version.
     * </p>
     * <note>
     * <p>
     * <code>StartExecution</code> is idempotent for <code>STANDARD</code> workflows. For a <code>STANDARD</code>
     * workflow, if you call <code>StartExecution</code> with the same name and input as a running execution, the call
     * succeeds and return the same response as the original request. If the execution is closed or if the input is
     * different, it returns a <code>400 ExecutionAlreadyExists</code> error. You can reuse names after 90 days.
     * </p>
     * <p>
     * <code>StartExecution</code> isn't idempotent for <code>EXPRESS</code> workflows.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartExecutionRequest.Builder} avoiding the need to
     * create one manually via {@link StartExecutionRequest#builder()}
     * </p>
     *
     * @param startExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.StartExecutionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ExecutionLimitExceededException The maximum number of running executions has been reached. Running
     *         executions must end or be stopped before a new execution can be started.</li>
     *         <li>ExecutionAlreadyExistsException The execution has the same <code>name</code> as another execution
     *         (but a different <code>input</code>).</p> <note>
     *         <p>
     *         Executions with the same <code>name</code> and <code>input</code> are considered idempotent.
     *         </p>
     *         </li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidExecutionInputException The provided JSON input data is not valid.</li>
     *         <li>InvalidNameException The provided name is not valid.</li>
     *         <li>StateMachineDoesNotExistException The specified state machine does not exist.</li>
     *         <li>StateMachineDeletingException The specified state machine is being deleted.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.StartExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StartExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartExecutionResponse> startExecution(Consumer<StartExecutionRequest.Builder> startExecutionRequest) {
        return startExecution(StartExecutionRequest.builder().applyMutation(startExecutionRequest).build());
    }

    /**
     * <p>
     * Starts a Synchronous Express state machine execution. <code>StartSyncExecution</code> is not available for
     * <code>STANDARD</code> workflows.
     * </p>
     * <note>
     * <p>
     * <code>StartSyncExecution</code> will return a <code>200 OK</code> response, even if your execution fails, because
     * the status code in the API response doesn't reflect function errors. Error codes are reserved for errors that
     * prevent your execution from running, such as permissions errors, limit errors, or issues with your state machine
     * code and configuration.
     * </p>
     * </note> <note>
     * <p>
     * This API action isn't logged in CloudTrail.
     * </p>
     * </note>
     *
     * @param startSyncExecutionRequest
     * @return A Java Future containing the result of the StartSyncExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidExecutionInputException The provided JSON input data is not valid.</li>
     *         <li>InvalidNameException The provided name is not valid.</li>
     *         <li>StateMachineDoesNotExistException The specified state machine does not exist.</li>
     *         <li>StateMachineDeletingException The specified state machine is being deleted.</li>
     *         <li>StateMachineTypeNotSupportedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.StartSyncExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StartSyncExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartSyncExecutionResponse> startSyncExecution(StartSyncExecutionRequest startSyncExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a Synchronous Express state machine execution. <code>StartSyncExecution</code> is not available for
     * <code>STANDARD</code> workflows.
     * </p>
     * <note>
     * <p>
     * <code>StartSyncExecution</code> will return a <code>200 OK</code> response, even if your execution fails, because
     * the status code in the API response doesn't reflect function errors. Error codes are reserved for errors that
     * prevent your execution from running, such as permissions errors, limit errors, or issues with your state machine
     * code and configuration.
     * </p>
     * </note> <note>
     * <p>
     * This API action isn't logged in CloudTrail.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSyncExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link StartSyncExecutionRequest#builder()}
     * </p>
     *
     * @param startSyncExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.StartSyncExecutionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartSyncExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidExecutionInputException The provided JSON input data is not valid.</li>
     *         <li>InvalidNameException The provided name is not valid.</li>
     *         <li>StateMachineDoesNotExistException The specified state machine does not exist.</li>
     *         <li>StateMachineDeletingException The specified state machine is being deleted.</li>
     *         <li>StateMachineTypeNotSupportedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.StartSyncExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StartSyncExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartSyncExecutionResponse> startSyncExecution(
            Consumer<StartSyncExecutionRequest.Builder> startSyncExecutionRequest) {
        return startSyncExecution(StartSyncExecutionRequest.builder().applyMutation(startSyncExecutionRequest).build());
    }

    /**
     * <p>
     * Stops an execution.
     * </p>
     * <p>
     * This API action is not supported by <code>EXPRESS</code> state machines.
     * </p>
     *
     * @param stopExecutionRequest
     * @return A Java Future containing the result of the StopExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ExecutionDoesNotExistException The specified execution does not exist.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.StopExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StopExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopExecutionResponse> stopExecution(StopExecutionRequest stopExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an execution.
     * </p>
     * <p>
     * This API action is not supported by <code>EXPRESS</code> state machines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopExecutionRequest.Builder} avoiding the need to
     * create one manually via {@link StopExecutionRequest#builder()}
     * </p>
     *
     * @param stopExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.StopExecutionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ExecutionDoesNotExistException The specified execution does not exist.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.StopExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StopExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopExecutionResponse> stopExecution(Consumer<StopExecutionRequest.Builder> stopExecutionRequest) {
        return stopExecution(StopExecutionRequest.builder().applyMutation(stopExecutionRequest).build());
    }

    /**
     * <p>
     * Add a tag to a Step Functions resource.
     * </p>
     * <p>
     * An array of key-value pairs. For more information, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
     * Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>, and <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM
     * Tags</a>.
     * </p>
     * <p>
     * Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>TooManyTagsException You've exceeded the number of tags allowed for a resource. See the <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html"> Limits Topic</a> in the Step
     *         Functions Developer Guide.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add a tag to a Step Functions resource.
     * </p>
     * <p>
     * An array of key-value pairs. For more information, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
     * Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>, and <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM
     * Tags</a>.
     * </p>
     * <p>
     * Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>TooManyTagsException You've exceeded the number of tags allowed for a resource. See the <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html"> Limits Topic</a> in the Step
     *         Functions Developer Guide.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Accepts the definition of a single state and executes it. You can test a state without creating a state machine
     * or updating an existing state machine. Using this API, you can test the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A state's <a href=
     * "https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-input-output-dataflow"
     * >input and output processing</a> data flow
     * </p>
     * </li>
     * <li>
     * <p>
     * An <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-services.html">Amazon Web Services
     * service integration</a> request and response
     * </p>
     * </li>
     * <li>
     * <p>
     * An <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-third-party-apis.html">HTTP Task</a>
     * request and response
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can call this API on only one state at a time. The states that you can test include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-task-state.html#task-types">
     * All Task types</a> except <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-activities.html">Activity</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-pass-state.html">Pass</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-wait-state.html">Wait</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-choice-state.html">Choice</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-succeed-state.html">Succeed</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-fail-state.html">Fail</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The <code>TestState</code> API assumes an IAM role which must contain the required IAM permissions for the
     * resources your state is accessing. For information about the permissions a state might need, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-permissions">IAM
     * permissions to test a state</a>.
     * </p>
     * <p>
     * The <code>TestState</code> API can run for up to five minutes. If the execution of a state exceeds this duration,
     * it fails with the <code>States.Timeout</code> error.
     * </p>
     * <p>
     * <code>TestState</code> doesn't support <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-activities.html">Activity tasks</a>,
     * <code>.sync</code> or <code>.waitForTaskToken</code> <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html">service integration
     * patterns</a>, <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-parallel-state.html"
     * >Parallel</a>, or <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html">Map</a> states.
     * </p>
     *
     * @param testStateRequest
     * @return A Java Future containing the result of the TestState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidDefinitionException The provided Amazon States Language definition is not valid.</li>
     *         <li>InvalidExecutionInputException The provided JSON input data is not valid.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.TestState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/TestState" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestStateResponse> testState(TestStateRequest testStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts the definition of a single state and executes it. You can test a state without creating a state machine
     * or updating an existing state machine. Using this API, you can test the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A state's <a href=
     * "https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-input-output-dataflow"
     * >input and output processing</a> data flow
     * </p>
     * </li>
     * <li>
     * <p>
     * An <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-services.html">Amazon Web Services
     * service integration</a> request and response
     * </p>
     * </li>
     * <li>
     * <p>
     * An <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-third-party-apis.html">HTTP Task</a>
     * request and response
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can call this API on only one state at a time. The states that you can test include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-task-state.html#task-types">
     * All Task types</a> except <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-activities.html">Activity</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-pass-state.html">Pass</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-wait-state.html">Wait</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-choice-state.html">Choice</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-succeed-state.html">Succeed</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-fail-state.html">Fail</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The <code>TestState</code> API assumes an IAM role which must contain the required IAM permissions for the
     * resources your state is accessing. For information about the permissions a state might need, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-permissions">IAM
     * permissions to test a state</a>.
     * </p>
     * <p>
     * The <code>TestState</code> API can run for up to five minutes. If the execution of a state exceeds this duration,
     * it fails with the <code>States.Timeout</code> error.
     * </p>
     * <p>
     * <code>TestState</code> doesn't support <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-activities.html">Activity tasks</a>,
     * <code>.sync</code> or <code>.waitForTaskToken</code> <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html">service integration
     * patterns</a>, <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-parallel-state.html"
     * >Parallel</a>, or <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html">Map</a> states.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestStateRequest.Builder} avoiding the need to
     * create one manually via {@link TestStateRequest#builder()}
     * </p>
     *
     * @param testStateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.TestStateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TestState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidDefinitionException The provided Amazon States Language definition is not valid.</li>
     *         <li>InvalidExecutionInputException The provided JSON input data is not valid.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.TestState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/TestState" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestStateResponse> testState(Consumer<TestStateRequest.Builder> testStateRequest) {
        return testState(TestStateRequest.builder().applyMutation(testStateRequest).build());
    }

    /**
     * <p>
     * Remove a tag from a Step Functions resource
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove a tag from a Step Functions resource
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an in-progress Map Run's configuration to include changes to the settings that control maximum
     * concurrency and Map Run failure.
     * </p>
     *
     * @param updateMapRunRequest
     * @return A Java Future containing the result of the UpdateMapRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.UpdateMapRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/UpdateMapRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateMapRunResponse> updateMapRun(UpdateMapRunRequest updateMapRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an in-progress Map Run's configuration to include changes to the settings that control maximum
     * concurrency and Map Run failure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMapRunRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateMapRunRequest#builder()}
     * </p>
     *
     * @param updateMapRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.UpdateMapRunRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateMapRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.UpdateMapRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/UpdateMapRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateMapRunResponse> updateMapRun(Consumer<UpdateMapRunRequest.Builder> updateMapRunRequest) {
        return updateMapRun(UpdateMapRunRequest.builder().applyMutation(updateMapRunRequest).build());
    }

    /**
     * <p>
     * Updates an existing state machine by modifying its <code>definition</code>, <code>roleArn</code>, or
     * <code>loggingConfiguration</code>. Running executions will continue to use the previous <code>definition</code>
     * and <code>roleArn</code>. You must include at least one of <code>definition</code> or <code>roleArn</code> or you
     * will receive a <code>MissingRequiredParameter</code> error.
     * </p>
     * <p>
     * A qualified state machine ARN refers to a <i>Distributed Map state</i> defined within a state machine. For
     * example, the qualified state machine ARN
     * <code>arn:partition:states:region:account-id:stateMachine:stateMachineName/mapStateLabel</code> refers to a
     * <i>Distributed Map state</i> with a label <code>mapStateLabel</code> in the state machine named
     * <code>stateMachineName</code>.
     * </p>
     * <p>
     * A qualified state machine ARN can either refer to a <i>Distributed Map state</i> defined within a state machine,
     * a version ARN, or an alias ARN.
     * </p>
     * <p>
     * The following are some examples of qualified and unqualified state machine ARNs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to a <i>Distributed Map state</i> with a label
     * <code>mapStateLabel</code> in a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a <i>Distributed Map state</i>, the request fails
     * with <code>ValidationException</code>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to an alias named <code>PROD</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine:PROD&gt;</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a version ARN or an alias ARN, the request starts
     * execution for that version or alias.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following unqualified state machine ARN refers to a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * After you update your state machine, you can set the <code>publish</code> parameter to <code>true</code> in the
     * same action to publish a new <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>. This
     * way, you can opt-in to strict versioning of your state machine.
     * </p>
     * <note>
     * <p>
     * Step Functions assigns monotonically increasing integers for state machine versions, starting at version number
     * 1.
     * </p>
     * </note> <note>
     * <p>
     * All <code>StartExecution</code> calls within a few seconds use the updated <code>definition</code> and
     * <code>roleArn</code>. Executions started immediately after you call <code>UpdateStateMachine</code> may use the
     * previous state machine <code>definition</code> and <code>roleArn</code>.
     * </p>
     * </note>
     *
     * @param updateStateMachineRequest
     * @return A Java Future containing the result of the UpdateStateMachine operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidDefinitionException The provided Amazon States Language definition is not valid.</li>
     *         <li>InvalidLoggingConfigurationException</li>
     *         <li>InvalidTracingConfigurationException Your <code>tracingConfiguration</code> key does not match, or
     *         <code>enabled</code> has not been set to <code>true</code> or <code>false</code>.</li>
     *         <li>MissingRequiredParameterException Request is missing a required parameter. This error occurs if both
     *         <code>definition</code> and <code>roleArn</code> are not specified.</li>
     *         <li>StateMachineDeletingException The specified state machine is being deleted.</li>
     *         <li>StateMachineDoesNotExistException The specified state machine does not exist.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</p>
     *         <p>
     *         HTTP Status Code: 402</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state. This error occurs
     *         when there're concurrent requests for <a>DeleteStateMachineVersion</a>,
     *         <a>PublishStateMachineVersion</a>, or <a>UpdateStateMachine</a> with the <code>publish</code> parameter
     *         set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.UpdateStateMachine
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/UpdateStateMachine" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateStateMachineResponse> updateStateMachine(UpdateStateMachineRequest updateStateMachineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing state machine by modifying its <code>definition</code>, <code>roleArn</code>, or
     * <code>loggingConfiguration</code>. Running executions will continue to use the previous <code>definition</code>
     * and <code>roleArn</code>. You must include at least one of <code>definition</code> or <code>roleArn</code> or you
     * will receive a <code>MissingRequiredParameter</code> error.
     * </p>
     * <p>
     * A qualified state machine ARN refers to a <i>Distributed Map state</i> defined within a state machine. For
     * example, the qualified state machine ARN
     * <code>arn:partition:states:region:account-id:stateMachine:stateMachineName/mapStateLabel</code> refers to a
     * <i>Distributed Map state</i> with a label <code>mapStateLabel</code> in the state machine named
     * <code>stateMachineName</code>.
     * </p>
     * <p>
     * A qualified state machine ARN can either refer to a <i>Distributed Map state</i> defined within a state machine,
     * a version ARN, or an alias ARN.
     * </p>
     * <p>
     * The following are some examples of qualified and unqualified state machine ARNs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to a <i>Distributed Map state</i> with a label
     * <code>mapStateLabel</code> in a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a <i>Distributed Map state</i>, the request fails
     * with <code>ValidationException</code>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to an alias named <code>PROD</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine:PROD&gt;</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a version ARN or an alias ARN, the request starts
     * execution for that version or alias.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following unqualified state machine ARN refers to a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * After you update your state machine, you can set the <code>publish</code> parameter to <code>true</code> in the
     * same action to publish a new <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>. This
     * way, you can opt-in to strict versioning of your state machine.
     * </p>
     * <note>
     * <p>
     * Step Functions assigns monotonically increasing integers for state machine versions, starting at version number
     * 1.
     * </p>
     * </note> <note>
     * <p>
     * All <code>StartExecution</code> calls within a few seconds use the updated <code>definition</code> and
     * <code>roleArn</code>. Executions started immediately after you call <code>UpdateStateMachine</code> may use the
     * previous state machine <code>definition</code> and <code>roleArn</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStateMachineRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateStateMachineRequest#builder()}
     * </p>
     *
     * @param updateStateMachineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.UpdateStateMachineRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateStateMachine operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidDefinitionException The provided Amazon States Language definition is not valid.</li>
     *         <li>InvalidLoggingConfigurationException</li>
     *         <li>InvalidTracingConfigurationException Your <code>tracingConfiguration</code> key does not match, or
     *         <code>enabled</code> has not been set to <code>true</code> or <code>false</code>.</li>
     *         <li>MissingRequiredParameterException Request is missing a required parameter. This error occurs if both
     *         <code>definition</code> and <code>roleArn</code> are not specified.</li>
     *         <li>StateMachineDeletingException The specified state machine is being deleted.</li>
     *         <li>StateMachineDoesNotExistException The specified state machine does not exist.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</p>
     *         <p>
     *         HTTP Status Code: 402</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state. This error occurs
     *         when there're concurrent requests for <a>DeleteStateMachineVersion</a>,
     *         <a>PublishStateMachineVersion</a>, or <a>UpdateStateMachine</a> with the <code>publish</code> parameter
     *         set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409</li>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.UpdateStateMachine
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/UpdateStateMachine" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateStateMachineResponse> updateStateMachine(
            Consumer<UpdateStateMachineRequest.Builder> updateStateMachineRequest) {
        return updateStateMachine(UpdateStateMachineRequest.builder().applyMutation(updateStateMachineRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> by
     * modifying its <code>description</code> or <code>routingConfiguration</code>.
     * </p>
     * <p>
     * You must specify at least one of the <code>description</code> or <code>routingConfiguration</code> parameters to
     * update a state machine alias.
     * </p>
     * <note>
     * <p>
     * <code>UpdateStateMachineAlias</code> is an idempotent API. Step Functions bases the idempotency check on the
     * <code>stateMachineAliasArn</code>, <code>description</code>, and <code>routingConfiguration</code> parameters.
     * Requests with the same parameters return an idempotent response.
     * </p>
     * </note> <note>
     * <p>
     * This operation is eventually consistent. All <a>StartExecution</a> requests made within a few seconds use the
     * latest alias configuration. Executions started immediately after calling <code>UpdateStateMachineAlias</code> may
     * use the previous routing configuration.
     * </p>
     * </note>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>CreateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DescribeStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineAliases</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteStateMachineAlias</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param updateStateMachineAliasRequest
     * @return A Java Future containing the result of the UpdateStateMachineAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state. This error occurs
     *         when there're concurrent requests for <a>DeleteStateMachineVersion</a>,
     *         <a>PublishStateMachineVersion</a>, or <a>UpdateStateMachine</a> with the <code>publish</code> parameter
     *         set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409</li>
     *         <li>StateMachineDeletingException The specified state machine is being deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.UpdateStateMachineAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/UpdateStateMachineAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateStateMachineAliasResponse> updateStateMachineAlias(
            UpdateStateMachineAliasRequest updateStateMachineAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> by
     * modifying its <code>description</code> or <code>routingConfiguration</code>.
     * </p>
     * <p>
     * You must specify at least one of the <code>description</code> or <code>routingConfiguration</code> parameters to
     * update a state machine alias.
     * </p>
     * <note>
     * <p>
     * <code>UpdateStateMachineAlias</code> is an idempotent API. Step Functions bases the idempotency check on the
     * <code>stateMachineAliasArn</code>, <code>description</code>, and <code>routingConfiguration</code> parameters.
     * Requests with the same parameters return an idempotent response.
     * </p>
     * </note> <note>
     * <p>
     * This operation is eventually consistent. All <a>StartExecution</a> requests made within a few seconds use the
     * latest alias configuration. Executions started immediately after calling <code>UpdateStateMachineAlias</code> may
     * use the previous routing configuration.
     * </p>
     * </note>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>CreateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DescribeStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineAliases</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteStateMachineAlias</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStateMachineAliasRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateStateMachineAliasRequest#builder()}
     * </p>
     *
     * @param updateStateMachineAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.UpdateStateMachineAliasRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateStateMachineAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidArnException The provided Amazon Resource Name (ARN) is not valid.</li>
     *         <li>ResourceNotFoundException Could not find the referenced resource.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state. This error occurs
     *         when there're concurrent requests for <a>DeleteStateMachineVersion</a>,
     *         <a>PublishStateMachineVersion</a>, or <a>UpdateStateMachine</a> with the <code>publish</code> parameter
     *         set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409</li>
     *         <li>StateMachineDeletingException The specified state machine is being deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SfnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SfnAsyncClient.UpdateStateMachineAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/UpdateStateMachineAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateStateMachineAliasResponse> updateStateMachineAlias(
            Consumer<UpdateStateMachineAliasRequest.Builder> updateStateMachineAliasRequest) {
        return updateStateMachineAlias(UpdateStateMachineAliasRequest.builder().applyMutation(updateStateMachineAliasRequest)
                .build());
    }

    @Override
    default SfnServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link SfnAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SfnAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SfnAsyncClient}.
     */
    static SfnAsyncClientBuilder builder() {
        return new DefaultSfnAsyncClientBuilder();
    }
}
