/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InspectionLevel {
    INFO("INFO"),
    DEBUG("DEBUG"),
    TRACE("TRACE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InspectionLevel> VALUE_MAP;
    private final String value;

    private InspectionLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InspectionLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InspectionLevel> knownValues() {
        EnumSet<InspectionLevel> knownValues = EnumSet.allOf(InspectionLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InspectionLevel.class, InspectionLevel::toString);
    }
}

