/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.shield.ShieldClient;
import software.amazon.awssdk.services.shield.internal.UserAgentUtils;
import software.amazon.awssdk.services.shield.model.ListProtectionGroupsRequest;
import software.amazon.awssdk.services.shield.model.ListProtectionGroupsResponse;

public class ListProtectionGroupsIterable
implements SdkIterable<ListProtectionGroupsResponse> {
    private final ShieldClient client;
    private final ListProtectionGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProtectionGroupsIterable(ShieldClient client, ListProtectionGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProtectionGroupsResponseFetcher();
    }

    public Iterator<ListProtectionGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListProtectionGroupsResponseFetcher
    implements SyncPageFetcher<ListProtectionGroupsResponse> {
        private ListProtectionGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListProtectionGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProtectionGroupsResponse nextPage(ListProtectionGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListProtectionGroupsIterable.this.client.listProtectionGroups(ListProtectionGroupsIterable.this.firstRequest);
            }
            return ListProtectionGroupsIterable.this.client.listProtectionGroups((ListProtectionGroupsRequest)((Object)ListProtectionGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

