/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signin.auth;

import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProviderFactory;
import software.amazon.awssdk.auth.credentials.ProfileProviderCredentialsContext;
import software.amazon.awssdk.profiles.Profile;
import software.amazon.awssdk.services.signin.SigninClient;
import software.amazon.awssdk.services.signin.auth.LoginCredentialsProvider;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkProtectedApi
public class LoginProfileCredentialsProviderFactory
implements ProfileCredentialsProviderFactory {
    public AwsCredentialsProvider create(ProfileProviderCredentialsContext profileProviderCredentialsContext) {
        return new LoginProfileCredentialsProvider(profileProviderCredentialsContext);
    }

    private static class LoginProfileCredentialsProvider
    implements AwsCredentialsProvider,
    SdkAutoCloseable {
        private final LoginCredentialsProvider credentialsProvider;
        private final SigninClient signinClient;

        private LoginProfileCredentialsProvider(ProfileProviderCredentialsContext credentialsContext) {
            Profile profile = credentialsContext.profile();
            String loginSession = (String)profile.property("login_session").orElseThrow(() -> new IllegalArgumentException("login_session property is required"));
            this.signinClient = SigninClient.create();
            this.credentialsProvider = LoginCredentialsProvider.builder().loginSession(loginSession).signinClient(this.signinClient).sourceChain(credentialsContext.sourceChain()).build();
        }

        public AwsCredentials resolveCredentials() {
            return this.credentialsProvider.resolveCredentials();
        }

        public void close() {
            IoUtils.closeQuietly((AutoCloseable)((Object)this.credentialsProvider), null);
            IoUtils.closeQuietly((AutoCloseable)((Object)this.signinClient), null);
        }
    }
}

