/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.snowball.SnowballClient;
import software.amazon.awssdk.services.snowball.SnowballServiceClientConfiguration;
import software.amazon.awssdk.services.snowball.internal.SnowballServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.snowball.model.CancelClusterRequest;
import software.amazon.awssdk.services.snowball.model.CancelClusterResponse;
import software.amazon.awssdk.services.snowball.model.CancelJobRequest;
import software.amazon.awssdk.services.snowball.model.CancelJobResponse;
import software.amazon.awssdk.services.snowball.model.ClusterLimitExceededException;
import software.amazon.awssdk.services.snowball.model.ConflictException;
import software.amazon.awssdk.services.snowball.model.CreateAddressRequest;
import software.amazon.awssdk.services.snowball.model.CreateAddressResponse;
import software.amazon.awssdk.services.snowball.model.CreateClusterRequest;
import software.amazon.awssdk.services.snowball.model.CreateClusterResponse;
import software.amazon.awssdk.services.snowball.model.CreateJobRequest;
import software.amazon.awssdk.services.snowball.model.CreateJobResponse;
import software.amazon.awssdk.services.snowball.model.CreateLongTermPricingRequest;
import software.amazon.awssdk.services.snowball.model.CreateLongTermPricingResponse;
import software.amazon.awssdk.services.snowball.model.CreateReturnShippingLabelRequest;
import software.amazon.awssdk.services.snowball.model.CreateReturnShippingLabelResponse;
import software.amazon.awssdk.services.snowball.model.DescribeAddressRequest;
import software.amazon.awssdk.services.snowball.model.DescribeAddressResponse;
import software.amazon.awssdk.services.snowball.model.DescribeAddressesRequest;
import software.amazon.awssdk.services.snowball.model.DescribeAddressesResponse;
import software.amazon.awssdk.services.snowball.model.DescribeClusterRequest;
import software.amazon.awssdk.services.snowball.model.DescribeClusterResponse;
import software.amazon.awssdk.services.snowball.model.DescribeJobRequest;
import software.amazon.awssdk.services.snowball.model.DescribeJobResponse;
import software.amazon.awssdk.services.snowball.model.DescribeReturnShippingLabelRequest;
import software.amazon.awssdk.services.snowball.model.DescribeReturnShippingLabelResponse;
import software.amazon.awssdk.services.snowball.model.Ec2RequestFailedException;
import software.amazon.awssdk.services.snowball.model.GetJobManifestRequest;
import software.amazon.awssdk.services.snowball.model.GetJobManifestResponse;
import software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeRequest;
import software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeResponse;
import software.amazon.awssdk.services.snowball.model.GetSnowballUsageRequest;
import software.amazon.awssdk.services.snowball.model.GetSnowballUsageResponse;
import software.amazon.awssdk.services.snowball.model.GetSoftwareUpdatesRequest;
import software.amazon.awssdk.services.snowball.model.GetSoftwareUpdatesResponse;
import software.amazon.awssdk.services.snowball.model.InvalidAddressException;
import software.amazon.awssdk.services.snowball.model.InvalidInputCombinationException;
import software.amazon.awssdk.services.snowball.model.InvalidJobStateException;
import software.amazon.awssdk.services.snowball.model.InvalidNextTokenException;
import software.amazon.awssdk.services.snowball.model.InvalidResourceException;
import software.amazon.awssdk.services.snowball.model.KmsRequestFailedException;
import software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest;
import software.amazon.awssdk.services.snowball.model.ListClusterJobsResponse;
import software.amazon.awssdk.services.snowball.model.ListClustersRequest;
import software.amazon.awssdk.services.snowball.model.ListClustersResponse;
import software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest;
import software.amazon.awssdk.services.snowball.model.ListCompatibleImagesResponse;
import software.amazon.awssdk.services.snowball.model.ListJobsRequest;
import software.amazon.awssdk.services.snowball.model.ListJobsResponse;
import software.amazon.awssdk.services.snowball.model.ListLongTermPricingRequest;
import software.amazon.awssdk.services.snowball.model.ListLongTermPricingResponse;
import software.amazon.awssdk.services.snowball.model.ListPickupLocationsRequest;
import software.amazon.awssdk.services.snowball.model.ListPickupLocationsResponse;
import software.amazon.awssdk.services.snowball.model.ListServiceVersionsRequest;
import software.amazon.awssdk.services.snowball.model.ListServiceVersionsResponse;
import software.amazon.awssdk.services.snowball.model.ReturnShippingLabelAlreadyExistsException;
import software.amazon.awssdk.services.snowball.model.SnowballException;
import software.amazon.awssdk.services.snowball.model.UnsupportedAddressException;
import software.amazon.awssdk.services.snowball.model.UpdateClusterRequest;
import software.amazon.awssdk.services.snowball.model.UpdateClusterResponse;
import software.amazon.awssdk.services.snowball.model.UpdateJobRequest;
import software.amazon.awssdk.services.snowball.model.UpdateJobResponse;
import software.amazon.awssdk.services.snowball.model.UpdateJobShipmentStateRequest;
import software.amazon.awssdk.services.snowball.model.UpdateJobShipmentStateResponse;
import software.amazon.awssdk.services.snowball.model.UpdateLongTermPricingRequest;
import software.amazon.awssdk.services.snowball.model.UpdateLongTermPricingResponse;
import software.amazon.awssdk.services.snowball.transform.CancelClusterRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CancelJobRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateAddressRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateJobRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateLongTermPricingRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateReturnShippingLabelRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeAddressRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeAddressesRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeClusterRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeJobRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeReturnShippingLabelRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.GetJobManifestRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.GetJobUnlockCodeRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.GetSnowballUsageRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.GetSoftwareUpdatesRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.ListClusterJobsRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.ListClustersRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.ListCompatibleImagesRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.ListLongTermPricingRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.ListPickupLocationsRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.ListServiceVersionsRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.UpdateClusterRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.UpdateJobRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.UpdateJobShipmentStateRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.UpdateLongTermPricingRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultSnowballClient
implements SnowballClient {
    private static final Logger log = Logger.loggerFor(DefaultSnowballClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSnowballClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Snowball#2.41.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelClusterResponse cancelCluster(CancelClusterRequest cancelClusterRequest) throws KmsRequestFailedException, InvalidJobStateException, InvalidResourceException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, cancelClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelCluster");
            CancelClusterResponse cancelClusterResponse = (CancelClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$cancelCluster$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelJobResponse cancelJob(CancelJobRequest cancelJobRequest) throws InvalidResourceException, InvalidJobStateException, KmsRequestFailedException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, cancelJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelJob");
            CancelJobResponse cancelJobResponse = (CancelJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$cancelJob$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAddressResponse createAddress(CreateAddressRequest createAddressRequest) throws InvalidAddressException, UnsupportedAddressException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAddressResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAddressRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, createAddressRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAddress");
            CreateAddressResponse createAddressResponse = (CreateAddressResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAddress").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAddressRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAddressRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAddressResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$createAddress$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws InvalidResourceException, KmsRequestFailedException, InvalidInputCombinationException, Ec2RequestFailedException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, createClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCluster");
            CreateClusterResponse createClusterResponse = (CreateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$createCluster$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateJobResponse createJob(CreateJobRequest createJobRequest) throws InvalidResourceException, KmsRequestFailedException, InvalidInputCombinationException, ClusterLimitExceededException, Ec2RequestFailedException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, createJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateJob");
            CreateJobResponse createJobResponse = (CreateJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$createJob$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLongTermPricingResponse createLongTermPricing(CreateLongTermPricingRequest createLongTermPricingRequest) throws InvalidResourceException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLongTermPricingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLongTermPricingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, createLongTermPricingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLongTermPricing");
            CreateLongTermPricingResponse createLongTermPricingResponse = (CreateLongTermPricingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLongTermPricing").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createLongTermPricingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLongTermPricingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createLongTermPricingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$createLongTermPricing$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateReturnShippingLabelResponse createReturnShippingLabel(CreateReturnShippingLabelRequest createReturnShippingLabelRequest) throws InvalidResourceException, InvalidJobStateException, InvalidInputCombinationException, ConflictException, ReturnShippingLabelAlreadyExistsException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateReturnShippingLabelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createReturnShippingLabelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, createReturnShippingLabelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReturnShippingLabel");
            CreateReturnShippingLabelResponse createReturnShippingLabelResponse = (CreateReturnShippingLabelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReturnShippingLabel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createReturnShippingLabelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateReturnShippingLabelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createReturnShippingLabelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$createReturnShippingLabel$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAddressResponse describeAddress(DescribeAddressRequest describeAddressRequest) throws InvalidResourceException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAddressResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAddressRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, describeAddressRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAddress");
            DescribeAddressResponse describeAddressResponse = (DescribeAddressResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAddress").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAddressRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAddressRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAddressResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$describeAddress$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAddressesResponse describeAddresses(DescribeAddressesRequest describeAddressesRequest) throws InvalidResourceException, InvalidNextTokenException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAddressesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAddressesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, describeAddressesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAddresses");
            DescribeAddressesResponse describeAddressesResponse = (DescribeAddressesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAddresses").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAddressesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAddressesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAddressesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$describeAddresses$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeClusterResponse describeCluster(DescribeClusterRequest describeClusterRequest) throws InvalidResourceException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, describeClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCluster");
            DescribeClusterResponse describeClusterResponse = (DescribeClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$describeCluster$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeJobResponse describeJob(DescribeJobRequest describeJobRequest) throws InvalidResourceException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, describeJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeJob");
            DescribeJobResponse describeJobResponse = (DescribeJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$describeJob$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReturnShippingLabelResponse describeReturnShippingLabel(DescribeReturnShippingLabelRequest describeReturnShippingLabelRequest) throws InvalidResourceException, InvalidJobStateException, ConflictException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReturnShippingLabelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReturnShippingLabelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, describeReturnShippingLabelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReturnShippingLabel");
            DescribeReturnShippingLabelResponse describeReturnShippingLabelResponse = (DescribeReturnShippingLabelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReturnShippingLabel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeReturnShippingLabelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReturnShippingLabelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReturnShippingLabelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$describeReturnShippingLabel$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetJobManifestResponse getJobManifest(GetJobManifestRequest getJobManifestRequest) throws InvalidResourceException, InvalidJobStateException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJobManifestResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getJobManifestRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, getJobManifestRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJobManifest");
            GetJobManifestResponse getJobManifestResponse = (GetJobManifestResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJobManifest").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getJobManifestRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetJobManifestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getJobManifestResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$getJobManifest$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetJobUnlockCodeResponse getJobUnlockCode(GetJobUnlockCodeRequest getJobUnlockCodeRequest) throws InvalidResourceException, InvalidJobStateException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJobUnlockCodeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getJobUnlockCodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, getJobUnlockCodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJobUnlockCode");
            GetJobUnlockCodeResponse getJobUnlockCodeResponse = (GetJobUnlockCodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJobUnlockCode").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getJobUnlockCodeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetJobUnlockCodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getJobUnlockCodeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$getJobUnlockCode$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSnowballUsageResponse getSnowballUsage(GetSnowballUsageRequest getSnowballUsageRequest) throws AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSnowballUsageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSnowballUsageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, getSnowballUsageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSnowballUsage");
            GetSnowballUsageResponse getSnowballUsageResponse = (GetSnowballUsageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSnowballUsage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSnowballUsageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSnowballUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSnowballUsageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$getSnowballUsage$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSoftwareUpdatesResponse getSoftwareUpdates(GetSoftwareUpdatesRequest getSoftwareUpdatesRequest) throws InvalidResourceException, InvalidJobStateException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSoftwareUpdatesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSoftwareUpdatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, getSoftwareUpdatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSoftwareUpdates");
            GetSoftwareUpdatesResponse getSoftwareUpdatesResponse = (GetSoftwareUpdatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSoftwareUpdates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSoftwareUpdatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSoftwareUpdatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSoftwareUpdatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$getSoftwareUpdates$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListClusterJobsResponse listClusterJobs(ListClusterJobsRequest listClusterJobsRequest) throws InvalidResourceException, InvalidNextTokenException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListClusterJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listClusterJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, listClusterJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListClusterJobs");
            ListClusterJobsResponse listClusterJobsResponse = (ListClusterJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListClusterJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listClusterJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListClusterJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listClusterJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$listClusterJobs$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListClustersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listClustersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, listClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListClusters");
            ListClustersResponse listClustersResponse = (ListClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListClusters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listClustersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListClustersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listClustersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$listClusters$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCompatibleImagesResponse listCompatibleImages(ListCompatibleImagesRequest listCompatibleImagesRequest) throws InvalidNextTokenException, Ec2RequestFailedException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCompatibleImagesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCompatibleImagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, listCompatibleImagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCompatibleImages");
            ListCompatibleImagesResponse listCompatibleImagesResponse = (ListCompatibleImagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCompatibleImages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listCompatibleImagesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCompatibleImagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCompatibleImagesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$listCompatibleImages$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, listJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListJobs");
            ListJobsResponse listJobsResponse = (ListJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$listJobs$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLongTermPricingResponse listLongTermPricing(ListLongTermPricingRequest listLongTermPricingRequest) throws InvalidResourceException, InvalidNextTokenException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLongTermPricingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLongTermPricingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, listLongTermPricingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLongTermPricing");
            ListLongTermPricingResponse listLongTermPricingResponse = (ListLongTermPricingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLongTermPricing").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listLongTermPricingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLongTermPricingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLongTermPricingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$listLongTermPricing$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPickupLocationsResponse listPickupLocations(ListPickupLocationsRequest listPickupLocationsRequest) throws InvalidResourceException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPickupLocationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPickupLocationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, listPickupLocationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPickupLocations");
            ListPickupLocationsResponse listPickupLocationsResponse = (ListPickupLocationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPickupLocations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPickupLocationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPickupLocationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPickupLocationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$listPickupLocations$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServiceVersionsResponse listServiceVersions(ListServiceVersionsRequest listServiceVersionsRequest) throws InvalidNextTokenException, InvalidResourceException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServiceVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listServiceVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, listServiceVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServiceVersions");
            ListServiceVersionsResponse listServiceVersionsResponse = (ListServiceVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServiceVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listServiceVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServiceVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServiceVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$listServiceVersions$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateClusterResponse updateCluster(UpdateClusterRequest updateClusterRequest) throws InvalidResourceException, InvalidJobStateException, KmsRequestFailedException, InvalidInputCombinationException, Ec2RequestFailedException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, updateClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCluster");
            UpdateClusterResponse updateClusterResponse = (UpdateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$updateCluster$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateJobResponse updateJob(UpdateJobRequest updateJobRequest) throws InvalidResourceException, InvalidJobStateException, KmsRequestFailedException, InvalidInputCombinationException, ClusterLimitExceededException, Ec2RequestFailedException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, updateJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateJob");
            UpdateJobResponse updateJobResponse = (UpdateJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$updateJob$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateJobShipmentStateResponse updateJobShipmentState(UpdateJobShipmentStateRequest updateJobShipmentStateRequest) throws InvalidResourceException, InvalidJobStateException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateJobShipmentStateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateJobShipmentStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, updateJobShipmentStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateJobShipmentState");
            UpdateJobShipmentStateResponse updateJobShipmentStateResponse = (UpdateJobShipmentStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateJobShipmentState").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateJobShipmentStateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateJobShipmentStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateJobShipmentStateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$updateJobShipmentState$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateLongTermPricingResponse updateLongTermPricing(UpdateLongTermPricingRequest updateLongTermPricingRequest) throws InvalidResourceException, AwsServiceException, SdkClientException, SnowballException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLongTermPricingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "ReturnShippingLabelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                }
                case "UnsupportedAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                }
                case "Ec2RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "KMSRequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                }
                case "InvalidAddressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                }
                case "ClusterLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                }
                case "InvalidInputCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateLongTermPricingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballClient.resolveMetricPublishers(clientConfiguration, updateLongTermPricingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLongTermPricing");
            UpdateLongTermPricingResponse updateLongTermPricingResponse = (UpdateLongTermPricingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLongTermPricing").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateLongTermPricingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateLongTermPricingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateLongTermPricingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnowballClient.lambda$updateLongTermPricing$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "snowball";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        SnowballServiceClientConfigurationBuilder serviceConfigBuilder = new SnowballServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SnowballException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final SnowballServiceClientConfiguration serviceClientConfiguration() {
        return new SnowballServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateLongTermPricing$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateJobShipmentState$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateJob$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCluster$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServiceVersions$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPickupLocations$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLongTermPricing$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listJobs$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCompatibleImages$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listClusters$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listClusterJobs$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSoftwareUpdates$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSnowballUsage$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJobUnlockCode$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJobManifest$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReturnShippingLabel$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeJob$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCluster$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAddresses$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAddress$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createReturnShippingLabel$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLongTermPricing$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createJob$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCluster$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAddress$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelJob$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelCluster$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

