/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.socialmessaging.model.SupportedAppsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LibraryTemplateButtonList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LibraryTemplateButtonList> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(LibraryTemplateButtonList.getter(LibraryTemplateButtonList::type)).setter(LibraryTemplateButtonList.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(LibraryTemplateButtonList.getter(LibraryTemplateButtonList::text)).setter(LibraryTemplateButtonList.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("phoneNumber").getter(LibraryTemplateButtonList.getter(LibraryTemplateButtonList::phoneNumber)).setter(LibraryTemplateButtonList.setter(Builder::phoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phoneNumber").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(LibraryTemplateButtonList.getter(LibraryTemplateButtonList::url)).setter(LibraryTemplateButtonList.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final SdkField<String> OTP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("otpType").getter(LibraryTemplateButtonList.getter(LibraryTemplateButtonList::otpType)).setter(LibraryTemplateButtonList.setter(Builder::otpType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otpType").build()}).build();
    private static final SdkField<Boolean> ZERO_TAP_TERMS_ACCEPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("zeroTapTermsAccepted").getter(LibraryTemplateButtonList.getter(LibraryTemplateButtonList::zeroTapTermsAccepted)).setter(LibraryTemplateButtonList.setter(Builder::zeroTapTermsAccepted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zeroTapTermsAccepted").build()}).build();
    private static final SdkField<List<Map<String, String>>> SUPPORTED_APPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedApps").getter(LibraryTemplateButtonList.getter(LibraryTemplateButtonList::supportedApps)).setter(LibraryTemplateButtonList.setter(Builder::supportedApps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedApps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TEXT_FIELD, PHONE_NUMBER_FIELD, URL_FIELD, OTP_TYPE_FIELD, ZERO_TAP_TERMS_ACCEPTED_FIELD, SUPPORTED_APPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LibraryTemplateButtonList.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String text;
    private final String phoneNumber;
    private final String url;
    private final String otpType;
    private final Boolean zeroTapTermsAccepted;
    private final List<Map<String, String>> supportedApps;

    private LibraryTemplateButtonList(BuilderImpl builder) {
        this.type = builder.type;
        this.text = builder.text;
        this.phoneNumber = builder.phoneNumber;
        this.url = builder.url;
        this.otpType = builder.otpType;
        this.zeroTapTermsAccepted = builder.zeroTapTermsAccepted;
        this.supportedApps = builder.supportedApps;
    }

    public final String type() {
        return this.type;
    }

    public final String text() {
        return this.text;
    }

    public final String phoneNumber() {
        return this.phoneNumber;
    }

    public final String url() {
        return this.url;
    }

    public final String otpType() {
        return this.otpType;
    }

    public final Boolean zeroTapTermsAccepted() {
        return this.zeroTapTermsAccepted;
    }

    public final boolean hasSupportedApps() {
        return this.supportedApps != null && !(this.supportedApps instanceof SdkAutoConstructList);
    }

    public final List<Map<String, String>> supportedApps() {
        return this.supportedApps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.otpType());
        hashCode = 31 * hashCode + Objects.hashCode(this.zeroTapTermsAccepted());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedApps() ? this.supportedApps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LibraryTemplateButtonList)) {
            return false;
        }
        LibraryTemplateButtonList other = (LibraryTemplateButtonList)obj;
        return Objects.equals(this.type(), other.type()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.phoneNumber(), other.phoneNumber()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.otpType(), other.otpType()) && Objects.equals(this.zeroTapTermsAccepted(), other.zeroTapTermsAccepted()) && this.hasSupportedApps() == other.hasSupportedApps() && Objects.equals(this.supportedApps(), other.supportedApps());
    }

    public final String toString() {
        return ToString.builder((String)"LibraryTemplateButtonList").add("Type", (Object)this.type()).add("Text", (Object)this.text()).add("PhoneNumber", (Object)this.phoneNumber()).add("Url", (Object)this.url()).add("OtpType", (Object)this.otpType()).add("ZeroTapTermsAccepted", (Object)this.zeroTapTermsAccepted()).add("SupportedApps", this.hasSupportedApps() ? this.supportedApps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "phoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "otpType": {
                return Optional.ofNullable(clazz.cast(this.otpType()));
            }
            case "zeroTapTermsAccepted": {
                return Optional.ofNullable(clazz.cast(this.zeroTapTermsAccepted()));
            }
            case "supportedApps": {
                return Optional.ofNullable(clazz.cast(this.supportedApps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("text", TEXT_FIELD);
        map.put("phoneNumber", PHONE_NUMBER_FIELD);
        map.put("url", URL_FIELD);
        map.put("otpType", OTP_TYPE_FIELD);
        map.put("zeroTapTermsAccepted", ZERO_TAP_TERMS_ACCEPTED_FIELD);
        map.put("supportedApps", SUPPORTED_APPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LibraryTemplateButtonList, T> g) {
        return obj -> g.apply((LibraryTemplateButtonList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String text;
        private String phoneNumber;
        private String url;
        private String otpType;
        private Boolean zeroTapTermsAccepted;
        private List<Map<String, String>> supportedApps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LibraryTemplateButtonList model) {
            this.type(model.type);
            this.text(model.text);
            this.phoneNumber(model.phoneNumber);
            this.url(model.url);
            this.otpType(model.otpType);
            this.zeroTapTermsAccepted(model.zeroTapTermsAccepted);
            this.supportedApps(model.supportedApps);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getOtpType() {
            return this.otpType;
        }

        public final void setOtpType(String otpType) {
            this.otpType = otpType;
        }

        @Override
        public final Builder otpType(String otpType) {
            this.otpType = otpType;
            return this;
        }

        public final Boolean getZeroTapTermsAccepted() {
            return this.zeroTapTermsAccepted;
        }

        public final void setZeroTapTermsAccepted(Boolean zeroTapTermsAccepted) {
            this.zeroTapTermsAccepted = zeroTapTermsAccepted;
        }

        @Override
        public final Builder zeroTapTermsAccepted(Boolean zeroTapTermsAccepted) {
            this.zeroTapTermsAccepted = zeroTapTermsAccepted;
            return this;
        }

        public final Collection<? extends Map<String, String>> getSupportedApps() {
            if (this.supportedApps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedApps;
        }

        public final void setSupportedApps(Collection<? extends Map<String, String>> supportedApps) {
            this.supportedApps = SupportedAppsCopier.copy(supportedApps);
        }

        @Override
        public final Builder supportedApps(Collection<? extends Map<String, String>> supportedApps) {
            this.supportedApps = SupportedAppsCopier.copy(supportedApps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedApps(Map<String, String> ... supportedApps) {
            this.supportedApps(Arrays.asList(supportedApps));
            return this;
        }

        public LibraryTemplateButtonList build() {
            return new LibraryTemplateButtonList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LibraryTemplateButtonList> {
        public Builder type(String var1);

        public Builder text(String var1);

        public Builder phoneNumber(String var1);

        public Builder url(String var1);

        public Builder otpType(String var1);

        public Builder zeroTapTermsAccepted(Boolean var1);

        public Builder supportedApps(Collection<? extends Map<String, String>> var1);

        public Builder supportedApps(Map<String, String> ... var1);
    }
}

