/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.internal.batchmanager;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.sqs.internal.batchmanager.BatchingExecutionContext;
import software.amazon.awssdk.services.sqs.internal.batchmanager.RequestBatchBuffer;
import software.amazon.awssdk.services.sqs.internal.batchmanager.RequestBatchConfiguration;

@SdkInternalApi
public final class BatchingMap<RequestT, ResponseT> {
    private final int maxBatchKeys;
    private final int maxBatchBytesSize;
    private final int maxBatchSize;
    private final int maxBufferSize;
    private final Map<String, RequestBatchBuffer<RequestT, ResponseT>> batchContextMap = new ConcurrentHashMap<String, RequestBatchBuffer<RequestT, ResponseT>>();

    public BatchingMap(RequestBatchConfiguration overrideConfiguration) {
        this.maxBatchKeys = overrideConfiguration.maxBatchKeys();
        this.maxBatchBytesSize = overrideConfiguration.maxBatchBytesSize();
        this.maxBatchSize = overrideConfiguration.maxBatchItems();
        this.maxBufferSize = overrideConfiguration.maxBufferSize();
    }

    public void put(String batchKey, Supplier<ScheduledFuture<?>> scheduleFlush, RequestT request, CompletableFuture<ResponseT> response) throws IllegalStateException {
        this.batchContextMap.computeIfAbsent(batchKey, k -> {
            if (this.batchContextMap.size() == this.maxBatchKeys) {
                throw new IllegalStateException("Reached MaxBatchKeys of: " + this.maxBatchKeys);
            }
            return new RequestBatchBuffer((ScheduledFuture)scheduleFlush.get(), this.maxBatchSize, this.maxBatchBytesSize, this.maxBufferSize);
        }).put(request, response);
    }

    public boolean contains(String batchKey) {
        return this.batchContextMap.containsKey(batchKey);
    }

    public void cancelAndReplaceScheduledFlush(String batchKey, ScheduledFuture<?> scheduledFlush) {
        this.batchContextMap.get(batchKey).cancelAndReplaceScheduledFlush(scheduledFlush);
    }

    public void forEach(BiConsumer<String, RequestBatchBuffer<RequestT, ResponseT>> action) {
        this.batchContextMap.forEach(action);
    }

    public Map<String, BatchingExecutionContext<RequestT, ResponseT>> flushableRequests(String batchKey) {
        return this.batchContextMap.get(batchKey).flushableRequests();
    }

    public Map<String, BatchingExecutionContext<RequestT, ResponseT>> flushableRequestsOnByteLimitBeforeAdd(String batchKey, RequestT request) {
        return this.batchContextMap.get(batchKey).flushableRequestsOnByteLimitBeforeAdd(request);
    }

    public Map<String, BatchingExecutionContext<RequestT, ResponseT>> flushableScheduledRequests(String batchKey, int maxBatchItems) {
        return this.batchContextMap.get(batchKey).flushableScheduledRequests(maxBatchItems);
    }

    public void cancelScheduledFlush(String batchKey) {
        this.batchContextMap.get(batchKey).cancelScheduledFlush();
    }

    public void clear() {
        for (Map.Entry<String, RequestBatchBuffer<RequestT, ResponseT>> entry : this.batchContextMap.entrySet()) {
            String key = entry.getKey();
            entry.getValue().clear();
            this.batchContextMap.remove(key);
        }
        this.batchContextMap.clear();
    }
}

