/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NodeAttributeName {
    AGENT_VERSION("AgentVersion"),
    PLATFORM_NAME("PlatformName"),
    PLATFORM_TYPE("PlatformType"),
    PLATFORM_VERSION("PlatformVersion"),
    REGION("Region"),
    RESOURCE_TYPE("ResourceType"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NodeAttributeName> VALUE_MAP;
    private final String value;

    private NodeAttributeName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NodeAttributeName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NodeAttributeName> knownValues() {
        EnumSet<NodeAttributeName> knownValues = EnumSet.allOf(NodeAttributeName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NodeAttributeName.class, NodeAttributeName::toString);
    }
}

