/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse;
import software.amazon.awssdk.services.ssm.model.PatchGroupPatchBaselineMapping;

public class DescribePatchGroupsPublisher
implements SdkPublisher<DescribePatchGroupsResponse> {
    private final SsmAsyncClient client;
    private final DescribePatchGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribePatchGroupsPublisher(SsmAsyncClient client, DescribePatchGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribePatchGroupsPublisher(SsmAsyncClient client, DescribePatchGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribePatchGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribePatchGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PatchGroupPatchBaselineMapping> mappings() {
        return this.flatMapIterable(response -> response.mappings());
    }

    private class DescribePatchGroupsResponseFetcher
    implements AsyncPageFetcher<DescribePatchGroupsResponse> {
        private DescribePatchGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribePatchGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribePatchGroupsResponse> nextPage(DescribePatchGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribePatchGroupsPublisher.this.client.describePatchGroups(DescribePatchGroupsPublisher.this.firstRequest);
            }
            return DescribePatchGroupsPublisher.this.client.describePatchGroups((DescribePatchGroupsRequest)((Object)DescribePatchGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

