/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmsap.model.OperationIdListCopier;
import software.amazon.awssdk.services.ssmsap.model.SsmSapResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApplicationSettingsResponse
extends SsmSapResponse
implements ToCopyableBuilder<Builder, UpdateApplicationSettingsResponse> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(UpdateApplicationSettingsResponse.getter(UpdateApplicationSettingsResponse::message)).setter(UpdateApplicationSettingsResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<List<String>> OPERATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OperationIds").getter(UpdateApplicationSettingsResponse.getter(UpdateApplicationSettingsResponse::operationIds)).setter(UpdateApplicationSettingsResponse.setter(Builder::operationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, OPERATION_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateApplicationSettingsResponse.memberNameToFieldInitializer();
    private final String message;
    private final List<String> operationIds;

    private UpdateApplicationSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.message = builder.message;
        this.operationIds = builder.operationIds;
    }

    public final String message() {
        return this.message;
    }

    public final boolean hasOperationIds() {
        return this.operationIds != null && !(this.operationIds instanceof SdkAutoConstructList);
    }

    public final List<String> operationIds() {
        return this.operationIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperationIds() ? this.operationIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationSettingsResponse)) {
            return false;
        }
        UpdateApplicationSettingsResponse other = (UpdateApplicationSettingsResponse)((Object)obj);
        return Objects.equals(this.message(), other.message()) && this.hasOperationIds() == other.hasOperationIds() && Objects.equals(this.operationIds(), other.operationIds());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateApplicationSettingsResponse").add("Message", (Object)this.message()).add("OperationIds", this.hasOperationIds() ? this.operationIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "OperationIds": {
                return Optional.ofNullable(clazz.cast(this.operationIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Message", MESSAGE_FIELD);
        map.put("OperationIds", OPERATION_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationSettingsResponse, T> g) {
        return obj -> g.apply((UpdateApplicationSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmSapResponse.BuilderImpl
    implements Builder {
        private String message;
        private List<String> operationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationSettingsResponse model) {
            super(model);
            this.message(model.message);
            this.operationIds(model.operationIds);
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Collection<String> getOperationIds() {
            if (this.operationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.operationIds;
        }

        public final void setOperationIds(Collection<String> operationIds) {
            this.operationIds = OperationIdListCopier.copy(operationIds);
        }

        @Override
        public final Builder operationIds(Collection<String> operationIds) {
            this.operationIds = OperationIdListCopier.copy(operationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationIds(String ... operationIds) {
            this.operationIds(Arrays.asList(operationIds));
            return this;
        }

        @Override
        public UpdateApplicationSettingsResponse build() {
            return new UpdateApplicationSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmSapResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApplicationSettingsResponse> {
        public Builder message(String var1);

        public Builder operationIds(Collection<String> var1);

        public Builder operationIds(String ... var1);
    }
}

