/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConfigurationCheckType {
    SAP_CHECK_01("SAP_CHECK_01"),
    SAP_CHECK_02("SAP_CHECK_02"),
    SAP_CHECK_03("SAP_CHECK_03"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConfigurationCheckType> VALUE_MAP;
    private final String value;

    private ConfigurationCheckType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConfigurationCheckType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConfigurationCheckType> knownValues() {
        EnumSet<ConfigurationCheckType> knownValues = EnumSet.allOf(ConfigurationCheckType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConfigurationCheckType.class, ConfigurationCheckType::toString);
    }
}

