/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmsap.SsmSapAsyncClient;
import software.amazon.awssdk.services.ssmsap.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmsap.model.ConfigurationCheckDefinition;
import software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckDefinitionsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckDefinitionsResponse;

public class ListConfigurationCheckDefinitionsPublisher
implements SdkPublisher<ListConfigurationCheckDefinitionsResponse> {
    private final SsmSapAsyncClient client;
    private final ListConfigurationCheckDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConfigurationCheckDefinitionsPublisher(SsmSapAsyncClient client, ListConfigurationCheckDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConfigurationCheckDefinitionsPublisher(SsmSapAsyncClient client, ListConfigurationCheckDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConfigurationCheckDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConfigurationCheckDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConfigurationCheckDefinition> configurationChecks() {
        Function<ListConfigurationCheckDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurationChecks() != null) {
                return response.configurationChecks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListConfigurationCheckDefinitionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConfigurationCheckDefinitionsResponseFetcher
    implements AsyncPageFetcher<ListConfigurationCheckDefinitionsResponse> {
        private ListConfigurationCheckDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationCheckDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConfigurationCheckDefinitionsResponse> nextPage(ListConfigurationCheckDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationCheckDefinitionsPublisher.this.client.listConfigurationCheckDefinitions(ListConfigurationCheckDefinitionsPublisher.this.firstRequest);
            }
            return ListConfigurationCheckDefinitionsPublisher.this.client.listConfigurationCheckDefinitions((ListConfigurationCheckDefinitionsRequest)((Object)ListConfigurationCheckDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

