/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RuleResultStatus {
    PASSED("PASSED"),
    FAILED("FAILED"),
    WARNING("WARNING"),
    INFO("INFO"),
    UNKNOWN("UNKNOWN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RuleResultStatus> VALUE_MAP;
    private final String value;

    private RuleResultStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RuleResultStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RuleResultStatus> knownValues() {
        EnumSet<RuleResultStatus> knownValues = EnumSet.allOf(RuleResultStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RuleResultStatus.class, RuleResultStatus::toString);
    }
}

