/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssoadmin.model.StatusValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PermissionSetProvisioningStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PermissionSetProvisioningStatus> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(PermissionSetProvisioningStatus.getter(PermissionSetProvisioningStatus::accountId)).setter(PermissionSetProvisioningStatus.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(PermissionSetProvisioningStatus.getter(PermissionSetProvisioningStatus::createdDate)).setter(PermissionSetProvisioningStatus.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(PermissionSetProvisioningStatus.getter(PermissionSetProvisioningStatus::failureReason)).setter(PermissionSetProvisioningStatus.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> PERMISSION_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PermissionSetArn").getter(PermissionSetProvisioningStatus.getter(PermissionSetProvisioningStatus::permissionSetArn)).setter(PermissionSetProvisioningStatus.setter(Builder::permissionSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionSetArn").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(PermissionSetProvisioningStatus.getter(PermissionSetProvisioningStatus::requestId)).setter(PermissionSetProvisioningStatus.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(PermissionSetProvisioningStatus.getter(PermissionSetProvisioningStatus::statusAsString)).setter(PermissionSetProvisioningStatus.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, CREATED_DATE_FIELD, FAILURE_REASON_FIELD, PERMISSION_SET_ARN_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PermissionSetProvisioningStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final Instant createdDate;
    private final String failureReason;
    private final String permissionSetArn;
    private final String requestId;
    private final String status;

    private PermissionSetProvisioningStatus(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.createdDate = builder.createdDate;
        this.failureReason = builder.failureReason;
        this.permissionSetArn = builder.permissionSetArn;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String permissionSetArn() {
        return this.permissionSetArn;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final StatusValues status() {
        return StatusValues.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionSetProvisioningStatus)) {
            return false;
        }
        PermissionSetProvisioningStatus other = (PermissionSetProvisioningStatus)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.permissionSetArn(), other.permissionSetArn()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PermissionSetProvisioningStatus").add("AccountId", (Object)this.accountId()).add("CreatedDate", (Object)this.createdDate()).add("FailureReason", (Object)this.failureReason()).add("PermissionSetArn", (Object)this.permissionSetArn()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "PermissionSetArn": {
                return Optional.ofNullable(clazz.cast(this.permissionSetArn()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("PermissionSetArn", PERMISSION_SET_ARN_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PermissionSetProvisioningStatus, T> g) {
        return obj -> g.apply((PermissionSetProvisioningStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private Instant createdDate;
        private String failureReason;
        private String permissionSetArn;
        private String requestId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionSetProvisioningStatus model) {
            this.accountId(model.accountId);
            this.createdDate(model.createdDate);
            this.failureReason(model.failureReason);
            this.permissionSetArn(model.permissionSetArn);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getPermissionSetArn() {
            return this.permissionSetArn;
        }

        public final void setPermissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
        }

        @Override
        public final Builder permissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusValues status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public PermissionSetProvisioningStatus build() {
            return new PermissionSetProvisioningStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PermissionSetProvisioningStatus> {
        public Builder accountId(String var1);

        public Builder createdDate(Instant var1);

        public Builder failureReason(String var1);

        public Builder permissionSetArn(String var1);

        public Builder requestId(String var1);

        public Builder status(String var1);

        public Builder status(StatusValues var1);
    }
}

