/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssoadmin.model.PrincipalType;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeApplicationAssignmentRequest
extends SsoAdminRequest
implements ToCopyableBuilder<Builder, DescribeApplicationAssignmentRequest> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationArn").getter(DescribeApplicationAssignmentRequest.getter(DescribeApplicationAssignmentRequest::applicationArn)).setter(DescribeApplicationAssignmentRequest.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()}).build();
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrincipalId").getter(DescribeApplicationAssignmentRequest.getter(DescribeApplicationAssignmentRequest::principalId)).setter(DescribeApplicationAssignmentRequest.setter(Builder::principalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()}).build();
    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrincipalType").getter(DescribeApplicationAssignmentRequest.getter(DescribeApplicationAssignmentRequest::principalTypeAsString)).setter(DescribeApplicationAssignmentRequest.setter(Builder::principalType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, PRINCIPAL_ID_FIELD, PRINCIPAL_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeApplicationAssignmentRequest.memberNameToFieldInitializer();
    private final String applicationArn;
    private final String principalId;
    private final String principalType;

    private DescribeApplicationAssignmentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationArn = builder.applicationArn;
        this.principalId = builder.principalId;
        this.principalType = builder.principalType;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final String principalId() {
        return this.principalId;
    }

    public final PrincipalType principalType() {
        return PrincipalType.fromValue(this.principalType);
    }

    public final String principalTypeAsString() {
        return this.principalType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationAssignmentRequest)) {
            return false;
        }
        DescribeApplicationAssignmentRequest other = (DescribeApplicationAssignmentRequest)((Object)obj);
        return Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.principalId(), other.principalId()) && Objects.equals(this.principalTypeAsString(), other.principalTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeApplicationAssignmentRequest").add("ApplicationArn", (Object)this.applicationArn()).add("PrincipalId", (Object)this.principalId()).add("PrincipalType", (Object)this.principalTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "PrincipalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
            case "PrincipalType": {
                return Optional.ofNullable(clazz.cast(this.principalTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        map.put("PrincipalId", PRINCIPAL_ID_FIELD);
        map.put("PrincipalType", PRINCIPAL_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationAssignmentRequest, T> g) {
        return obj -> g.apply((DescribeApplicationAssignmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminRequest.BuilderImpl
    implements Builder {
        private String applicationArn;
        private String principalId;
        private String principalType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationAssignmentRequest model) {
            super(model);
            this.applicationArn(model.applicationArn);
            this.principalId(model.principalId);
            this.principalType(model.principalType);
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getPrincipalType() {
            return this.principalType;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType == null ? null : principalType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeApplicationAssignmentRequest build() {
            return new DescribeApplicationAssignmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsoAdminRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeApplicationAssignmentRequest> {
        public Builder applicationArn(String var1);

        public Builder principalId(String var1);

        public Builder principalType(String var1);

        public Builder principalType(PrincipalType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

