/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.DiskIdsCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeUploadBufferResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DescribeUploadBufferResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(DescribeUploadBufferResponse.getter(DescribeUploadBufferResponse::gatewayARN)).setter(DescribeUploadBufferResponse.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<List<String>> DISK_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DiskIds").getter(DescribeUploadBufferResponse.getter(DescribeUploadBufferResponse::diskIds)).setter(DescribeUploadBufferResponse.setter(Builder::diskIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> UPLOAD_BUFFER_USED_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("UploadBufferUsedInBytes").getter(DescribeUploadBufferResponse.getter(DescribeUploadBufferResponse::uploadBufferUsedInBytes)).setter(DescribeUploadBufferResponse.setter(Builder::uploadBufferUsedInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadBufferUsedInBytes").build()}).build();
    private static final SdkField<Long> UPLOAD_BUFFER_ALLOCATED_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("UploadBufferAllocatedInBytes").getter(DescribeUploadBufferResponse.getter(DescribeUploadBufferResponse::uploadBufferAllocatedInBytes)).setter(DescribeUploadBufferResponse.setter(Builder::uploadBufferAllocatedInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadBufferAllocatedInBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, DISK_IDS_FIELD, UPLOAD_BUFFER_USED_IN_BYTES_FIELD, UPLOAD_BUFFER_ALLOCATED_IN_BYTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeUploadBufferResponse.memberNameToFieldInitializer();
    private final String gatewayARN;
    private final List<String> diskIds;
    private final Long uploadBufferUsedInBytes;
    private final Long uploadBufferAllocatedInBytes;

    private DescribeUploadBufferResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.diskIds = builder.diskIds;
        this.uploadBufferUsedInBytes = builder.uploadBufferUsedInBytes;
        this.uploadBufferAllocatedInBytes = builder.uploadBufferAllocatedInBytes;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final boolean hasDiskIds() {
        return this.diskIds != null && !(this.diskIds instanceof SdkAutoConstructList);
    }

    public final List<String> diskIds() {
        return this.diskIds;
    }

    public final Long uploadBufferUsedInBytes() {
        return this.uploadBufferUsedInBytes;
    }

    public final Long uploadBufferAllocatedInBytes() {
        return this.uploadBufferAllocatedInBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDiskIds() ? this.diskIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadBufferUsedInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadBufferAllocatedInBytes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUploadBufferResponse)) {
            return false;
        }
        DescribeUploadBufferResponse other = (DescribeUploadBufferResponse)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && this.hasDiskIds() == other.hasDiskIds() && Objects.equals(this.diskIds(), other.diskIds()) && Objects.equals(this.uploadBufferUsedInBytes(), other.uploadBufferUsedInBytes()) && Objects.equals(this.uploadBufferAllocatedInBytes(), other.uploadBufferAllocatedInBytes());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeUploadBufferResponse").add("GatewayARN", (Object)this.gatewayARN()).add("DiskIds", this.hasDiskIds() ? this.diskIds() : null).add("UploadBufferUsedInBytes", (Object)this.uploadBufferUsedInBytes()).add("UploadBufferAllocatedInBytes", (Object)this.uploadBufferAllocatedInBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "DiskIds": {
                return Optional.ofNullable(clazz.cast(this.diskIds()));
            }
            case "UploadBufferUsedInBytes": {
                return Optional.ofNullable(clazz.cast(this.uploadBufferUsedInBytes()));
            }
            case "UploadBufferAllocatedInBytes": {
                return Optional.ofNullable(clazz.cast(this.uploadBufferAllocatedInBytes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GatewayARN", GATEWAY_ARN_FIELD);
        map.put("DiskIds", DISK_IDS_FIELD);
        map.put("UploadBufferUsedInBytes", UPLOAD_BUFFER_USED_IN_BYTES_FIELD);
        map.put("UploadBufferAllocatedInBytes", UPLOAD_BUFFER_ALLOCATED_IN_BYTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeUploadBufferResponse, T> g) {
        return obj -> g.apply((DescribeUploadBufferResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private List<String> diskIds = DefaultSdkAutoConstructList.getInstance();
        private Long uploadBufferUsedInBytes;
        private Long uploadBufferAllocatedInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUploadBufferResponse model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.diskIds(model.diskIds);
            this.uploadBufferUsedInBytes(model.uploadBufferUsedInBytes);
            this.uploadBufferAllocatedInBytes(model.uploadBufferAllocatedInBytes);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final Collection<String> getDiskIds() {
            if (this.diskIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.diskIds;
        }

        public final void setDiskIds(Collection<String> diskIds) {
            this.diskIds = DiskIdsCopier.copy(diskIds);
        }

        @Override
        public final Builder diskIds(Collection<String> diskIds) {
            this.diskIds = DiskIdsCopier.copy(diskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskIds(String ... diskIds) {
            this.diskIds(Arrays.asList(diskIds));
            return this;
        }

        public final Long getUploadBufferUsedInBytes() {
            return this.uploadBufferUsedInBytes;
        }

        public final void setUploadBufferUsedInBytes(Long uploadBufferUsedInBytes) {
            this.uploadBufferUsedInBytes = uploadBufferUsedInBytes;
        }

        @Override
        public final Builder uploadBufferUsedInBytes(Long uploadBufferUsedInBytes) {
            this.uploadBufferUsedInBytes = uploadBufferUsedInBytes;
            return this;
        }

        public final Long getUploadBufferAllocatedInBytes() {
            return this.uploadBufferAllocatedInBytes;
        }

        public final void setUploadBufferAllocatedInBytes(Long uploadBufferAllocatedInBytes) {
            this.uploadBufferAllocatedInBytes = uploadBufferAllocatedInBytes;
        }

        @Override
        public final Builder uploadBufferAllocatedInBytes(Long uploadBufferAllocatedInBytes) {
            this.uploadBufferAllocatedInBytes = uploadBufferAllocatedInBytes;
            return this;
        }

        @Override
        public DescribeUploadBufferResponse build() {
            return new DescribeUploadBufferResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeUploadBufferResponse> {
        public Builder gatewayARN(String var1);

        public Builder diskIds(Collection<String> var1);

        public Builder diskIds(String ... var1);

        public Builder uploadBufferUsedInBytes(Long var1);

        public Builder uploadBufferAllocatedInBytes(Long var1);
    }
}

